/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.CalendarFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;

public class ProjectDialog
extends JDialog {
    public boolean CANCELLED = true;
    boolean ignoreStartChanged = false;
    boolean ignoreEndChanged = false;
    CalendarFrame endCalFrame = new CalendarFrame();
    CalendarFrame startCalFrame = new CalendarFrame();
    GridBagConstraints gbc;
    JPanel topPanel = new JPanel(new FlowLayout(0));
    JLabel header = new JLabel();
    JPanel centerPanel = new JPanel(new GridBagLayout());
    JLabel titleLabel = new JLabel();
    public JTextField prTitleField = new JTextField();
    JLabel sdLabel = new JLabel();
    public JSpinner startDate = new JSpinner(new SpinnerDateModel());
    JButton sdButton = new JButton();
    public JCheckBox endDateChB = new JCheckBox();
    public JSpinner endDate = new JSpinner(new SpinnerDateModel());
    JButton edButton = new JButton();
    JPanel bottomPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();

    public ProjectDialog(Frame frame, String string) {
        super(frame, string, true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.topPanel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        this.topPanel.setBackground(Color.WHITE);
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("Project"));
        this.header.setIcon(new ImageIcon(ProjectDialog.class.getResource("resources/icons/project48.png")));
        this.topPanel.add(this.header);
        this.centerPanel.setBorder(new EtchedBorder());
        this.titleLabel.setText(Local.getString("Title"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 5;
        this.gbc.insets = new Insets(5, 10, 5, 10);
        this.gbc.anchor = 18;
        this.centerPanel.add((Component)this.titleLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 5;
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 10, 5, 0);
        this.gbc.anchor = 10;
        this.centerPanel.add((Component)this.prTitleField, this.gbc);
        this.sdLabel.setText(Local.getString("Start date"));
        this.sdLabel.setPreferredSize(new Dimension(70, 20));
        this.sdLabel.setMinimumSize(new Dimension(70, 20));
        this.sdLabel.setMaximumSize(new Dimension(70, 20));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 10, 10, 10);
        this.centerPanel.add((Component)this.sdLabel, this.gbc);
        this.startDate.setPreferredSize(new Dimension(80, 20));
        this.startDate.setLocale(Local.getCurrentLocale());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, simpleDateFormat.toPattern()));
        this.startDate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Date date;
                if (ProjectDialog.this.ignoreStartChanged) {
                    return;
                }
                ProjectDialog.this.ignoreStartChanged = true;
                Date date2 = (Date)ProjectDialog.this.startDate.getModel().getValue();
                if (ProjectDialog.this.endDate.isEnabled() && date2.after(date = (Date)ProjectDialog.this.endDate.getModel().getValue())) {
                    ProjectDialog.this.startDate.getModel().setValue(date);
                    date2 = date;
                }
                ProjectDialog.this.startCalFrame.cal.set(new CalendarDate(date2));
                ProjectDialog.this.ignoreStartChanged = false;
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 10, 5);
        this.centerPanel.add((Component)this.startDate, this.gbc);
        this.sdButton.setMinimumSize(new Dimension(20, 20));
        this.sdButton.setPreferredSize(new Dimension(20, 20));
        this.sdButton.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/calendar.png")));
        this.sdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.sdButton_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 10, 25);
        this.gbc.anchor = 17;
        this.centerPanel.add((Component)this.sdButton, this.gbc);
        this.endDateChB.setForeground(Color.gray);
        this.endDateChB.setText(Local.getString("End date"));
        this.endDateChB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.endDateChB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 3;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 10, 5);
        this.gbc.anchor = 17;
        this.centerPanel.add((Component)this.endDateChB, this.gbc);
        this.endDate.setEnabled(false);
        this.endDate.setPreferredSize(new Dimension(80, 20));
        this.endDate.setLocale(Local.getCurrentLocale());
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, simpleDateFormat.toPattern()));
        this.endDate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Date date;
                if (ProjectDialog.this.ignoreEndChanged) {
                    return;
                }
                ProjectDialog.this.ignoreEndChanged = true;
                Date date2 = (Date)ProjectDialog.this.startDate.getModel().getValue();
                if (date2.after(date = (Date)ProjectDialog.this.endDate.getModel().getValue())) {
                    ProjectDialog.this.endDate.getModel().setValue(date2);
                    date = date2;
                }
                ProjectDialog.this.endCalFrame.cal.set(new CalendarDate(date));
                ProjectDialog.this.ignoreEndChanged = false;
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 4;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 10, 5);
        this.gbc.anchor = 17;
        this.centerPanel.add((Component)this.endDate, this.gbc);
        this.edButton.setEnabled(false);
        this.edButton.setMinimumSize(new Dimension(20, 20));
        this.edButton.setMaximumSize(new Dimension(20, 20));
        this.edButton.setPreferredSize(new Dimension(20, 20));
        this.edButton.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/calendar.png")));
        this.edButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.edButton_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 5;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 10, 10);
        this.gbc.anchor = 17;
        this.centerPanel.add((Component)this.edButton, this.gbc);
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setText(Local.getString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setText(Local.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.okButton);
        this.bottomPanel.add(this.cancelButton);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.fill = 2;
        this.getContentPane().add((Component)this.topPanel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.centerPanel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 13;
        this.getContentPane().add((Component)this.bottomPanel, this.gbc);
        this.startCalFrame.cal.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProjectDialog.this.ignoreStartChanged) {
                    return;
                }
                ProjectDialog.this.startDate.getModel().setValue(ProjectDialog.this.startCalFrame.cal.get().getCalendar().getTime());
            }
        });
        this.endCalFrame.cal.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProjectDialog.this.ignoreEndChanged) {
                    return;
                }
                ProjectDialog.this.endDate.getModel().setValue(ProjectDialog.this.endCalFrame.cal.get().getCalendar().getTime());
            }
        });
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = false;
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void endDateChB_actionPerformed(ActionEvent actionEvent) {
        this.endDate.setEnabled(this.endDateChB.isSelected());
        this.edButton.setEnabled(this.endDateChB.isSelected());
        if (this.endDateChB.isSelected()) {
            this.endDateChB.setForeground(Color.BLACK);
            this.endDate.getModel().setValue(this.startDate.getModel().getValue());
        } else {
            this.endDateChB.setForeground(Color.GRAY);
        }
    }

    void sdButton_actionPerformed(ActionEvent actionEvent) {
        this.startCalFrame.setLocation(0, 0);
        this.startCalFrame.setSize(this.getContentPane().getWidth() / 2, this.getContentPane().getHeight());
        this.getLayeredPane().add(this.startCalFrame);
        this.startCalFrame.setTitle(Local.getString("Start date"));
        this.startCalFrame.show();
    }

    void edButton_actionPerformed(ActionEvent actionEvent) {
        this.endCalFrame.setLocation(this.getContentPane().getWidth() / 2, 0);
        this.endCalFrame.setSize(this.getContentPane().getWidth() / 2, this.getContentPane().getHeight());
        this.getLayeredPane().add(this.endCalFrame);
        this.endCalFrame.setTitle(Local.getString("End date"));
        this.endCalFrame.show();
    }

    public static void newProject() {
        ProjectDialog projectDialog = new ProjectDialog(null, Local.getString("New project"));
        Dimension dimension = projectDialog.getSize();
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        projectDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        projectDialog.setVisible(true);
        if (projectDialog.CANCELLED) {
            return;
        }
        String string = projectDialog.prTitleField.getText();
        CalendarDate calendarDate = new CalendarDate((Date)projectDialog.startDate.getModel().getValue());
        CalendarDate calendarDate2 = null;
        if (projectDialog.endDateChB.isSelected()) {
            calendarDate2 = new CalendarDate((Date)projectDialog.endDate.getModel().getValue());
        }
        Project project = ProjectManager.createProject(string, calendarDate, calendarDate2);
        CurrentStorage.get().storeProjectManager();
    }
}

