/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Resource;
import net.sf.memoranda.ui.AddResourceDialog;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.ResourceTypeDialog;
import net.sf.memoranda.ui.ResourcesTable;
import net.sf.memoranda.ui.SetAppDialog;
import net.sf.memoranda.util.AppList;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.MimeType;
import net.sf.memoranda.util.MimeTypesList;
import net.sf.memoranda.util.Util;

public class ResourcesPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar toolBar = new JToolBar();
    JButton newResB = new JButton();
    ResourcesTable resourcesTable = new ResourcesTable();
    JButton removeResB = new JButton();
    JScrollPane scrollPane = new JScrollPane();
    JButton refreshB = new JButton();
    JPopupMenu resPPMenu = new JPopupMenu();
    JMenuItem ppRun = new JMenuItem();
    JMenuItem ppRemoveRes = new JMenuItem();
    JMenuItem ppNewRes = new JMenuItem();
    JMenuItem ppRefresh = new JMenuItem();

    public ResourcesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.toolBar.setFloatable(false);
        this.setLayout(this.borderLayout1);
        this.newResB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/addresource.png")));
        this.newResB.setEnabled(true);
        this.newResB.setMaximumSize(new Dimension(24, 24));
        this.newResB.setMinimumSize(new Dimension(24, 24));
        this.newResB.setToolTipText(Local.getString("New resource"));
        this.newResB.setRequestFocusEnabled(false);
        this.newResB.setPreferredSize(new Dimension(24, 24));
        this.newResB.setFocusable(false);
        this.newResB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.newResB_actionPerformed(actionEvent);
            }
        });
        this.newResB.setBorderPainted(false);
        this.resourcesTable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.resourcesTable.setRowHeight(24);
        this.removeResB.setBorderPainted(false);
        this.removeResB.setFocusable(false);
        this.removeResB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.removeResB_actionPerformed(actionEvent);
            }
        });
        this.removeResB.setPreferredSize(new Dimension(24, 24));
        this.removeResB.setRequestFocusEnabled(false);
        this.removeResB.setToolTipText(Local.getString("Remove resource"));
        this.removeResB.setMinimumSize(new Dimension(24, 24));
        this.removeResB.setMaximumSize(new Dimension(24, 24));
        this.removeResB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/removeresource.png")));
        this.removeResB.setEnabled(false);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.toolBar.addSeparator(new Dimension(8, 24));
        this.toolBar.addSeparator(new Dimension(8, 24));
        PopupListener popupListener = new PopupListener();
        this.scrollPane.addMouseListener(popupListener);
        this.resourcesTable.addMouseListener(popupListener);
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = ResourcesPanel.this.resourcesTable.getRowCount() > 0 && ResourcesPanel.this.resourcesTable.getSelectedRow() > -1;
                ResourcesPanel.this.removeResB.setEnabled(bl);
                ResourcesPanel.this.ppRemoveRes.setEnabled(bl);
                ResourcesPanel.this.ppRun.setEnabled(bl);
            }
        });
        this.refreshB.setBorderPainted(false);
        this.refreshB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.refreshB_actionPerformed(actionEvent);
            }
        });
        this.refreshB.setFocusable(false);
        this.refreshB.setPreferredSize(new Dimension(24, 24));
        this.refreshB.setRequestFocusEnabled(false);
        this.refreshB.setToolTipText(Local.getString("Refresh"));
        this.refreshB.setMinimumSize(new Dimension(24, 24));
        this.refreshB.setMaximumSize(new Dimension(24, 24));
        this.refreshB.setEnabled(true);
        this.refreshB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/refreshres.png")));
        this.resPPMenu.setFont(new Font("Dialog", 1, 10));
        this.ppRun.setFont(new Font("Dialog", 1, 11));
        this.ppRun.setText(Local.getString("Open resource") + "...");
        this.ppRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.ppRun_actionPerformed(actionEvent);
            }
        });
        this.ppRun.setEnabled(false);
        this.ppRemoveRes.setFont(new Font("Dialog", 1, 11));
        this.ppRemoveRes.setText(Local.getString("Remove resource"));
        this.ppRemoveRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.ppRemoveRes_actionPerformed(actionEvent);
            }
        });
        this.ppRemoveRes.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/removeresource.png")));
        this.ppRemoveRes.setEnabled(false);
        this.ppNewRes.setFont(new Font("Dialog", 1, 11));
        this.ppNewRes.setText(Local.getString("New resource") + "...");
        this.ppNewRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.ppNewRes_actionPerformed(actionEvent);
            }
        });
        this.ppNewRes.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/addresource.png")));
        this.ppRefresh.setFont(new Font("Dialog", 1, 11));
        this.ppRefresh.setText(Local.getString("Refresh"));
        this.ppRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.ppRefresh_actionPerformed(actionEvent);
            }
        });
        this.ppRefresh.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/refreshres.png")));
        this.toolBar.add((Component)this.newResB, null);
        this.toolBar.add((Component)this.removeResB, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.refreshB, null);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.resourcesTable, null);
        this.add((Component)this.toolBar, "North");
        this.resPPMenu.add(this.ppRun);
        this.resPPMenu.addSeparator();
        this.resPPMenu.add(this.ppNewRes);
        this.resPPMenu.add(this.ppRemoveRes);
        this.resPPMenu.addSeparator();
        this.resPPMenu.add(this.ppRefresh);
        this.resourcesTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ResourcesPanel.this.resourcesTable.getSelectedRows().length > 0 && keyEvent.getKeyCode() == 127) {
                    ResourcesPanel.this.ppRemoveRes_actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    void newResB_actionPerformed(ActionEvent actionEvent) {
        AddResourceDialog addResourceDialog = new AddResourceDialog((Frame)App.getFrame(), Local.getString("New resource"));
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        addResourceDialog.setLocation((dimension.width - addResourceDialog.getSize().width) / 2 + point.x, (dimension.height - addResourceDialog.getSize().height) / 2 + point.y);
        addResourceDialog.setVisible(true);
        if (addResourceDialog.CANCELLED) {
            return;
        }
        if (addResourceDialog.localFileRB.isSelected()) {
            String string = addResourceDialog.pathField.getText();
            MimeType mimeType = MimeTypesList.getMimeTypeForFile(string);
            if (mimeType.getMimeTypeId().equals("__UNKNOWN") && (mimeType = this.addResourceType(string)) == null) {
                return;
            }
            if (!this.checkApp(mimeType)) {
                return;
            }
            if (addResourceDialog.projectFileCB.isSelected()) {
                string = this.copyFileToProjectDir(string);
                CurrentProject.getResourcesList().addResource(string, false, true);
            } else {
                CurrentProject.getResourcesList().addResource(string);
            }
            this.resourcesTable.tableChanged();
        } else {
            if (!Util.checkBrowser()) {
                return;
            }
            CurrentProject.getResourcesList().addResource(addResourceDialog.urlField.getText(), true, false);
            this.resourcesTable.tableChanged();
        }
    }

    void removeResB_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.resourcesTable.getSelectedRows();
        String string = "";
        string = nArray.length == 1 ? Local.getString("Remove the shortcut to resource") + "\n'" + this.resourcesTable.getModel().getValueAt(nArray[0], 0) + "'" : Local.getString("Remove") + " " + nArray.length + " " + Local.getString("shortcuts");
        string = string + "\n" + Local.getString("Are you sure?");
        int n = JOptionPane.showConfirmDialog(App.getFrame(), string, Local.getString("Remove resource"), 0);
        if (n != 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            CurrentProject.getResourcesList().removeResource(((Resource)this.resourcesTable.getModel().getValueAt(nArray[i], 100)).getPath());
        }
        this.resourcesTable.tableChanged();
    }

    MimeType addResourceType(String string) {
        ResourceTypeDialog resourceTypeDialog = new ResourceTypeDialog(App.getFrame(), Local.getString("Resource type"));
        Dimension dimension = new Dimension(420, 300);
        resourceTypeDialog.setSize(dimension);
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        resourceTypeDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        resourceTypeDialog.ext = MimeTypesList.getExtension(string);
        resourceTypeDialog.setVisible(true);
        if (resourceTypeDialog.CANCELLED) {
            return null;
        }
        int n = resourceTypeDialog.getTypesList().getSelectedIndex();
        MimeType mimeType = (MimeType)MimeTypesList.getAllMimeTypes().toArray()[n];
        mimeType.addExtension(MimeTypesList.getExtension(string));
        CurrentStorage.get().storeMimeTypesList();
        return mimeType;
    }

    boolean checkApp(MimeType mimeType) {
        Serializable serializable;
        File file;
        String string = mimeType.getAppId();
        AppList appList = MimeTypesList.getAppList();
        if (string == null) {
            string = Util.generateId();
            file = new File("/");
        } else {
            serializable = new File(appList.getFindPath(string) + "/" + appList.getExec(string));
            if (((File)serializable).isFile()) {
                return true;
            }
            file = new File(((File)serializable).getParent());
            while (!file.exists()) {
                file = new File(file.getParent());
            }
        }
        serializable = new SetAppDialog((Frame)App.getFrame(), Local.getString(Local.getString("Select the application to open files of type") + " '" + mimeType.getLabel() + "'"));
        Dimension dimension = new Dimension(420, 300);
        ((Window)serializable).setSize(dimension);
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        ((Window)serializable).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        ((SetAppDialog)serializable).setDirectory(file);
        ((SetAppDialog)serializable).appPanel.argumentsField.setText("$1");
        ((Dialog)serializable).setVisible(true);
        if (((SetAppDialog)serializable).CANCELLED) {
            return false;
        }
        File file2 = new File(((SetAppDialog)serializable).appPanel.applicationField.getText());
        appList.addOrReplaceApp(string, file2.getParent().replace('\\', '/'), file2.getName().replace('\\', '/'), ((SetAppDialog)serializable).appPanel.argumentsField.getText());
        mimeType.setApp(string);
        CurrentStorage.get().storeMimeTypesList();
        return true;
    }

    void runApp(String string) {
        MimeType mimeType = MimeTypesList.getMimeTypeForFile(string);
        if (mimeType.getMimeTypeId().equals("__UNKNOWN") && (mimeType = this.addResourceType(string)) == null) {
            return;
        }
        if (!this.checkApp(mimeType)) {
            return;
        }
        String[] stringArray = MimeTypesList.getAppList().getCommand(mimeType.getAppId(), string);
        if (stringArray == null) {
            return;
        }
        System.out.println("Run: " + stringArray[0]);
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to run an external application <br><code>" + stringArray[0] + "</code>", "Check the application path and command line parameters for this resource type (File-&gt;Preferences-&gt;Resource types).");
        }
    }

    void runBrowser(String string) {
        Util.runBrowser(string);
    }

    void refreshB_actionPerformed(ActionEvent actionEvent) {
        this.resourcesTable.tableChanged();
    }

    void ppRun_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.resourcesTable.getValueAt(this.resourcesTable.getSelectedRow(), 3);
        if (string.length() > 0) {
            this.runApp(string);
        } else {
            this.runBrowser((String)this.resourcesTable.getValueAt(this.resourcesTable.getSelectedRow(), 0));
        }
    }

    void ppRemoveRes_actionPerformed(ActionEvent actionEvent) {
        this.removeResB_actionPerformed(actionEvent);
    }

    void ppNewRes_actionPerformed(ActionEvent actionEvent) {
        this.newResB_actionPerformed(actionEvent);
    }

    void ppRefresh_actionPerformed(ActionEvent actionEvent) {
        this.resourcesTable.tableChanged();
    }

    String copyFileToProjectDir(String string) {
        String string2 = Util.getEnvDir();
        int n = string.lastIndexOf(File.separator);
        String string3 = n != -1 ? string.substring(n + 1) : string;
        String string4 = string2 + CurrentProject.get().getID() + File.separator + "_projectFiles" + File.separator + string3;
        File file = new File(string2 + CurrentProject.get().getID() + File.separator + "_projectFiles");
        if (!file.exists()) {
            file.mkdirs();
        }
        System.out.println("[DEBUG] Copy file from: " + string + " to: " + string4);
        try {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            byte[] byArray = new byte[4096];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        return string4;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && ResourcesPanel.this.resourcesTable.getSelectedRow() > -1) {
                String string = (String)ResourcesPanel.this.resourcesTable.getValueAt(ResourcesPanel.this.resourcesTable.getSelectedRow(), 3);
                if (string.length() > 0) {
                    ResourcesPanel.this.runApp(string);
                } else {
                    ResourcesPanel.this.runBrowser((String)ResourcesPanel.this.resourcesTable.getValueAt(ResourcesPanel.this.resourcesTable.getSelectedRow(), 0));
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ResourcesPanel.this.resPPMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

