/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor.filechooser;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.TitledBorder;
import net.sf.memoranda.ui.htmleditor.util.Local;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;

    public ImagePreview(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), Local.getString("Preview"), 2, 1));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            return;
        }
        ImageIcon imageIcon = new ImageIcon(this.file.getPath());
        this.thumbnail = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : imageIcon;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            this.file = (File)propertyChangeEvent.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }
}

