/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.NoteListImpl;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.ResourcesListImpl;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.TaskListImpl;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.htmleditor.AltHTMLWriter;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.MimeTypesList;
import net.sf.memoranda.util.Storage;
import net.sf.memoranda.util.Util;
import nu.xom.Builder;

public class FileStorage
implements Storage {
    public static String JN_DOCPATH = Util.getEnvDir();
    private HTMLEditorKit editorKit = new HTMLEditorKit();

    public FileStorage() {
        String string = (String)Configuration.get("MEMORANDA_HOME");
        if (string.length() > 0) {
            JN_DOCPATH = string;
            System.out.println("[DEBUG]***Memoranda storage path has set to: " + JN_DOCPATH);
        }
    }

    public static void saveDocument(nu.xom.Document document, String string) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            outputStreamWriter.write(document.toXML());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            new ExceptionDialog(iOException, "Failed to write a document to " + string, "");
        }
    }

    public static nu.xom.Document openDocument(InputStream inputStream) throws Exception {
        Builder builder = new Builder();
        return builder.build((Reader)new InputStreamReader(inputStream, "UTF-8"));
    }

    public static nu.xom.Document openDocument(String string) {
        try {
            return FileStorage.openDocument(new FileInputStream(string));
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to read a document from " + string, "");
            return null;
        }
    }

    public static boolean documentExists(String string) {
        return new File(string).exists();
    }

    public void storeNote(Note note, Document document) {
        String string = JN_DOCPATH + note.getProject().getID() + File.separator;
        document.putProperty("title", note.getTitle());
        CalendarDate calendarDate = note.getDate();
        string = string + note.getId();
        System.out.println("[DEBUG] Save note: " + string);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            AltHTMLWriter altHTMLWriter = new AltHTMLWriter((Writer)outputStreamWriter, (HTMLDocument)document);
            altHTMLWriter.write();
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to write a document to " + string, "");
        }
    }

    public Document openNote(Note note) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.editorKit.createDefaultDocument();
        if (note == null) {
            return hTMLDocument;
        }
        String string = this.getNotePath(note);
        try {
            hTMLDocument.setBase(new URL(this.getNoteURL(note)));
            this.editorKit.read(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"), (Document)hTMLDocument, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hTMLDocument;
    }

    public String getNoteURL(Note note) {
        return "file:" + JN_DOCPATH + note.getProject().getID() + "/" + note.getId();
    }

    public String getNotePath(Note note) {
        String string = JN_DOCPATH + note.getProject().getID() + File.separator;
        string = string + note.getId();
        return string;
    }

    public void removeNote(Note note) {
        File file = new File(this.getNotePath(note));
        System.out.println("[DEBUG] Remove note:" + this.getNotePath(note));
        file.delete();
    }

    public void openProjectManager() {
        if (!new File(JN_DOCPATH + ".projects").exists()) {
            ProjectManager._doc = null;
            return;
        }
        System.out.println("[DEBUG] Open project manager: " + JN_DOCPATH + ".projects");
        ProjectManager._doc = FileStorage.openDocument(JN_DOCPATH + ".projects");
    }

    public void storeProjectManager() {
        System.out.println("[DEBUG] Save project manager: " + JN_DOCPATH + ".projects");
        FileStorage.saveDocument(ProjectManager._doc, JN_DOCPATH + ".projects");
    }

    public void removeProjectStorage(Project project) {
        String string = project.getID();
        File file = new File(JN_DOCPATH + string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        file.delete();
    }

    public TaskList openTaskList(Project project) {
        String string = JN_DOCPATH + project.getID() + File.separator + ".tasklist";
        if (FileStorage.documentExists(string)) {
            System.out.println("[DEBUG] Open task list: " + JN_DOCPATH + project.getID() + File.separator + ".tasklist");
            nu.xom.Document document = FileStorage.openDocument(string);
            return new TaskListImpl(document, project);
        }
        System.out.println("[DEBUG] New task list created");
        return new TaskListImpl(project);
    }

    public void storeTaskList(TaskList taskList, Project project) {
        System.out.println("[DEBUG] Save task list: " + JN_DOCPATH + project.getID() + File.separator + ".tasklist");
        nu.xom.Document document = taskList.getXMLContent();
        FileStorage.saveDocument(document, JN_DOCPATH + project.getID() + File.separator + ".tasklist");
    }

    public void createProjectStorage(Project project) {
        System.out.println("[DEBUG] Create project dir: " + JN_DOCPATH + project.getID());
        File file = new File(JN_DOCPATH + project.getID());
        file.mkdirs();
    }

    public NoteList openNoteList(Project project) {
        String string = JN_DOCPATH + project.getID() + File.separator + ".notes";
        if (FileStorage.documentExists(string)) {
            System.out.println("[DEBUG] Open note list: " + JN_DOCPATH + project.getID() + File.separator + ".notes");
            return new NoteListImpl(FileStorage.openDocument(string), project);
        }
        System.out.println("[DEBUG] New note list created");
        return new NoteListImpl(project);
    }

    public void storeNoteList(NoteList noteList, Project project) {
        System.out.println("[DEBUG] Save note list: " + JN_DOCPATH + project.getID() + File.separator + ".notes");
        FileStorage.saveDocument(noteList.getXMLContent(), JN_DOCPATH + project.getID() + File.separator + ".notes");
    }

    public void openEventsManager() {
        if (!new File(JN_DOCPATH + ".events").exists()) {
            EventsManager._doc = null;
            return;
        }
        System.out.println("[DEBUG] Open events manager: " + JN_DOCPATH + ".events");
        EventsManager._doc = FileStorage.openDocument(JN_DOCPATH + ".events");
    }

    public void storeEventsManager() {
        System.out.println("[DEBUG] Save events manager: " + JN_DOCPATH + ".events");
        FileStorage.saveDocument(EventsManager._doc, JN_DOCPATH + ".events");
    }

    public void openMimeTypesList() {
        if (!new File(JN_DOCPATH + ".mimetypes").exists()) {
            try {
                MimeTypesList._doc = FileStorage.openDocument(FileStorage.class.getResourceAsStream("resources/default.mimetypes"));
            }
            catch (Exception exception) {
                new ExceptionDialog(exception, "Failed to read default mimetypes config from resources", "");
            }
            return;
        }
        System.out.println("[DEBUG] Open mimetypes list: " + JN_DOCPATH + ".mimetypes");
        MimeTypesList._doc = FileStorage.openDocument(JN_DOCPATH + ".mimetypes");
    }

    public void storeMimeTypesList() {
        System.out.println("[DEBUG] Save mimetypes list: " + JN_DOCPATH + ".mimetypes");
        FileStorage.saveDocument(MimeTypesList._doc, JN_DOCPATH + ".mimetypes");
    }

    public ResourcesList openResourcesList(Project project) {
        String string = JN_DOCPATH + project.getID() + File.separator + ".resources";
        if (FileStorage.documentExists(string)) {
            System.out.println("[DEBUG] Open resources list: " + string);
            return new ResourcesListImpl(FileStorage.openDocument(string), project);
        }
        System.out.println("[DEBUG] New note list created");
        return new ResourcesListImpl(project);
    }

    public void storeResourcesList(ResourcesList resourcesList, Project project) {
        System.out.println("[DEBUG] Save resources list: " + JN_DOCPATH + project.getID() + File.separator + ".resources");
        FileStorage.saveDocument(resourcesList.getXMLContent(), JN_DOCPATH + project.getID() + File.separator + ".resources");
    }

    public void restoreContext() {
        try {
            System.out.println("[DEBUG] Open context: " + JN_DOCPATH + ".context");
            Context.context.load(new FileInputStream(JN_DOCPATH + ".context"));
        }
        catch (Exception exception) {
            System.out.println("Context created.");
        }
    }

    public void storeContext() {
        try {
            System.out.println("[DEBUG] Save context: " + JN_DOCPATH + ".context");
            Context.context.save(new FileOutputStream(JN_DOCPATH + ".context"));
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to store context to " + JN_DOCPATH + ".context", "");
        }
    }
}

