/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.CompletionListModel;

public class CompletionWindow
extends JDialog {
    private JTextComponent textComponent;
    private Vector allCompletionItems;
    private final JDialog taskDialog;
    private JList jlCompletion;
    private JScrollPane spCompletion;

    public CompletionWindow(JTextComponent textComponent, Vector allCompletionItems, JDialog taskDialog) {
        this.textComponent = textComponent;
        this.allCompletionItems = allCompletionItems;
        this.taskDialog = taskDialog;
        this.initComponents();
        this.jlCompletion.setSelectionMode(0);
        this.jlCompletion.setModel(new CompletionListModel());
        this.setCompletionItems(this.getCompletionItems(this.getIncompleteWord()));
        this.jlCompletion.setSelectedIndex(0);
    }

    private void initComponents() {
        this.spCompletion = new JScrollPane();
        this.jlCompletion = new JList();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setUndecorated(true);
        this.spCompletion.setHorizontalScrollBarPolicy(31);
        this.jlCompletion.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CompletionWindow.this.jlCompletionMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CompletionWindow.this.jlCompletionMouseExited(evt);
            }
        });
        this.jlCompletion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CompletionWindow.this.jlCompletionFocusLost(evt);
            }
        });
        this.jlCompletion.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                CompletionWindow.this.jlCompletionKeyPressed(evt);
            }
        });
        this.spCompletion.setViewportView(this.jlCompletion);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.spCompletion, gridBagConstraints);
        this.pack();
    }

    private void jlCompletionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.completeItem((String)this.jlCompletion.getSelectedValue());
        }
    }

    private void jlCompletionMouseExited(MouseEvent evt) {
        this.setVisible(false);
    }

    private void jlCompletionFocusLost(FocusEvent evt) {
        this.setVisible(false);
    }

    private void jlCompletionKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        char keyChar = evt.getKeyChar();
        if (keyChar == ' ' | keyChar == '\u007f') {
            return;
        }
        if (keyChar > '\u001e' & keyChar < '\u0100' | keyCode == 8) {
            this.reduceCompletionBy(evt.getKeyChar());
        }
        if (keyCode == 10) {
            String value = (String)this.jlCompletion.getSelectedValue();
            if (value.equals(Translator.getTranslation("COMPLETION.NONE"))) {
                return;
            }
            this.completeItem(value);
        }
        if (evt.getKeyCode() == 38 & this.jlCompletion.getSelectedIndex() == 0) {
            this.jlCompletion.setSelectedValue(this.jlCompletion.getModel().getElementAt(this.jlCompletion.getModel().getSize() - 1), true);
            evt.consume();
        }
        if (evt.getKeyCode() == 40 & this.jlCompletion.getSelectedIndex() == this.jlCompletion.getModel().getSize() - 1) {
            this.jlCompletion.setSelectedValue(this.jlCompletion.getModel().getElementAt(0), true);
            evt.consume();
        }
        if (keyCode == 27 | keyCode == 10) {
            this.setVisible(false);
        }
        this.taskDialog.requestFocus();
    }

    public void setCompletionItems(Vector completionItems) {
        CompletionListModel model = (CompletionListModel)this.jlCompletion.getModel();
        model.setItems(completionItems);
        String prefix = this.textComponent.getText().substring(0, this.textComponent.getCaretPosition());
        Point position = this.textComponent.getLocationOnScreen();
        int maxHeight = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - position.getY()) - 50;
        position.setLocation(position.x + this.getFontMetrics(this.getFont()).stringWidth(prefix) + 3, position.y);
        this.setLocation(position);
        int height = this.jlCompletion.getPreferredSize().height + 4;
        if (height > maxHeight) {
            height = maxHeight;
        }
        this.setSize(new Dimension(this.jlCompletion.getPreferredSize().width + 4, height));
        this.repaint();
    }

    private Vector getCompletionItems(String prefix) {
        Vector filteredItems = new Vector();
        if (prefix.equals("")) {
            filteredItems = (Vector)this.allCompletionItems.clone();
        } else {
            for (String item : this.allCompletionItems) {
                if (!item.startsWith(prefix)) continue;
                filteredItems.add(item);
            }
        }
        Vector alreadyUsedItems = this.getUsedItems();
        for (String item : alreadyUsedItems) {
            if (!filteredItems.contains(item)) continue;
            filteredItems.remove(item);
        }
        if (filteredItems.size() == 0) {
            filteredItems.add(Translator.getTranslation("COMPLETION.NONE"));
        }
        return filteredItems;
    }

    private void reduceCompletionBy(char key) {
        String word = this.getIncompleteWord();
        if (key == '\b') {
            if (word.length() > 0) {
                word = word.substring(0, word.length() - 1);
            }
        } else {
            word = word + key;
        }
        int caretPosition = this.textComponent.getCaretPosition();
        this.textComponent.setText(this.getPrefix() + word + this.getSuffix());
        if ((caretPosition += key == '\b' ? -1 : 1) == -1) {
            caretPosition = 0;
        }
        this.textComponent.setCaretPosition(caretPosition);
        Vector newItems = this.getCompletionItems(word);
        this.setCompletionItems(newItems);
        if (newItems.get(0).equals(Translator.getTranslation("COMPLETION.NONE"))) {
            this.jlCompletion.setSelectedIndex(0);
        }
    }

    private void completeItem(String value) {
        String prefix = this.getPrefix();
        String suffix = this.getSuffix();
        this.textComponent.setText(prefix + value + suffix);
        this.setVisible(false);
    }

    private String getIncompleteWord() {
        String text = this.textComponent.getText();
        String prefix = text.substring(0, this.textComponent.getCaretPosition());
        int spaceIndex = prefix.lastIndexOf(" ");
        if (spaceIndex == -1) {
            return prefix;
        }
        return text.substring(spaceIndex + 1, this.textComponent.getCaretPosition());
    }

    private String getPrefix() {
        String text = this.textComponent.getText();
        String prefix = text.substring(0, this.textComponent.getCaretPosition());
        int spaceIndex = prefix.lastIndexOf(" ");
        if (spaceIndex == -1) {
            return "";
        }
        return text.substring(0, spaceIndex + 1);
    }

    private String getSuffix() {
        return this.textComponent.getText().substring(this.textComponent.getCaretPosition());
    }

    private Vector getUsedItems() {
        Vector<String> alreadyUsedItems = new Vector<String>();
        String prefix = this.getPrefix() + " " + this.getSuffix();
        StringTokenizer tokenizer = new StringTokenizer(prefix);
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken();
            alreadyUsedItems.add(item);
        }
        return alreadyUsedItems;
    }
}

