/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.cesilko.rachota.core.Clock;
import org.cesilko.rachota.core.ClockListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.AboutDialog;
import org.cesilko.rachota.gui.AnalyticsView;
import org.cesilko.rachota.gui.DayView;
import org.cesilko.rachota.gui.HistoryView;
import org.cesilko.rachota.gui.InactivityReminderDialog;
import org.cesilko.rachota.gui.SettingsDialog;
import org.cesilko.rachota.gui.StartupWindow;
import org.cesilko.rachota.gui.TaskDialog;
import org.cesilko.rachota.gui.Tools;

public class MainWindow
extends JFrame
implements PropertyChangeListener,
ClockListener {
    private JMenuBar mbMenu;
    private JMenuItem mnAbout;
    private JMenuItem mnAddNote;
    private JMenuItem mnAdjustStart;
    private JMenuItem mnCopyTask;
    private JMenuItem mnCorrectDuration;
    private JMenuItem mnDocs;
    private JMenuItem mnExit;
    private JMenuItem mnFAQs;
    private JMenu mnHelp;
    private JMenuItem mnMoveTime;
    private JMenuItem mnSettings;
    private JMenuItem mnSwitchDate;
    private JMenu mnSystem;
    private JMenu mnTask;
    private JMenu mnTools;
    private JSeparator separator;
    private JTabbedPane tpViews;
    private boolean reportingActivity;
    private static final int TAB_DAY_VIEW = 0;
    private static final int TAB_HISTORY_VIEW = 1;
    private static final int TAB_ANALYTICS_VIEW = 2;

    public static void main(String[] args) throws Exception {
        int length = args.length;
        boolean printHelp = false;
        for (int i = 0; i < length; ++i) {
            String argument = args[i];
            if (argument.startsWith("-userdir=")) {
                File userdir = new File(argument.substring(9));
                userdir.mkdirs();
                if (userdir.isDirectory()) {
                    Settings.getDefault().setSetting("userDir", userdir.getCanonicalPath());
                    continue;
                }
                JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.USERDIR_ERROR", new String[]{(String)Settings.getDefault().getSetting("userDir")}), Translator.getTranslation("ERROR.ERROR_TITLE"), 2);
                continue;
            }
            printHelp = true;
        }
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        if (userDir.indexOf("rachota.sourceforge.net") != -1) {
            final File[] selectedFile = new File[]{null};
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setFileSelectionMode(1);
                        fileChooser.setDialogTitle(Translator.getTranslation("QUESTION.DIARY_LOCATION"));
                        fileChooser.setApproveButtonText(Translator.getTranslation("HISTORYVIEW.BT_SELECT"));
                        fileChooser.setApproveButtonMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_SELECT"));
                        int decision = fileChooser.showOpenDialog(null);
                        if (decision != 0) {
                            return;
                        }
                        selectedFile[0] = fileChooser.getSelectedFile();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (selectedFile[0] == null) {
                return;
            }
            Settings.getDefault().setSetting("userDir", selectedFile[0].getAbsolutePath());
        }
        String infoString = "\n--------------------------------------------------------------------------------";
        infoString = infoString + "\n\ufffd\ufffd Rachota 2.4 \ufffd\ufffd (build #140825) - " + Translator.getTranslation("INFORMATION.PROGRAM");
        infoString = infoString + "\n   http://rachota.sourceforge.net";
        infoString = infoString + "\n   " + Translator.getTranslation("INFORMATION.SESSION") + ": " + System.getProperty("os.name") + ", JDK " + System.getProperty("java.version") + ", " + DateFormat.getDateTimeInstance(1, 1).format(new Date());
        infoString = infoString + "\n   " + Translator.getTranslation("INFORMATION.LOCALIZATION") + ": " + Settings.getDefault().getSetting("dictionary");
        infoString = infoString + "\n   " + Translator.getTranslation("INFORMATION.USERDIR") + ": " + userDir;
        if (printHelp) {
            infoString = infoString + "\n\nHelp: java [-Duser.language=<language_id> -Duser.country=<country_id>] -jar rachota_22.jar [-userdir=<diary_folder>] where:";
            infoString = infoString + "\n      <diary_folder> is directory with settings and diary files e.g. C:\\rachota\\diaries";
            infoString = infoString + "\n      <language_id> is Java language code e.g. cs, de, en, es, hu, it, ja, pt, ro or ru";
            infoString = infoString + "\n      <country_id> is Java country code e.g. BR, CZ, DE, ES, HU, IT, JP, MX, RO, RU or US";
            infoString = infoString + "\n      java -Duser.language=cs -Duser.country=CZ -jar Rachota.jar -userdir=/home/jkovalsky/diaries";
        }
        Logger.getLogger(MainWindow.class.getName()).info(infoString);
        MainWindow.checkAnotherInstance();
        final StartupWindow startupWindow = StartupWindow.getInstance();
        Settings.loadSettings();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow mainWindow = null;
                    try {
                        mainWindow = new MainWindow();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    boolean minimizeOnStart = (Boolean)Settings.getDefault().getSetting("minimizeOnStart");
                    if (!minimizeOnStart) {
                        mainWindow.setVisible(true);
                    }
                    startupWindow.hideWindow();
                    Tools.recordActivity();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MainWindow() throws Exception {
        Task task;
        DayView dayView;
        block12: {
            Plan.loadPlan();
            StartupWindow startupWindow = StartupWindow.getInstance();
            startupWindow.setProgressMessage("regular_tasks.xml");
            Plan.loadRegularTasks();
            startupWindow.setProgressMessage(Translator.getTranslation("INFORMATION.OPEN_MAIN_WINDOW"));
            Boolean moveUnfinishedTasks = (Boolean)Settings.getDefault().getSetting("moveUnfinished");
            if (moveUnfinishedTasks.booleanValue()) {
                Plan.getDefault().copyUnfinishedTasks();
            }
            this.initComponents();
            dayView = new DayView();
            this.tpViews.add((Component)dayView, 0);
            this.tpViews.setFont(this.getFont());
            dayView.addPropertyChangeListener(this);
            HistoryView historyView = new HistoryView();
            dayView.addPropertyChangeListener(historyView);
            historyView.addPropertyChangeListener(dayView);
            this.tpViews.add((Component)historyView, 1);
            AnalyticsView analyticsView = new AnalyticsView();
            this.tpViews.add((Component)analyticsView, 2);
            this.setSize(550, 650);
            this.setTitle(dayView.getTitleSuffix() + "Rachota 2.4");
            String size = (String)Settings.getDefault().getSetting("size");
            String location = (String)Settings.getDefault().getSetting("location");
            if (size != null) {
                try {
                    int width = Integer.parseInt(size.substring(1, size.indexOf(",")));
                    int height = Integer.parseInt(size.substring(size.indexOf(",") + 1, size.length() - 1));
                    if (width < 0 || height < 0) {
                        width = 550;
                        height = 650;
                    }
                    this.setSize(width, height);
                }
                catch (Exception e) {
                    System.out.println("Error: Unable to load size of main window: " + size);
                    e.printStackTrace();
                }
            }
            if (location != null) {
                try {
                    int x = Integer.parseInt(location.substring(1, location.indexOf(",")));
                    int y = Integer.parseInt(location.substring(location.indexOf(",") + 1, location.length() - 1));
                    if (x < 0 || y < 0) {
                        this.setLocationRelativeTo(null);
                        break block12;
                    }
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    int screenWidth = toolkit.getScreenSize().width;
                    int screenHeight = toolkit.getScreenSize().height;
                    if (x + this.getWidth() > screenWidth || y + this.getHeight() > screenHeight) {
                        this.setLocationRelativeTo(null);
                        break block12;
                    }
                    this.setLocation(x, y);
                }
                catch (Exception e) {
                    System.out.println("Error: Unable to load location of main window: " + location);
                    e.printStackTrace();
                    this.setLocationRelativeTo(null);
                }
            } else {
                this.setLocationRelativeTo(null);
            }
        }
        Clock.getDefault().start();
        boolean automaticStart = (Boolean)Settings.getDefault().getSetting("automaticStart");
        if (automaticStart && ((task = dayView.getTask()) == null || !task.isRunning())) {
            dayView.setTask(dayView.getDay().getIdleTask(), true);
        }
        this.createSystemTray();
        Clock.getDefault().addListener(this);
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.tpViews = new JTabbedPane();
        this.mbMenu = new JMenuBar();
        this.mnSystem = new JMenu();
        this.mnAbout = new JMenuItem();
        this.mnSettings = new JMenuItem();
        this.separator = new JSeparator();
        this.mnExit = new JMenuItem();
        this.mnTask = new JMenu();
        this.mnCopyTask = new JMenuItem();
        this.mnMoveTime = new JMenuItem();
        this.mnCorrectDuration = new JMenuItem();
        this.mnAddNote = new JMenuItem();
        this.mnTools = new JMenu();
        this.mnSwitchDate = new JMenuItem();
        this.mnAdjustStart = new JMenuItem();
        this.mnHelp = new JMenu();
        this.mnDocs = new JMenuItem();
        this.mnFAQs = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_small.png")).getImage());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MainWindow.this.formMouseEntered(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                MainWindow.this.formWindowIconified(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                MainWindow.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tpViews.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MainWindow.this.tpViewsMouseEntered(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.getContentPane().add((Component)this.tpViews, gridBagConstraints);
        this.mbMenu.setFont(this.getFont());
        this.mnSystem.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_SYSTEM"));
        this.mnSystem.setText(Translator.getTranslation("MAINWINDOW.MN_SYSTEM"));
        this.mnSystem.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_SYSTEM_TOOLTIP"));
        this.mnSystem.setFont(this.getFont());
        this.mnAbout.setFont(this.getFont());
        this.mnAbout.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/info.png")));
        this.mnAbout.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_ABOUT"));
        this.mnAbout.setText(Translator.getTranslation("MAINWINDOW.MN_ABOUT"));
        this.mnAbout.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_ABOUT_TOOLTIP"));
        this.mnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnAboutActionPerformed(evt);
            }
        });
        this.mnSystem.add(this.mnAbout);
        this.mnSettings.setFont(this.getFont());
        this.mnSettings.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/service.png")));
        this.mnSettings.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_SETTINGS"));
        this.mnSettings.setText(Translator.getTranslation("MAINWINDOW.MN_SETTINGS"));
        this.mnSettings.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_SETTINGS_TOOLTIP"));
        this.mnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnSettingsActionPerformed(evt);
            }
        });
        this.mnSystem.add(this.mnSettings);
        this.mnSystem.add(this.separator);
        this.mnExit.setFont(this.getFont());
        this.mnExit.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/exit.png")));
        this.mnExit.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_EXIT"));
        this.mnExit.setText(Translator.getTranslation("MAINWINDOW.MN_EXIT"));
        this.mnExit.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_EXIT_TOOLTIP"));
        this.mnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnExitActionPerformed(evt);
            }
        });
        this.mnSystem.add(this.mnExit);
        this.mbMenu.add(this.mnSystem);
        this.mnTask.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_TASK"));
        this.mnTask.setText(Translator.getTranslation("MAINWINDOW.MN_TASK"));
        this.mnTask.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_TASK_TOOLTIP"));
        this.mnTask.setFont(this.getFont());
        this.mnCopyTask.setFont(this.getFont());
        this.mnCopyTask.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/move_task.png")));
        this.mnCopyTask.setMnemonic(Translator.getMnemonic("MAINWINDOW.MOVE_TASK"));
        this.mnCopyTask.setText(Translator.getTranslation("MAINWINDOW.MOVE_TASK"));
        this.mnCopyTask.setToolTipText(Translator.getTranslation("MAINWINDOW.MOVE_TASK_TOOLTIP"));
        this.mnCopyTask.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnCopyTaskActionPerformed(evt);
            }
        });
        this.mnTask.add(this.mnCopyTask);
        this.mnMoveTime.setFont(this.getFont());
        this.mnMoveTime.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/move_time.png")));
        this.mnMoveTime.setMnemonic(Translator.getMnemonic("MAINWINDOW.MOVE_TIME"));
        this.mnMoveTime.setText(Translator.getTranslation("MAINWINDOW.MOVE_TIME"));
        this.mnMoveTime.setToolTipText(Translator.getTranslation("MAINWINDOW.MOVE_TIME_TOOLTIP"));
        this.mnMoveTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnMoveTimeActionPerformed(evt);
            }
        });
        this.mnTask.add(this.mnMoveTime);
        this.mnCorrectDuration.setFont(this.getFont());
        this.mnCorrectDuration.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/fix_time.png")));
        this.mnCorrectDuration.setMnemonic(Translator.getMnemonic("MAINWINDOW.CORRECT_DURATION"));
        this.mnCorrectDuration.setText(Translator.getTranslation("MAINWINDOW.CORRECT_DURATION"));
        this.mnCorrectDuration.setToolTipText(Translator.getTranslation("MAINWINDOW.CORRECT_DURATION_TOOLTIP"));
        this.mnCorrectDuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnCorrectDurationActionPerformed(evt);
            }
        });
        this.mnTask.add(this.mnCorrectDuration);
        this.mnAddNote.setFont(this.getFont());
        this.mnAddNote.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/note.png")));
        this.mnAddNote.setMnemonic(Translator.getMnemonic("MAINWINDOW.ADD_NOTE"));
        this.mnAddNote.setText(Translator.getTranslation("MAINWINDOW.ADD_NOTE"));
        this.mnAddNote.setToolTipText(Translator.getTranslation("MAINWINDOW.ADD_NOTE_TOOLTIP"));
        this.mnAddNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnAddNoteActionPerformed(evt);
            }
        });
        this.mnTask.add(this.mnAddNote);
        this.mbMenu.add(this.mnTask);
        this.mnTools.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_TOOLS"));
        this.mnTools.setText(Translator.getTranslation("MAINWINDOW.MN_TOOLS"));
        this.mnTools.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_TOOLS_TOOLTIP"));
        this.mnTools.setFont(this.getFont());
        this.mnSwitchDate.setFont(this.getFont());
        this.mnSwitchDate.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/calendar.png")));
        this.mnSwitchDate.setMnemonic(Translator.getMnemonic("MAINWINDOW.SWITCH_DATE"));
        this.mnSwitchDate.setText(Translator.getTranslation("MAINWINDOW.SWITCH_DATE"));
        this.mnSwitchDate.setToolTipText(Translator.getTranslation("MAINWINDOW.SWITCH_DATE_TOOLTIP"));
        this.mnSwitchDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnSwitchDateActionPerformed(evt);
            }
        });
        this.mnTools.add(this.mnSwitchDate);
        this.mnAdjustStart.setFont(this.getFont());
        this.mnAdjustStart.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/clock.png")));
        this.mnAdjustStart.setMnemonic(Translator.getMnemonic("MAINWINDOW.ADJUST_START"));
        this.mnAdjustStart.setText(Translator.getTranslation("MAINWINDOW.ADJUST_START"));
        this.mnAdjustStart.setToolTipText(Translator.getTranslation("MAINWINDOW.ADJUST_START_TOOLTIP"));
        this.mnAdjustStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnAdjustStartActionPerformed(evt);
            }
        });
        this.mnTools.add(this.mnAdjustStart);
        this.mbMenu.add(this.mnTools);
        this.mnHelp.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_HELP"));
        this.mnHelp.setText(Translator.getTranslation("MAINWINDOW.MN_HELP"));
        this.mnHelp.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_HELP_TOOLTIP"));
        this.mnHelp.setFont(this.getFont());
        this.mnDocs.setFont(this.getFont());
        this.mnDocs.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/info.png")));
        this.mnDocs.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_DOCS"));
        this.mnDocs.setText(Translator.getTranslation("MAINWINDOW.MN_DOCS"));
        this.mnDocs.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_DOCS_TOOLTIP"));
        this.mnDocs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnDocsActionPerformed(evt);
            }
        });
        this.mnHelp.add(this.mnDocs);
        this.mnFAQs.setFont(this.getFont());
        this.mnFAQs.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/info.png")));
        this.mnFAQs.setMnemonic(Translator.getMnemonic("MAINWINDOW.MN_FAQS"));
        this.mnFAQs.setText(Translator.getTranslation("MAINWINDOW.MN_FAQS"));
        this.mnFAQs.setToolTipText(Translator.getTranslation("MAINWINDOW.MN_FAQS_TOOLTIP"));
        this.mnFAQs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnFAQsActionPerformed(evt);
            }
        });
        this.mnHelp.add(this.mnFAQs);
        this.mbMenu.add(this.mnHelp);
        this.setJMenuBar(this.mbMenu);
    }

    private void formWindowIconified(WindowEvent evt) {
        if (!this.enableSystemTray()) {
            return;
        }
        try {
            SystemTray.getSystemTray().getTrayIcons();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            long now = new Date().getTime();
            long rachotaShownTime = Long.parseLong(System.getProperty("rachota.shownTime"));
            if (now - rachotaShownTime < 1000L) {
                return;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.setVisible(false);
    }

    private void mnSwitchDateActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.switchDate(this);
    }

    private void mnMoveTimeActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.moveTime(this);
    }

    private void mnCopyTaskActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.copyTask(this);
    }

    private void mnSettingsActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        AnalyticsView analyticsView = (AnalyticsView)this.tpViews.getComponentAt(2);
        SettingsDialog dialog = new SettingsDialog(this);
        dialog.addPropertyChangeListener(dayView);
        dialog.addPropertyChangeListener(analyticsView);
        dialog.addPropertyChangeListener(this);
        dialog.setVisible(true);
    }

    private void mnExitActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void mnAboutActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        String reportedWeek;
        int decision;
        Object[] buttons;
        boolean warnHoursNotReaced = (Boolean)Settings.getDefault().getSetting("warnHoursNotReached");
        if (warnHoursNotReaced) {
            double dayWorkHours = Settings.getDefault().getWorkingHours();
            Day today = Plan.getDefault().getDay(new Date());
            double totalTime = (double)today.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
            if (totalTime < dayWorkHours) {
                buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
                decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("WARNING.HOURS_NOT_REACHED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 0, 3, null, buttons, buttons[1]);
                if (decision != 0) {
                    return;
                }
            }
        }
        if ((reportedWeek = (String)Settings.getDefault().getSetting("rachota.reported.week")).equals("-1")) {
            Settings.getDefault().setSetting("rachota.reported.week", "-2");
        }
        Settings.getDefault().setSetting("size", "[" + (int)this.getBounds().getWidth() + "," + (int)this.getBounds().getHeight() + "]");
        Settings.getDefault().setSetting("location", "[" + (int)this.getBounds().getLocation().getX() + "," + (int)this.getBounds().getLocation().getY() + "]");
        HistoryView historyView = (HistoryView)this.tpViews.getComponentAt(1);
        historyView.saveSetup();
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.saveSetup();
        Settings.saveSettings();
        Plan.getDefault().uploadDiary(Plan.UPLOAD_NOW);
        String task = (String)Settings.getDefault().getSetting("runningTask");
        if (task != null && !task.equals("null")) {
            String onExitAction = (String)Settings.getDefault().getSetting("onExitAction");
            if ("1".equals(onExitAction)) {
                Settings.getDefault().setSetting("runningTask", null);
            } else {
                task = task.substring(0, task.indexOf("["));
                buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO"), Translator.getTranslation("MOVETIMEDIALOG.BT_CANCEL")};
                decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.COUNT_RUNNING_TASK", new String[]{task}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 1, 3, null, buttons, buttons[0]);
                if (decision == 2 || decision == -1) {
                    return;
                }
                if (decision == 1) {
                    Settings.getDefault().setSetting("runningTask", null);
                }
            }
            Settings.saveSettings();
        }
        int attempts = 0;
        while (true) {
            boolean planSaved = Plan.savePlan();
            ++attempts;
            if (planSaved) break;
            if (attempts != 10) continue;
            Object[] buttons2 = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
            int decision2 = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.SELECT_LOCATION"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons2, buttons2[0]);
            if (decision2 == 1) break;
            String location = (String)Settings.getDefault().getSetting("userdir");
            JFileChooser fileChooser = new JFileChooser(location);
            fileChooser.setFileSelectionMode(1);
            fileChooser.setApproveButtonText(Translator.getTranslation("HISTORYVIEW.BT_SELECT"));
            fileChooser.setApproveButtonMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_SELECT"));
            decision2 = fileChooser.showOpenDialog(this);
            attempts = 0;
            if (decision2 != 0) continue;
            File file = fileChooser.getSelectedFile();
            Settings.getDefault().setSetting("userdir", file.getAbsolutePath());
        }
        System.exit(0);
    }

    private void formComponentShown(ComponentEvent evt) {
        System.setProperty("rachota.shownTime", "" + new Date().getTime());
    }

    private void mnAddNoteActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.addNote(this);
    }

    private void mnAdjustStartActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.adjustStartTime(this);
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void tpViewsMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void mnCorrectDurationActionPerformed(ActionEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        dayView.correctTaskDuration(this);
    }

    private void mnDocsActionPerformed(ActionEvent evt) {
        Tools.showURL("http://rachota.sourceforge.net/en/documentation.html");
    }

    private void mnFAQsActionPerformed(ActionEvent evt) {
        Tools.showURL("http://rachota.sourceforge.net/en/faq.html");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DayView dayView = (DayView)this.tpViews.getComponentAt(0);
        this.setTitle(dayView.getTitleSuffix() + "Rachota 2.4");
        if (evt.getPropertyName().equals("day")) {
            this.tpViews.setSelectedIndex(0);
        }
        if (evt.getPropertyName().equals("enable_menu")) {
            this.getMenuItem((String)evt.getOldValue()).setEnabled(Boolean.parseBoolean((String)evt.getNewValue()));
        }
        this.updateSystemTray(dayView);
    }

    private void updateSystemTray(DayView dayView) {
        TrayIcon[] trayIcons;
        if (!this.enableSystemTray()) {
            return;
        }
        try {
            trayIcons = SystemTray.getSystemTray().getTrayIcons();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        for (int i = 0; i < trayIcons.length; ++i) {
            TrayIcon trayIcon = trayIcons[i];
            if (!trayIcon.getToolTip().endsWith("Rachota 2.4")) continue;
            Task task = dayView.getTask();
            String currentRachotaTrayColor = System.getProperty("rachotaTrayColor");
            String neededRachotaTrayColor = "red";
            if (task != null && task.isRunning() && !task.isIdleTask()) {
                neededRachotaTrayColor = "blue";
            }
            if (!neededRachotaTrayColor.equals(currentRachotaTrayColor)) {
                if (neededRachotaTrayColor.equals("red")) {
                    trayIcon.setImage(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_red_48.png")).getImage());
                } else {
                    trayIcon.setImage(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_48.png")).getImage());
                }
                System.setProperty("rachotaTrayColor", neededRachotaTrayColor);
            }
            trayIcon.setPopupMenu(this.getTrayPopupMenu());
            trayIcon.setToolTip(dayView.getTitleSuffix() + "Rachota 2.4");
            break;
        }
    }

    private PopupMenu getTrayPopupMenu() {
        final SystemTray systemTray = SystemTray.getSystemTray();
        ActionListener maximizeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.setVisible(true);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exception) {
                    // empty catch block
                }
                MainWindow.this.setExtendedState(0);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MainWindow.this.requestFocus();
                Tools.recordActivity();
            }
        };
        PopupMenu popup = new PopupMenu();
        MenuItem menuItem = new MenuItem(Translator.getTranslation("MAINWINDOW.OPEN"));
        menuItem.addActionListener(maximizeListener);
        menuItem.setFont(this.getFont().deriveFont(1));
        popup.add(menuItem);
        ActionListener newTaskListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DayView dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                TaskDialog dialog = new TaskDialog(dayView.getDay());
                dialog.setLocationRelativeTo(MainWindow.this);
                dialog.addPropertyChangeListener(dayView);
                dialog.setVisible(true);
                Tools.recordActivity();
            }
        };
        menuItem = new MenuItem(Translator.getTranslation("MAINWINDOW.NEW"));
        menuItem.addActionListener(newTaskListener);
        popup.add(menuItem);
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tools.recordActivity();
                MainWindow.this.formWindowClosing(null);
            }
        };
        menuItem = new MenuItem(Translator.getTranslation("MAINWINDOW.MN_EXIT"));
        menuItem.addActionListener(exitListener);
        popup.add(menuItem);
        Iterator tasks = Plan.getDefault().getDay(new Date()).getTasks().iterator();
        Task selectedTask = null;
        while (tasks.hasNext()) {
            final Task task = (Task)tasks.next();
            if (task.getState() == Task.STATE_DONE || task.isIdleTask()) continue;
            if (popup.getItemCount() == 3) {
                popup.addSeparator();
            }
            menuItem = new MenuItem(task.getDescription());
            DayView dayView = (DayView)this.tpViews.getComponentAt(0);
            if (task == dayView.getTask()) {
                menuItem.setFont(this.getFont().deriveFont(1));
                selectedTask = task;
            }
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DayView dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                    dayView.selectTask(task);
                    Tools.recordActivity();
                    Image image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_48.png")).getImage();
                    TrayIcon[] trayIcons = systemTray.getTrayIcons();
                    for (int i = 0; i < trayIcons.length; ++i) {
                        TrayIcon trayIcon = trayIcons[i];
                        if (!trayIcon.getToolTip().endsWith("Rachota 2.4")) continue;
                        trayIcon.setImage(image);
                        break;
                    }
                }
            };
            menuItem.addActionListener(actionListener);
            popup.add(menuItem);
        }
        ActionListener startStopTaskListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Image image;
                DayView dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                Task task = dayView.getTask();
                if (task.isRunning()) {
                    dayView.pauseTask();
                    image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_red_48.png")).getImage();
                } else {
                    dayView.startTask();
                    image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_48.png")).getImage();
                }
                Tools.recordActivity();
                TrayIcon[] trayIcons = systemTray.getTrayIcons();
                for (int i = 0; i < trayIcons.length; ++i) {
                    TrayIcon trayIcon = trayIcons[i];
                    if (!trayIcon.getToolTip().endsWith("Rachota 2.4")) continue;
                    trayIcon.setImage(image);
                    break;
                }
            }
        };
        ActionListener finishTaskListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DayView dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                dayView.finishTask();
                Image image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_red_48.png")).getImage();
                Tools.recordActivity();
                TrayIcon[] trayIcons = systemTray.getTrayIcons();
                for (int i = 0; i < trayIcons.length; ++i) {
                    TrayIcon trayIcon = trayIcons[i];
                    if (!trayIcon.getToolTip().endsWith("Rachota 2.4")) continue;
                    trayIcon.setImage(image);
                    break;
                }
            }
        };
        if (selectedTask != null) {
            popup.addSeparator();
            menuItem = selectedTask.isRunning() ? new MenuItem(Translator.getTranslation("MAINWINDOW.RELAX")) : new MenuItem(Translator.getTranslation("MAINWINDOW.WORK"));
            menuItem.addActionListener(startStopTaskListener);
            popup.add(menuItem);
            menuItem = new MenuItem(Translator.getTranslation("MAINWINDOW.DONE"));
            menuItem.addActionListener(finishTaskListener);
            popup.add(menuItem);
            ActionListener addNoteListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String note;
                    Tools.recordActivity();
                    DayView dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                    Task task = dayView.getTask();
                    if (task != null && (note = JOptionPane.showInputDialog(null, Translator.getTranslation("MAINWINDOW.NEW_NOTE"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 3)) != null) {
                        task.addNote(note, true);
                    }
                }
            };
            menuItem = new MenuItem(Translator.getTranslation("MAINWINDOW.ADD_NOTE"));
            menuItem.addActionListener(addNoteListener);
            popup.add(menuItem);
        }
        return popup;
    }

    private void createSystemTray() {
        if (!this.enableSystemTray()) {
            return;
        }
        if (SystemTray.isSupported()) {
            Image image;
            SystemTray systemTray = SystemTray.getSystemTray();
            DayView dayView = (DayView)this.tpViews.getComponentAt(0);
            Task task = dayView.getTask();
            if (task == null) {
                image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_red_48.png")).getImage();
                System.setProperty("rachotaTrayColor", "red");
            } else if (task.isRunning() && !task.isIdleTask()) {
                image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_48.png")).getImage();
                System.setProperty("rachotaTrayColor", "blue");
            } else {
                image = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_red_48.png")).getImage();
                System.setProperty("rachotaTrayColor", "red");
            }
            TrayIcon trayIcon = new TrayIcon(image, "Rachota 2.4", this.getTrayPopupMenu());
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MainWindow.this.isVisible()) {
                        MainWindow.this.formWindowIconified(null);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainWindow.this.setVisible(true);
                            }
                        });
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                        }
                        MainWindow.this.setExtendedState(0);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MainWindow.this.requestFocus();
                    }
                }
            });
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException ex) {
                System.out.println("Error: Can't create Rachota system tray icon.");
            }
        }
    }

    @Override
    public void tick() {
        Boolean reportActivity;
        Boolean detectInactivity = (Boolean)Settings.getDefault().getSetting("detectInactivity");
        if (detectInactivity.booleanValue()) {
            int inactivityTime = Integer.parseInt((String)Settings.getDefault().getSetting("inactivityTime"));
            if (Tools.getInactivity() > (long)(inactivityTime * 60 * 1000) && System.getProperty("inactivityReminderOpen") == null) {
                Tools.recordActivity();
                SystemTray systemTray = SystemTray.getSystemTray();
                TrayIcon[] trayIcons = systemTray.getTrayIcons();
                for (int i = 0; i < trayIcons.length; ++i) {
                    TrayIcon trayIcon = trayIcons[i];
                    if (!trayIcon.getToolTip().endsWith("Rachota 2.4")) continue;
                    trayIcon.displayMessage(Translator.getTranslation("WARNING.WARNING_TITLE"), Translator.getTranslation("INACTIVITYDIALOG.LBL_INACTIVITY_MESSAGE", new String[]{(String)Settings.getDefault().getSetting("inactivityTime")}), TrayIcon.MessageType.WARNING);
                }
                String inactivityAction = (String)Settings.getDefault().getSetting("inactivityAction");
                if (!inactivityAction.equals("0")) {
                    EventQueue.invokeLater(new Runnable(){
                        DayView dayView;
                        {
                            this.dayView = (DayView)MainWindow.this.tpViews.getComponentAt(0);
                        }

                        @Override
                        public void run() {
                            new InactivityReminderDialog(this.dayView).setVisible(true);
                        }
                    });
                }
            }
        }
        if (!(reportActivity = (Boolean)Settings.getDefault().getSetting("reportActivity")).booleanValue()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        final int currentWeek = calendar.get(3);
        String reportedWeek = (String)Settings.getDefault().getSetting("rachota.reported.week");
        if (reportedWeek.equals("-1")) {
            return;
        }
        if (Integer.parseInt(reportedWeek) == currentWeek) {
            return;
        }
        String RID = Tools.getRID();
        Plan plan = Plan.getDefault();
        calendar.set(3, currentWeek - 1);
        calendar.set(7, calendar.getFirstDayOfWeek());
        Day day = plan.getDay(calendar.getTime());
        long totalTime = 0L;
        long idleTime = 0L;
        long privateTime = 0L;
        for (int i = 0; i < 7; ++i) {
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) {
                    idleTime += task.getDuration();
                    continue;
                }
                if (task.privateTask()) {
                    privateTime += task.getDuration();
                    continue;
                }
                totalTime += task.getDuration();
            }
            calendar.add(7, 1);
            day = plan.getDay(calendar.getTime());
        }
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        File[] diaries = new File(userDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith("diary_") && name.endsWith(".xml");
            }
        });
        final AnalyticsView analyticsView = (AnalyticsView)this.tpViews.getComponentAt(2);
        String WUT = "" + totalTime + "|" + idleTime + "|" + privateTime + "|" + diaries.length + "|" + analyticsView.getWeeklyAnalysis();
        try {
            RID = URLEncoder.encode(RID, "UTF-8");
            WUT = URLEncoder.encode(WUT, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error: Can't build URL to Rachota Analytics server.");
            e.printStackTrace();
        }
        final String url_string = "http://rachota.sourceforge.net/reportActivity.php?rid=" + RID + "&wut=" + WUT;
        final Thread connectionThread = new Thread("Rachota Analytics Reporter"){

            @Override
            public void run() {
                try {
                    if (MainWindow.this.reportingActivity) {
                        return;
                    }
                    MainWindow.this.reportingActivity = true;
                    URL url = new URL(url_string);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(2000);
                    connection.getResponseMessage();
                    connection.disconnect();
                    Settings.getDefault().setSetting("rachota.reported.week", "" + currentWeek);
                    analyticsView.updateChart();
                    MainWindow.this.reportingActivity = false;
                }
                catch (Exception e) {
                    System.out.println("Error: Can't upload weekly data to Rachota Analytics server.");
                    Settings.getDefault().setSetting("rachota.reported.week", "-1");
                    MainWindow.this.reportingActivity = false;
                }
            }
        };
        connectionThread.start();
        new Thread("Rachota Analytics Reporter killer"){

            @Override
            public void run() {
                try {
                    29.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (connectionThread.isAlive()) {
                    System.out.println("Error: Giving up...");
                    connectionThread.interrupt();
                }
            }
        }.start();
    }

    private boolean enableSystemTray() {
        int version;
        Boolean enableSystemTray = (Boolean)Settings.getDefault().getSetting("enable.systemtray");
        if (enableSystemTray == null) {
            enableSystemTray = new Boolean(true);
        }
        return enableSystemTray != false && (version = Integer.parseInt(System.getProperty("java.version").substring(2, 3))) > 5;
    }

    private static void checkAnotherInstance() {
        String userdir = (String)Settings.getDefault().getSetting("userDir");
        File lockFile = new File(userdir + File.separator + "lock.tmp");
        if (!lockFile.exists()) {
            try {
                lockFile.createNewFile();
                lockFile.deleteOnExit();
                return;
            }
            catch (IOException e) {
                System.out.println("Error: Can't create new " + lockFile + " file.");
            }
        }
        Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
        int decision = JOptionPane.showOptionDialog(null, Translator.getTranslation("QUESTION.ANOTHER_INSTANCE"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
        if (decision == 1) {
            System.exit(-1);
        }
        lockFile.deleteOnExit();
    }

    private JMenuItem getMenuItem(String menuName) {
        JMenuItem menuItem = null;
        if (menuName.equals("mnCorrectDuration")) {
            menuItem = this.mnCorrectDuration;
        }
        if (menuName.equals("mnCopyTask")) {
            menuItem = this.mnCopyTask;
        }
        if (menuName.equals("mnAddNote")) {
            menuItem = this.mnAddNote;
        }
        if (menuName.equals("mnMoveTime")) {
            menuItem = this.mnMoveTime;
        }
        if (menuName.equals("mnAdjustStart")) {
            menuItem = this.mnAdjustStart;
        }
        return menuItem;
    }
}

