/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class MoveTimeDialog
extends JDialog {
    private JButton btCancel;
    private JButton btOK;
    private JComboBox cmbSelectTask;
    private JLabel lbColumn1;
    private JLabel lbColumn2;
    private JLabel lbSelectTask;
    private JLabel lbSelectTime;
    private JPanel pnButtons;
    private JSpinner spHours;
    private JSpinner spMinutes;
    private JSpinner spSeconds;
    private Task task;
    private Integer previousHours = new Integer(0);
    private Integer previousMinutes = new Integer(0);
    private Integer previousSeconds = new Integer(0);

    public MoveTimeDialog(Frame parent, Task task2, Day day) {
        this.task = task2;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        for (Task task2 : day.getTasks()) {
            if (task2.equals(this.task)) continue;
            this.cmbSelectTask.addItem(task2);
        }
        Dimension size = this.spHours.getPreferredSize();
        this.spHours.setPreferredSize(new Dimension((int)size.getWidth() * 2, (int)size.getHeight()));
        this.spMinutes.setPreferredSize(new Dimension((int)size.getWidth() * 2, (int)size.getHeight()));
        this.spSeconds.setPreferredSize(new Dimension((int)size.getWidth() * 2, (int)size.getHeight()));
        Tools.setupSelectAllListener(this.spHours);
        Tools.setupSelectAllListener(this.spMinutes);
        Tools.setupSelectAllListener(this.spSeconds);
        this.getRootPane().setDefaultButton(this.btOK);
        this.pack();
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.lbSelectTask = new JLabel();
        this.cmbSelectTask = new JComboBox();
        this.lbSelectTime = new JLabel();
        this.spHours = new JSpinner();
        this.lbColumn1 = new JLabel();
        this.spMinutes = new JSpinner();
        this.lbColumn2 = new JLabel();
        this.spSeconds = new JSpinner();
        this.pnButtons = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Translator.getTranslation("MOVETIMEDIALOG.TITLE"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MoveTimeDialog.this.formMouseEntered(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lbSelectTask.setDisplayedMnemonic(Translator.getMnemonic("MOVETIMEDIALOG.SELECT_TASK"));
        this.lbSelectTask.setFont(this.getFont());
        this.lbSelectTask.setLabelFor(this.cmbSelectTask);
        this.lbSelectTask.setText(Translator.getTranslation("MOVETIMEDIALOG.SELECT_TASK"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbSelectTask, gridBagConstraints);
        this.cmbSelectTask.setFont(this.getFont());
        this.cmbSelectTask.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.SELECT_TASK_TOOLTIP"));
        this.cmbSelectTask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MoveTimeDialog.this.cmbSelectTaskKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbSelectTask, gridBagConstraints);
        this.lbSelectTime.setDisplayedMnemonic(Translator.getMnemonic("MOVETIMEDIALOG.SELECT_TIME"));
        this.lbSelectTime.setFont(this.getFont());
        this.lbSelectTime.setLabelFor(this.spHours);
        this.lbSelectTime.setText(Translator.getTranslation("MOVETIMEDIALOG.SELECT_TIME"));
        this.lbSelectTime.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.SELECT_TIME_TOOLTIP"));
        this.lbSelectTime.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MoveTimeDialog.this.lbSelectTimeMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbSelectTime, gridBagConstraints);
        this.spHours.setFont(this.getFont());
        this.spHours.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.HOURS_TOOLTIP"));
        this.spHours.setMinimumSize(new Dimension(40, 20));
        this.spHours.setPreferredSize(new Dimension(40, 20));
        this.spHours.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MoveTimeDialog.this.spHoursStateChanged(evt);
            }
        });
        this.spHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MoveTimeDialog.this.spHoursKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spHours, gridBagConstraints);
        this.lbColumn1.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.lbColumn1, gridBagConstraints);
        this.spMinutes.setFont(this.getFont());
        this.spMinutes.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.MINUTES_TOOLTIP"));
        this.spMinutes.setMinimumSize(new Dimension(40, 20));
        this.spMinutes.setPreferredSize(new Dimension(40, 20));
        this.spMinutes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MoveTimeDialog.this.spMinutesStateChanged(evt);
            }
        });
        this.spMinutes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MoveTimeDialog.this.spMinutesKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spMinutes, gridBagConstraints);
        this.lbColumn2.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.lbColumn2, gridBagConstraints);
        this.spSeconds.setFont(this.getFont());
        this.spSeconds.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.SECONDS_TOOLTIP"));
        this.spSeconds.setMinimumSize(new Dimension(40, 20));
        this.spSeconds.setPreferredSize(new Dimension(40, 20));
        this.spSeconds.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MoveTimeDialog.this.spSecondsStateChanged(evt);
            }
        });
        this.spSeconds.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MoveTimeDialog.this.spSecondsKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spSeconds, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("MOVETIMEDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("MOVETIMEDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveTimeDialog.this.btOKActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btOK);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("MOVETIMEDIALOG.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("MOVETIMEDIALOG.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveTimeDialog.this.btCancelActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        this.getContentPane().add((Component)this.pnButtons, gridBagConstraints);
        this.pack();
    }

    private void spSecondsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spMinutesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spHoursKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbSelectTaskKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spSecondsStateChanged(ChangeEvent evt) {
        Integer seconds = (Integer)this.spSeconds.getValue();
        int value = seconds;
        if (value < 0 || value > 59) {
            this.spSeconds.setValue(this.previousSeconds);
        } else {
            this.checkDuration();
        }
    }

    private void spMinutesStateChanged(ChangeEvent evt) {
        Integer minutes = (Integer)this.spMinutes.getValue();
        int value = minutes;
        if (value < 0 || value > 59) {
            this.spMinutes.setValue(this.previousMinutes);
        } else {
            this.checkDuration();
        }
    }

    private void spHoursStateChanged(ChangeEvent evt) {
        Integer hours = (Integer)this.spHours.getValue();
        int value = hours;
        if (value < 0 || value > 23) {
            this.spHours.setValue(this.previousHours);
        } else {
            this.checkDuration();
        }
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Task targetTask = (Task)this.cmbSelectTask.getSelectedItem();
        long duration = this.previousHours * 1000 * 60 * 60 + this.previousMinutes * 1000 * 60 + this.previousSeconds * 1000;
        targetTask.addDuration(duration);
        targetTask.setState(Task.STATE_STARTED);
        this.task.addDuration(-duration);
        this.firePropertyChange("time_changed", null, null);
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void lbSelectTimeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.setTime(this.task.getDuration());
        }
    }

    private void checkDuration() {
        Integer seconds = (Integer)this.spSeconds.getValue();
        Integer minutes = (Integer)this.spMinutes.getValue();
        Integer hours = (Integer)this.spHours.getValue();
        long duration = seconds * 1000 + minutes * 1000 * 60 + hours * 1000 * 60 * 60;
        if (duration > this.task.getDuration()) {
            this.spSeconds.setValue(this.previousSeconds);
            this.spMinutes.setValue(this.previousMinutes);
            this.spHours.setValue(this.previousHours);
        } else {
            this.previousSeconds = (Integer)this.spSeconds.getValue();
            this.previousMinutes = (Integer)this.spMinutes.getValue();
            this.previousHours = (Integer)this.spHours.getValue();
        }
    }

    public void setTime(long time) {
        final Long hours = TimeUnit.HOURS.convert(time, TimeUnit.MILLISECONDS);
        final Long minutes = TimeUnit.MINUTES.convert(time -= TimeUnit.HOURS.toMillis(hours), TimeUnit.MILLISECONDS);
        final Long seconds = TimeUnit.SECONDS.convert((time -= TimeUnit.MINUTES.toMillis(minutes)) + 500L, TimeUnit.MILLISECONDS);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MoveTimeDialog.this.spHours.setValue(hours.intValue());
                MoveTimeDialog.this.spMinutes.setValue(minutes.intValue());
                MoveTimeDialog.this.spSeconds.setValue(seconds.intValue());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

