/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.GenericWizard;
import org.cesilko.rachota.gui.WizardStep;

public class ReportOutputWizardStep
extends WizardStep {
    private JButton btBrowse;
    private JLabel lbFilename;
    private JLabel lbFormat;
    private JLabel lbOutput;
    private JRadioButton rbCSV;
    private JRadioButton rbHTML;
    private JRadioButton rbInvoice;
    private JRadioButton rbReport;
    private JRadioButton rbTXT;
    private JTextField txFilename;
    private String selectedOutput = null;

    public ReportOutputWizardStep(GenericWizard wizard) {
        super(wizard, Translator.getTranslation("REPORTWIZARD.STEP_OUTPUT"));
        this.initComponents();
        this.selectOutput(".html");
        this.firePropertyChange("report.type", null, "report");
    }

    private void initComponents() {
        this.lbOutput = new JLabel();
        this.rbReport = new JRadioButton();
        this.rbInvoice = new JRadioButton();
        this.lbFormat = new JLabel();
        this.rbHTML = new JRadioButton();
        this.rbTXT = new JRadioButton();
        this.rbCSV = new JRadioButton();
        this.lbFilename = new JLabel();
        this.txFilename = new JTextField();
        this.btBrowse = new JButton();
        this.setLayout(new GridBagLayout());
        this.lbOutput.setFont(this.getFont());
        this.lbOutput.setLabelFor(this.rbReport);
        this.lbOutput.setText(Translator.getTranslation("REPORTWIZARD.LB_OUTPUT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lbOutput, gridBagConstraints);
        this.rbReport.setFont(this.getFont());
        this.rbReport.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_REPORT"));
        this.rbReport.setSelected(true);
        this.rbReport.setText(Translator.getTranslation("REPORTWIZARD.RB_REPORT"));
        this.rbReport.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_REPORT_TOOLTIP"));
        this.rbReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.rbReportActionPerformed(evt);
            }
        });
        this.rbReport.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.rbReport, gridBagConstraints);
        this.rbInvoice.setFont(this.getFont());
        this.rbInvoice.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_INVOICE"));
        this.rbInvoice.setText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE"));
        this.rbInvoice.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE_TOOLTIP"));
        this.rbInvoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.rbInvoiceActionPerformed(evt);
            }
        });
        this.rbInvoice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.rbInvoice, gridBagConstraints);
        this.lbFormat.setFont(this.getFont());
        this.lbFormat.setText(Translator.getTranslation("REPORTWIZARD.LB_FORMAT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lbFormat, gridBagConstraints);
        this.rbHTML.setFont(this.getFont());
        this.rbHTML.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_HTML"));
        this.rbHTML.setText(Translator.getTranslation("REPORTWIZARD.RB_HTML"));
        this.rbHTML.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_HTML_TOOLTIP"));
        this.rbHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.rbHTMLActionPerformed(evt);
            }
        });
        this.rbHTML.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.rbHTML, gridBagConstraints);
        this.rbTXT.setFont(this.getFont());
        this.rbTXT.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_TXT"));
        this.rbTXT.setText(Translator.getTranslation("REPORTWIZARD.RB_TXT"));
        this.rbTXT.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_TXT_TOOLTIP"));
        this.rbTXT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.rbTXTActionPerformed(evt);
            }
        });
        this.rbTXT.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.rbTXT, gridBagConstraints);
        this.rbCSV.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_CSV"));
        this.rbCSV.setFont(this.getFont());
        this.rbCSV.setText(Translator.getTranslation("REPORTWIZARD.RB_CSV"));
        this.rbCSV.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_CSV_TOOLTIP"));
        this.rbCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.rbCSVActionPerformed(evt);
            }
        });
        this.rbCSV.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.rbCSV, gridBagConstraints);
        this.lbFilename.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_FILENAME"));
        this.lbFilename.setFont(this.getFont());
        this.lbFilename.setLabelFor(this.txFilename);
        this.lbFilename.setText(Translator.getTranslation("REPORTWIZARD.LB_FILENAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lbFilename, gridBagConstraints);
        this.txFilename.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportOutputWizardStep.this.txFilenameFocusLost(evt);
            }
        });
        this.txFilename.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.txFilename, gridBagConstraints);
        this.btBrowse.setFont(this.getFont());
        this.btBrowse.setMnemonic(Translator.getMnemonic("REPORTWIZARD.BT_BROWSE"));
        this.btBrowse.setText(Translator.getTranslation("REPORTWIZARD.BT_BROWSE"));
        this.btBrowse.setToolTipText(Translator.getTranslation("REPORTWIZARD.BT_BROWSE_TOOLTIP"));
        this.btBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportOutputWizardStep.this.btBrowseActionPerformed(evt);
            }
        });
        this.btBrowse.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportOutputWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        this.add((Component)this.btBrowse, gridBagConstraints);
    }

    private void rbHTMLActionPerformed(ActionEvent evt) {
        this.selectOutput(".html");
    }

    private void rbTXTActionPerformed(ActionEvent evt) {
        this.selectOutput(".txt");
    }

    private void rbCSVActionPerformed(ActionEvent evt) {
        this.selectOutput(".csv");
    }

    private void btBrowseActionPerformed(ActionEvent evt) {
        String location = (String)Settings.getDefault().getSetting("reportDir");
        if (location == null) {
            location = (String)Settings.getDefault().getSetting("userDir");
        }
        JFileChooser fileChooser = new JFileChooser(location);
        final String extension = this.selectedOutput;
        final String extensionDescription = "All *" + extension + " files";
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(extension);
            }

            @Override
            public String getDescription() {
                return extensionDescription;
            }
        });
        fileChooser.setApproveButtonText(Translator.getTranslation("HISTORYVIEW.BT_SELECT"));
        fileChooser.setApproveButtonMnemonic(Translator.getMnemonic("HISTORYVIEW.BT_SELECT"));
        fileChooser.setApproveButtonToolTipText(Translator.getTranslation("HISTORYVIEW.BT_SELECT_TOOLTIP"));
        int decision = fileChooser.showOpenDialog(this);
        if (decision != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        String fileName = file.getAbsolutePath();
        if (!fileName.endsWith(extension)) {
            file = new File(fileName + extension);
        }
        fileName = file.getAbsolutePath();
        fileName = fileName.substring(0, fileName.indexOf("."));
        if (file.exists()) {
            Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
            decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.OVERWRITE_FILE", new String[]{file.getName()}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[1]);
            if (decision != 0) {
                return;
            }
        }
        this.txFilename.setText(file.getAbsolutePath());
        this.firePropertyChange("report.output.file_selected", null, file);
    }

    private void txFilenameFocusLost(FocusEvent evt) {
        String fileName = this.txFilename.getText();
        if (fileName.equals("")) {
            return;
        }
        String extension = this.selectedOutput;
        if (!fileName.endsWith(extension)) {
            fileName = fileName + extension;
        }
        File file = new File(fileName);
        fileName = file.getAbsolutePath();
        fileName = fileName.substring(0, fileName.indexOf("."));
        if (file.exists()) {
            Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
            int decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.OVERWRITE_FILE", new String[]{file.getName()}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[1]);
            if (decision != 0) {
                return;
            }
        }
        this.txFilename.setText(file.getAbsolutePath());
        this.firePropertyChange("report.output.file_selected", null, file);
    }

    private void rbReportActionPerformed(ActionEvent evt) {
        this.rbInvoice.setSelected(false);
        this.rbReport.setSelected(true);
        this.rbCSV.setEnabled(true);
        this.firePropertyChange("report.type", null, "report");
    }

    private void rbInvoiceActionPerformed(ActionEvent evt) {
        this.rbInvoice.setSelected(true);
        this.rbReport.setSelected(false);
        this.rbCSV.setEnabled(false);
        this.selectOutput(".html");
        this.firePropertyChange("report.type", null, "invoice");
    }

    private void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.firePropertyChange("wizard.step.next", null, this);
        }
        if (evt.getKeyCode() == 27) {
            this.firePropertyChange("wizard.cancel", null, null);
        }
    }

    @Override
    protected void setFocus() {
        if (this.txFilename != null) {
            this.txFilename.requestFocus();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void selectOutput(String output) {
        this.rbHTML.setSelected(output.equals(".html"));
        this.rbTXT.setSelected(output.equals(".txt"));
        this.rbCSV.setSelected(output.equals(".csv"));
        if (output.equals(this.selectedOutput)) {
            return;
        }
        this.selectedOutput = output;
        this.firePropertyChange("report.output.format_selected", null, this.selectedOutput);
        this.txFilename.setText("");
        this.firePropertyChange("report.output.file_selected", null, null);
    }

    @Override
    protected boolean isSetCorrectly() {
        if (this.txFilename == null) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_OUTPUT_FILE"));
            return false;
        }
        if (this.txFilename.getText().isEmpty()) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_OUTPUT_FILE"));
            return false;
        }
        this.firePropertyChange("status.error", null, null);
        return true;
    }
}

