/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoManager;
import org.ujoframework.extensions.ListUjoProperty;

public class UjoCoder {
    private final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final SimpleDateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final Class[] CONSTRUCTOR_TYPE = new Class[]{String.class};

    public char getSeparator() {
        return ',';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodeValue(Object object, boolean bl) {
        String string;
        if (object == null) {
            string = null;
        } else if (String.class == object.getClass()) {
            string = (String)object;
        } else if (object instanceof Number) {
            string = String.valueOf(object);
        } else if (byte[].class == object.getClass()) {
            string = this.encodeBytes((byte[])object);
        } else if (char[].class == object.getClass()) {
            string = new String((char[])object);
        } else if (Character.class == object.getClass()) {
            string = Integer.toString(((Character)object).charValue());
        } else if (Locale.class == object.getClass()) {
            Locale locale = (Locale)object;
            StringBuilder stringBuilder = new StringBuilder(10);
            stringBuilder.append(locale.getLanguage());
            String string2 = locale.getCountry();
            if (UjoManager.isUsable(string2)) {
                stringBuilder.append('-').append(string2);
                string2 = locale.getVariant();
                if (UjoManager.isUsable(string2)) {
                    stringBuilder.append('-').append(string2);
                }
            }
            string = stringBuilder.toString();
        } else if (object instanceof java.util.Date) {
            if (object instanceof Date) {
                SimpleDateFormat simpleDateFormat = this.FORMAT_DAY;
                synchronized (simpleDateFormat) {
                    string = this.FORMAT_DAY.format((Date)object);
                }
            } else {
                SimpleDateFormat simpleDateFormat = this.FORMAT_DATE;
                synchronized (simpleDateFormat) {
                    string = this.FORMAT_DATE.format((java.util.Date)object);
                }
            }
        } else if (object instanceof Color) {
            string = Integer.toHexString(((Color)object).getRGB() & 0xFFFFFF | 0x1000000).substring(1).toUpperCase();
        } else if (object instanceof File) {
            string = ((File)object).getPath();
        } else if (object instanceof Dimension) {
            string = ((Dimension)object).width + "," + ((Dimension)object).height;
        } else if (object instanceof Enum) {
            string = ((Enum)object).name();
        } else if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            string = new StringBuilder(32).append(rectangle.x).append(',').append(rectangle.y).append(',').append(rectangle.width).append(',').append(rectangle.height).toString();
        } else if (object instanceof Class) {
            string = ((Class)object).getName();
        } else if (object instanceof Charset) {
            string = ((Charset)object).name();
        } else if (object instanceof List) {
            StringBuilder stringBuilder = new StringBuilder(64);
            List list = (List)object;
            char c = this.getSeparator();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                String string3 = this.encodeValue(list.get(i), bl);
                if (bl && string3.indexOf(c) >= 0) {
                    String string4 = "The item of list '" + string3 + "' must not contain the separator character '" + c + "'";
                    throw new IllegalArgumentException(string4);
                }
                stringBuilder.append(string3);
            }
            string = stringBuilder.toString();
        } else {
            if (bl) {
                try {
                    Constructor<?> constructor = object.getClass().getConstructor(CONSTRUCTOR_TYPE);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
                }
            }
            string = String.valueOf(object);
        }
        return string;
    }

    public Object decodeValue(UjoProperty ujoProperty, String string, Class clazz) throws IllegalArgumentException {
        if (ujoProperty instanceof ListUjoProperty) {
            if (string == null || string.length() == 0) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ListUjoProperty listUjoProperty = (ListUjoProperty)ujoProperty;
            String string2 = String.valueOf(this.getSeparator());
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Object object = this.decodeValue(listUjoProperty.getItemType(), string3);
                arrayList.add(object);
            }
            return arrayList;
        }
        Object object = this.decodeValue(clazz != null ? clazz : ujoProperty.getType(), string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decodeValue(Class clazz, String string) throws IllegalArgumentException {
        try {
            if (string == null || String.class == clazz) {
                return string;
            }
            if (string.length() == 0) {
                return null;
            }
            if (Integer.class == clazz) {
                int n = Integer.parseInt(string);
                return n;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                if (Short.class == clazz) {
                    short s = Short.parseShort(string);
                    return s;
                }
                if (Long.class == clazz) {
                    Long l = new Long(string);
                    return 0L == l ? 0L : l;
                }
                if (Float.class == clazz) {
                    Float f = new Float(string);
                    return Float.valueOf(0.0f == f.floatValue() ? 0.0f : f.floatValue());
                }
                if (Double.class == clazz) {
                    Double d = new Double(string);
                    return 0.0 == d ? 0.0 : d;
                }
                if (BigDecimal.class == clazz) {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    return bigDecimal;
                }
                Constructor constructor = clazz.getConstructor(CONSTRUCTOR_TYPE);
                Object t = constructor.newInstance(string);
                return t;
            }
            if (Boolean.class == clazz) {
                Boolean bl = Boolean.valueOf(string);
                return bl;
            }
            if (Character.class == clazz) {
                char c = (char)Integer.parseInt(string);
                return Character.valueOf(c);
            }
            if (byte[].class == clazz) {
                byte[] byArray = this.decodeBytes(string);
                return byArray;
            }
            if (char[].class == clazz) {
                char[] cArray = string.toCharArray();
                return cArray;
            }
            if (Locale.class == clazz) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                Locale locale = new Locale(string2, string3, string4);
                return locale;
            }
            if (Class.class == clazz) {
                Class<?> clazz2 = Class.forName(string);
                return clazz2;
            }
            if (clazz.isEnum()) {
                Object t = Enum.valueOf(clazz, string);
                return t;
            }
            if (Dimension.class.isAssignableFrom(clazz)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                Dimension dimension = new Dimension(n, n2);
                return dimension;
            }
            if (Rectangle.class.isAssignableFrom(clazz)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                Rectangle rectangle = new Rectangle(n, n3, n4, n5);
                return rectangle;
            }
            if (java.util.Date.class.isAssignableFrom(clazz)) {
                try {
                    java.util.Date date;
                    if (Date.class.isAssignableFrom(clazz)) {
                        SimpleDateFormat simpleDateFormat = this.FORMAT_DAY;
                        synchronized (simpleDateFormat) {
                            date = new Date(this.FORMAT_DAY.parse(string).getTime());
                        }
                    }
                    SimpleDateFormat simpleDateFormat = this.FORMAT_DATE;
                    synchronized (simpleDateFormat) {
                        date = this.FORMAT_DATE.parse(string);
                    }
                    return date;
                }
                catch (ParseException parseException) {
                    new IllegalArgumentException("\"" + string + "\" " + clazz, parseException);
                }
            }
            if (Color.class.isAssignableFrom(clazz)) {
                Color color = new Color(Integer.parseInt(string, 16));
                return color;
            }
            if (File.class.isAssignableFrom(clazz)) {
                File file = new File(string);
                return file;
            }
            if (Charset.class.isAssignableFrom(clazz)) {
                Charset charset = Charset.forName(string);
                return charset;
            }
            Constructor constructor = clazz.getConstructor(CONSTRUCTOR_TYPE);
            Object t = constructor.newInstance(string);
            return t;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Can't decode \"" + string + "\" to " + clazz, throwable);
        }
    }

    protected byte[] decodeBytes(String string) {
        byte[] byArray = new byte[string.length() >> 1];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
            ++n;
            n2 += 2;
        }
        return byArray;
    }

    protected String encodeBytes(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuilder.append(cArray[(by & 0xF0) >>> 4]);
            stringBuilder.append(cArray[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public boolean isContainerType(Class clazz) {
        boolean bl = Ujo.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz);
        return bl;
    }
}

