/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoActionImpl;
import org.ujoframework.core.UjoManager;
import org.ujoframework.core.UjoService;
import org.ujoframework.extensions.UjoAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoManagerCSV<UJO extends Ujo>
extends UjoService<UJO> {
    private final char quotation = (char)34;
    private char separator = (char)59;
    private String newLine = System.getProperty("line.separator");
    private boolean printHeader = true;

    public UjoManagerCSV(Class<UJO> clazz, UjoProperty ... ujoPropertyArray) {
        super(clazz, ujoPropertyArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCSV(File file, List<UJO> list, Object object) throws IOException, InstantiationException, IllegalAccessException {
        OutputStream outputStream = this.getOutputStream(file);
        try {
            this.saveCSV(outputStream, UTF_8, list, object);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCSV(OutputStream outputStream, Charset charset, List<UJO> list, Object object) throws IOException, InstantiationException, IllegalAccessException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset != null ? charset : UTF_8);
        try {
            this.saveCSV(outputStreamWriter, list, object);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    public void saveCSV(Writer writer, List<UJO> list, Object object) throws IOException, InstantiationException, IllegalAccessException {
        if (this.printHeader) {
            Ujo ujo = list.size() > 0 ? (Ujo)list.get(0) : (Ujo)this.getUjoClass().newInstance();
            boolean bl = false;
            for (UjoProperty ujoProperty : this.getProperties()) {
                if (this.getUjoManager().isTransientProperty(ujoProperty) || ujo != null && !ujo.readAuthorization(new UjoActionImpl(13, object), ujoProperty, null)) continue;
                if (bl) {
                    writer.write(this.separator);
                } else {
                    bl = true;
                }
                this.printValue(writer, this.getHeaderTitle(ujoProperty));
            }
            writer.write(this.newLine);
        }
        for (Ujo ujo : list) {
            boolean bl = false;
            UjoProperty[] ujoPropertyArray = this.getProperties();
            int n = ujoPropertyArray.length;
            for (int i = 0; i < n; ++i) {
                UjoActionImpl ujoActionImpl = new UjoActionImpl(13, object);
                UjoProperty ujoProperty = ujoPropertyArray[i];
                String string = this.getText(ujo, ujoProperty, UNDEFINED, ujoActionImpl);
                if (!ujo.readAuthorization(ujoActionImpl, ujoProperty, string) || this.getUjoManager().isTransientProperty(ujoProperty)) continue;
                if (bl) {
                    writer.write(this.separator);
                } else {
                    bl = true;
                }
                this.printValue(writer, string);
            }
            writer.write(this.newLine);
        }
    }

    protected String getHeaderTitle(UjoProperty ujoProperty) {
        return ujoProperty.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UJO> loadCSV(File file, Object object) throws IOException, InstantiationException, IllegalAccessException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(file), UTF_8);
        try {
            List<UJO> list = this.loadCSV(new Scanner(inputStreamReader), object);
            return list;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    public List<UJO> loadCSV(Scanner scanner, Object object) throws InstantiationException, IllegalAccessException {
        ArrayList<Ujo> arrayList = new ArrayList<Ujo>(128);
        StringBuilder stringBuilder = new StringBuilder(32);
        boolean bl = this.printHeader;
        boolean bl2 = false;
        int n = 0;
        UjoActionImpl ujoActionImpl = new UjoActionImpl(object);
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            ++n;
            if (bl) {
                bl = false;
                continue;
            }
            Ujo ujo = (Ujo)this.getUjoClass().newInstance();
            arrayList.add(ujo);
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl2) {
                    if (c == '\"') {
                        int n3 = i + 1;
                        if (n3 < string.length() && string.charAt(n3) == '\"') {
                            ++i;
                        } else {
                            bl2 = false;
                            continue;
                        }
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (c == this.separator) {
                    this.writeValue(ujo, stringBuilder, n2++, n, ujoActionImpl);
                    continue;
                }
                if (c == '\"') {
                    bl2 = true;
                    continue;
                }
                stringBuilder.append(c);
            }
            this.writeValue(ujo, stringBuilder, n2++, n, ujoActionImpl);
        }
        return arrayList;
    }

    protected void writeValue(UJO UJO, StringBuilder stringBuilder, int n, int n2, UjoAction ujoAction) throws IllegalArgumentException {
        if (n >= this.getProperties().length) {
            throw new IllegalArgumentException("Too many columns on the row: " + n2 + " value: " + stringBuilder.toString());
        }
        this.setText(UJO, this.getProperties()[n], null, stringBuilder.toString(), ujoAction);
        stringBuilder.setLength(0);
    }

    protected void printValue(Writer writer, String string) throws IOException {
        if (UjoManager.isUsable(string) && (string.indexOf(this.separator) >= 0 || string.indexOf(34) >= 0)) {
            writer.write(34);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    writer.write(34);
                }
                writer.write(c);
            }
            writer.write(34);
        } else {
            writer.write(string);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public UjoManagerCSV setSeparator(char c) {
        this.separator = c;
        return this;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String string) {
        this.newLine = string;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public UjoManagerCSV setPrintHeader(boolean bl) {
        this.printHeader = bl;
        return this;
    }

    public static <UJO extends Ujo> UjoManagerCSV<UJO> getInstance(Class<UJO> clazz) {
        return UjoManagerCSV.getInstance(clazz, null);
    }

    public static <UJO extends Ujo> UjoManagerCSV<UJO> getInstance(Class<UJO> clazz, UjoProperty ... ujoPropertyArray) {
        return new UjoManagerCSV<UJO>(clazz, ujoPropertyArray);
    }
}

