/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoManager;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.extensions.UjoTextable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UjoService<UJO extends Ujo> {
    public static final String UNDEFINED = new String("U");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Class<UJO> ujoClass;
    private UjoProperty[] properties;
    private final boolean textable;
    private UjoManager ujoManager = UjoManager.getInstance();

    public UjoService(Class<UJO> clazz) {
        this(clazz, null);
    }

    public UjoService(Class<UJO> clazz, UjoProperty ... ujoPropertyArray) {
        this.ujoClass = clazz;
        this.properties = ujoPropertyArray;
        this.textable = UjoTextable.class.isAssignableFrom(clazz);
    }

    public final Class<UJO> getUjoClass() {
        return this.ujoClass;
    }

    public final boolean isTextable() {
        return this.textable;
    }

    public final UjoManager getUjoManager() {
        return this.ujoManager;
    }

    public UjoService setUjoManager(UjoManager ujoManager) {
        this.ujoManager = ujoManager;
        return this;
    }

    public UjoProperty[] getProperties() {
        if (this.properties == null) {
            this.properties = this.ujoManager.readProperties(this.getUjoClass()).toArray();
        }
        return this.properties;
    }

    public String getText(UJO UJO, UjoProperty ujoProperty, Object object, UjoAction ujoAction) {
        String string = this.textable ? ((UjoTextable)UJO).readValueString(ujoProperty, ujoAction) : this.ujoManager.encodeValue(object != UNDEFINED ? object : UjoManager.getValue(UJO, ujoProperty), false);
        return string;
    }

    public void setText(UJO UJO, UjoProperty ujoProperty, Class clazz, String string, UjoAction ujoAction) {
        if (this.textable) {
            ((UjoTextable)UJO).writeValueString(ujoProperty, string, clazz, ujoAction);
        } else {
            Object object = this.ujoManager.decodeValue(ujoProperty, string, clazz);
            UjoManager.setValue(UJO, ujoProperty, object);
        }
    }

    protected OutputStream getOutputStream(File file) throws FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        return bufferedOutputStream;
    }

    protected InputStream getInputStream(File file) throws FileNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return bufferedInputStream;
    }
}

