/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.criterion;

import java.util.Locale;
import java.util.regex.Pattern;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.criterion.Criterion;
import org.ujoframework.criterion.Operator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCriterion<UJO extends Ujo>
extends Criterion<UJO> {
    public static final Criterion<Ujo> TRUE = new ValueCriterion<Ujo>(true);
    public static final Criterion<Ujo> FALSE = new ValueCriterion<Ujo>(false);
    private final UjoProperty property;
    private final Operator operator;
    protected final Object value;

    public ValueCriterion(boolean bl) {
        this(null, Operator.X_FIXED, bl);
    }

    public ValueCriterion(UjoProperty<UJO, ? extends Object> ujoProperty, Operator operator, UjoProperty<UJO, Object> ujoProperty2) {
        this((UjoProperty<UJO, Object>)ujoProperty, operator, (Object)ujoProperty2);
    }

    public ValueCriterion(UjoProperty<UJO, ? extends Object> ujoProperty, Operator operator, Object object) {
        if (ujoProperty == null) {
            object = (Boolean)object;
        }
        if (operator == null) {
            operator = Operator.EQ;
        }
        switch (operator) {
            case EQUALS_CASE_INSENSITIVE: 
            case STARTS: 
            case STARTS_CASE_INSENSITIVE: 
            case ENDS: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS: 
            case CONTAINS_CASE_INSENSITIVE: {
                this.makeCharSequenceTest(ujoProperty);
                this.makeCharSequenceTest(object);
            }
        }
        this.property = ujoProperty;
        this.value = object;
        this.operator = operator;
    }

    @Override
    public final UjoProperty getLeftNode() {
        return this.property;
    }

    @Override
    public final Object getRightNode() {
        return this.value;
    }

    @Override
    public final Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean evaluate(UJO UJO) {
        if (this.isConstant()) {
            return (Boolean)this.value;
        }
        Object object = this.value instanceof UjoProperty ? ((UjoProperty)this.value).getValue(UJO) : this.value;
        boolean bl = true;
        switch (this.operator) {
            case EQ: 
            case NOT_EQ: {
                boolean bl2 = this.property.equals(UJO, object);
                return this.operator == Operator.EQ ? bl2 : !bl2;
            }
            case REGEXP: 
            case NOT_REGEXP: {
                boolean bl3;
                Pattern pattern = object instanceof Pattern ? (Pattern)object : Pattern.compile(object.toString());
                Object VALUE = this.property.getValue(UJO);
                boolean bl4 = bl3 = VALUE != null && pattern.matcher(VALUE.toString()).matches();
                return this.operator == Operator.REGEXP ? bl3 : !bl3;
            }
            case STARTS: 
            case ENDS: 
            case CONTAINS: {
                bl = false;
            }
            case EQUALS_CASE_INSENSITIVE: 
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                Object VALUE = this.property.of(UJO);
                if (VALUE == object) {
                    return true;
                }
                if (VALUE == null || object == null) {
                    return false;
                }
                String string = VALUE.toString();
                String string2 = object.toString();
                if (bl) {
                    string = string.toUpperCase(Locale.ENGLISH);
                    string2 = string2.toUpperCase(Locale.ENGLISH);
                }
                switch (this.operator) {
                    case EQUALS_CASE_INSENSITIVE: {
                        return string.equals(string2);
                    }
                    case STARTS: 
                    case STARTS_CASE_INSENSITIVE: {
                        return string.startsWith(string2);
                    }
                    case ENDS: 
                    case ENDS_CASE_INSENSITIVE: {
                        return string.endsWith(string2);
                    }
                    case CONTAINS: 
                    case CONTAINS_CASE_INSENSITIVE: {
                        return string.contains(string2);
                    }
                }
                throw new IllegalStateException("State:" + this.operator);
            }
        }
        Comparable comparable = (Comparable)object;
        if (null == comparable) {
            return false;
        }
        Comparable comparable2 = (Comparable)this.property.getValue(UJO);
        if (null == comparable2) {
            return false;
        }
        int n = this.compare(comparable2, comparable);
        switch (this.operator) {
            case LT: {
                return n < 0;
            }
            case LE: {
                return n <= 0;
            }
            case GT: {
                return n > 0;
            }
            case GE: {
                return n >= 0;
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + this.operator);
    }

    protected void makeCharSequenceTest(Object object) throws IllegalArgumentException {
        if (object instanceof CharSequence || object instanceof UjoProperty && ((UjoProperty)object).isTypeOf(CharSequence.class)) {
            return;
        }
        throw new IllegalArgumentException("Property type must by String or CharSequence");
    }

    protected int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == comparable2) {
            return 0;
        }
        if (comparable == null) {
            return 1;
        }
        if (comparable2 == null) {
            return -1;
        }
        return comparable.compareTo(comparable2);
    }

    public boolean isInsensitive() {
        switch (this.operator) {
            case EQUALS_CASE_INSENSITIVE: 
            case STARTS_CASE_INSENSITIVE: 
            case ENDS_CASE_INSENSITIVE: 
            case CONTAINS_CASE_INSENSITIVE: {
                return true;
            }
        }
        return false;
    }

    public final boolean isConstant() {
        return this.operator == Operator.X_FIXED;
    }

    public String toString() {
        String string = this.isConstant() ? "" : this.property + " " + this.operator.name() + " ";
        return string + this.value;
    }
}

