/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.core;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.WorkSpace;
import net.ponec.jworksheet.bo.item.Time;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.core.MessageException;
import net.ponec.jworksheet.core.SysTray;
import net.ponec.jworksheet.gui.JWorkSheet;
import net.ponec.jworksheet.module.JwsContext;
import net.ponec.jworksheet.module.ModuleApi;
import net.ponec.jworksheet.report.MetaReport;
import net.ponec.jworksheet.resources.ResourceProvider;
import org.ujoframework.core.UjoManagerRBundle;
import org.ujoframework.core.UjoManagerXML;
import org.ujoframework.extensions.UjoTextable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplContext
implements TableModelListener,
Runnable,
JwsContext {
    public static final boolean LANGUAGE_MANAGER_ENABLED = true;
    private static final Logger LOGGER = Logger.getLogger(ApplContext.class.getName());
    public static final String FILE_LOCK = "locker.lck";
    public static final String FILE_DATA = "data.xml";
    public static final String FILE_STYLES = "styles";
    public static final String FILE_MODULES = "modules";
    public static final String EXTENSION_TMP = ".tmp";
    public static final String MODULE_ENTRY = "META-INF/JWS-MODULE.MF";
    protected JWorkSheet topFrame;
    protected LanguageManager languageManager;
    private SysTray systray;
    private String userConfigDir = null;
    protected Parameters parameters = new Parameters();
    protected WorkSpace workSpace;
    protected WorkDay currentDay;
    protected long timeSaveExpected = 0L;
    protected final int timeInterval = 30000;
    private boolean initialized = false;
    private boolean dataRestored = false;
    private List<ModuleApi> modules;

    public ApplContext() {
        this.systray = SysTray.getInstance(this);
    }

    @Override
    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public void loadData() {
        boolean bl;
        boolean bl2;
        float f = this.getDataVersion();
        if (f > 0.0f && f < 0.78f) {
            this.makeDataConversion(f);
        }
        this.deleteTempFiles();
        this.saveStyleFiles();
        this.loadParameters();
        File file = this.getDataFile();
        File file2 = this.getDataFileBackup();
        boolean bl3 = bl2 = file.isFile() && file.length() > 0L;
        boolean bl4 = bl2 ? false : (bl = file2.isFile() && file2.length() > 0L);
        if (!bl2 && bl) {
            try {
                ApplTools.copy(file2, file);
                this.dataRestored = true;
                bl2 = bl;
            }
            catch (Throwable throwable) {
                throw new MessageException("Can't restore data file\n " + file + " from\n " + file2, throwable);
            }
        }
        if (bl2) {
            try {
                WorkSpace workSpace;
                this.workSpace = workSpace = UjoManagerXML.getInstance().parseXML(this.getDataFile(), WorkSpace.class, (Object)"Data Loading");
                this.workSpace.assingTasks();
            }
            catch (Throwable throwable) {
                throw new MessageException("Can't load file: " + file, throwable);
            }
        } else {
            this.workSpace = new WorkSpace();
            this.workSpace.createDemoData();
        }
        if (this.isTimeToBackup() && file.exists()) {
            try {
                ApplTools.copy(file, file2);
                WorkSpace.P_ARCHIVED.setValue(this.workSpace, new Date());
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Can't create backup", throwable);
            }
        }
        this.selectWorkDay(new YearMonthDay());
    }

    public void initModules() {
        this.modules = new ArrayList<ModuleApi>();
        String string = "?";
        for (File file : this.getModulesDir().listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                int n;
                string = file.getPath();
                JarFile jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(MODULE_ENTRY);
                if (jarEntry == null) continue;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
                while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                String string2 = byteArrayOutputStream.toString("UTF-8");
                int n2 = 1 + string2.indexOf(58);
                String string3 = string2.substring(n2).trim();
                if (!ApplTools.isValid(string2)) continue;
                Class clazz = ApplTools.getClass(string3, file);
                ModuleApi moduleApi = (ModuleApi)clazz.newInstance();
                moduleApi.setJwsContext(this);
                this.modules.add(moduleApi);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Can't load module from file: " + string, throwable);
            }
        }
    }

    private boolean isTimeToBackup() {
        Calendar calendar = Calendar.getInstance();
        long l = this.getDayCount(calendar);
        Date date = WorkSpace.P_ARCHIVED.of(this.workSpace);
        if (date == null) {
            WorkSpace.P_ARCHIVED.setValue(this.workSpace, calendar.getTime());
            return false;
        }
        calendar.setTime(date);
        long l2 = this.getDayCount(calendar);
        return l > l2 && !this.isDataRestored();
    }

    private long getDayCount(Calendar calendar) {
        return calendar.get(6) + calendar.get(1) * 365;
    }

    public synchronized void saveData(boolean bl) {
        Object object;
        try {
            WorkSpace.P_CREATED.setValue(this.workSpace, new Date());
            WorkSpace.P_VERSN.setValue(this.workSpace, "0.90");
            object = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <?xml-stylesheet type=\"text/xsl\" href=\"styles/" + ResourceProvider.REPORT_BASE + "\"?> -->";
            File file = this.getDataFileTemp();
            UjoManagerXML.getInstance().saveXML(file, (UjoTextable)this.workSpace, (String)object, (Object)this);
            ApplTools.rename(file, this.getDataFile());
        }
        catch (IOException iOException) {
            throw new MessageException("Can't save: " + this.getDataFile(), iOException);
        }
        if (bl) {
            object = Parameters.P_WINDOW_SIZE_RESTORATION.of(this.parameters) != false ? this.topFrame.getBounds() : Parameters.P_WINDOW_SIZE.getDefault();
            Parameters.P_WINDOW_SIZE.setValue(this.parameters, (Rectangle)object);
            this.saveParameters();
        }
    }

    public void closeAppl(boolean bl) {
        File file;
        this.createExitEvent();
        this.saveData(true);
        if (bl) {
            this.getTopFrame().setVisible(false);
            this.getTopFrame().dispose();
        }
        if ((file = new File(this.getConfigDir(), FILE_LOCK)).exists()) {
            file.delete();
        }
        this.fireModuleEvent();
    }

    public void createExitEvent() {
        Event event;
        Time time;
        Time time2;
        WorkDay workDay;
        List<Event> list;
        if (Parameters.P_EXIT_EVENT_CREATE.of(this.parameters).booleanValue() && (list = WorkDay.P_EVENTS.getList(workDay = this.workSpace.findWorkDay(new YearMonthDay()))).size() >= 1 && (time2 = new Time(true)).compareTo(time = (event = list.get(list.size() - 1)).getTimeFinished()) >= 0) {
            Event event2;
            String string = Parameters.P_EXIT_EVENT_DESCR.of(this.parameters);
            if (Event.P_PROJ.of(event) == null && Event.P_TASK.of(event) == null && Event.P_DESCR.equals(event, string) && list.size() >= 2) {
                event2 = event;
                event = list.get(list.size() - 2);
            } else {
                event2 = new Event();
                list.add(event2);
            }
            Event.P_TIME.setValue(event2, time2);
            Event.P_DESCR.setValue(event2, string);
            Event.P_PERIOD.setValue(event, time2.substract(Event.P_TIME.of(event)));
        }
    }

    @Override
    public File getConfigDir() {
        File file;
        if (this.userConfigDir != null) {
            file = new File(this.userConfigDir);
            if (!file.isDirectory() || !file.canWrite()) {
                throw new MessageException("Can't write data to a parameter directory: " + this.userConfigDir);
            }
        } else {
            file = new File(System.getProperty("user.home"), ".jWorkSheet");
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new MessageException("Can't create directory: " + file);
            }
        }
        return file;
    }

    @Override
    public File getStyleDir() {
        File file = new File(this.getConfigDir(), FILE_STYLES);
        return file;
    }

    public File getModulesDir() {
        File file = new File(this.getConfigDir(), FILE_MODULES);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    @Override
    public File getConfigFile() {
        File file = new File(this.getConfigDir(), "config.properties");
        return file;
    }

    @Override
    public File getDataFile() {
        File file = Parameters.P_DATA_FILE_PATH.of(this.getParameters());
        if (file == Parameters.P_DATA_FILE_PATH.getDefault()) {
            file = new File(this.getConfigDir(), FILE_DATA);
        }
        return file;
    }

    @Override
    public File getDataFileTemp() throws IOException {
        File file = File.createTempFile("data", EXTENSION_TMP, this.getConfigFile().getParentFile());
        return file;
    }

    public void deleteTempFiles() {
        File file = this.getConfigDir();
        for (String string : file.list()) {
            if (!string.endsWith(EXTENSION_TMP)) continue;
            File file2 = new File(file, string);
            file2.delete();
        }
    }

    @Override
    public File getDataFileBackup() {
        File file = new File(this.getConfigDir(), "data.backup.xml");
        return file;
    }

    @Override
    public File getStyleFile(String string) {
        File file = new File(this.getConfigDir(), "styles/" + string);
        return file;
    }

    @Override
    public YearMonthDay getSelectedDay() {
        return WorkDay.P_DATE.of(this.currentDay);
    }

    public String getSelectedDayStr() {
        return this.getSelectedDay().toString(this);
    }

    @Override
    public boolean isToday() {
        return new YearMonthDay().equals(this.getSelectedDay());
    }

    @Override
    public Locale getLanguage() {
        return Parameters.P_LANG.of(this.parameters);
    }

    public void selectWorkDay(YearMonthDay yearMonthDay) {
        this.currentDay = this.workSpace.findWorkDay(yearMonthDay);
    }

    @Override
    public WorkDay getWorkDay() {
        return this.currentDay;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.initialized && this.timeSaveExpected < System.currentTimeMillis()) {
            this.timeSaveExpected = System.currentTimeMillis() + 30000L;
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        try {
            this.saveData(true);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "Can't save data", throwable);
        }
    }

    public boolean createLock(boolean bl) {
        File file = new File(this.getConfigDir(), FILE_LOCK);
        try {
            if (file.createNewFile() || bl) {
                file.deleteOnExit();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new MessageException("Can't create a lock " + file);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    protected void loadParameters() {
        File file = this.getConfigFile();
        if (file.exists() && file.canRead()) {
            try {
                this.parameters = UjoManagerRBundle.getInstance(Parameters.class).loadResourceBundle(file, false, (Object)"props");
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Can't load Parameters to " + file, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStyleFiles() {
        InputStream inputStream = null;
        String string = null;
        try {
            String[] stringArray;
            File file = this.getStyleDir();
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException("Can't create directory: " + file);
            }
            for (String string2 : stringArray = new String[]{ResourceProvider.REPORT_BASE, ResourceProvider.REPORT_BASE2, "style.css", ResourceProvider.LOGO16}) {
                inputStream = new ResourceProvider().getUrl(string2).openStream();
                File file2 = this.getStyleFile(string2);
                ApplTools.copy(inputStream, file2);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Can't create an file " + string);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveParameters() {
        try {
            UjoManagerRBundle.getInstance(Parameters.class).saveResourceBundle(this.getConfigFile(), this.parameters, "A jWorkSheet configuration file:", (Object)this);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Can't save Parameters to " + this.getConfigFile(), throwable);
        }
    }

    public void setInitialized() {
        try {
            this.initModules();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "err", throwable);
        }
        this.languageManager.setLocaleAndTranslate(Parameters.P_LANG.of(this.parameters), true);
        this.fireModuleEvent();
        this.initialized = true;
    }

    @Override
    public boolean isStarting() {
        return !this.initialized;
    }

    public void fireModuleEvent() {
        for (ModuleApi moduleApi : this.modules) {
            moduleApi.eventListener(this.isStarting());
        }
    }

    public float getDataVersion() {
        try {
            DecimalFormat decimalFormat = ApplTools.createDecimalFormat("0.0");
            String string = this.getTagContent(this.getDataFile(), WorkSpace.P_VERSN.getName());
            float f = string != null ? decimalFormat.parse(string).floatValue() : -1.0f;
            return f;
        }
        catch (Throwable throwable) {
            return -1.0f;
        }
    }

    public String getTagContent(File file, String string) throws IOException {
        String string2 = ApplTools.getFileContent(file, Charset.forName("UTF-8"), 300);
        String string3 = "<" + string + ">";
        String string4 = "</" + string + ">";
        int n = string2.indexOf(string3);
        int n2 = string2.indexOf(string4, n + 1);
        if (n > 0 && n2 > n) {
            String string5 = string2.substring(n + string3.length(), n2);
            return string5;
        }
        return null;
    }

    @Override
    public JWorkSheet getTopFrame() {
        return this.topFrame;
    }

    public void setTopFrame(JWorkSheet jWorkSheet, boolean bl) {
        this.topFrame = jWorkSheet;
        this.languageManager = new LanguageManager(jWorkSheet, ResourceProvider.class, bl);
        this.languageManager.setLocaleAndTranslate(Parameters.P_LANG.of(this.parameters), false);
    }

    public void setUserConfigDir(String string) {
        this.userConfigDir = string;
    }

    public void showReport(String string, File file, ArrayList<String[]> arrayList) throws TransformerConfigurationException, TransformerException, IOException {
        StreamSource streamSource = string != null ? new StreamSource(string) : new StreamSource(this.getDataFile());
        StreamSource streamSource2 = new StreamSource(file);
        File file2 = ApplTools.makeXslTransformation(streamSource, streamSource2, arrayList);
        this.topFrame.browse(file2.toURI().toString());
    }

    public List<MetaReport> getMetaReports() {
        File file = this.getStyleDir();
        String[] stringArray = file.list();
        ArrayList<MetaReport> arrayList = new ArrayList<MetaReport>(stringArray.length);
        for (String string : stringArray) {
            try {
                if (!string.endsWith(".xsl")) continue;
                File file2 = new File(file, string);
                String string2 = this.getTagContent(file2, "title");
                String string3 = this.getTagContent(file2, "copyright");
                MetaReport metaReport = new MetaReport(string2, file2, FILE_DATA);
                arrayList.add(metaReport);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Can't read an XSl file.", iOException);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public boolean isSystrayEnabled() {
        boolean bl = Parameters.P_SYSTRAY_ENABLED.of(this.getParameters()) != false && this.systray.isSupported();
        return bl;
    }

    public Event findLastEventToday() {
        if (this.getWorkSpace() == null) {
            return null;
        }
        WorkDay workDay = this.getWorkSpace().findWorkDay(new YearMonthDay());
        List<Event> list = WorkDay.P_EVENTS.getList(workDay);
        int n = list.size() - 1;
        return n >= 0 ? list.get(n) : null;
    }

    public void setSystrayTooltip() {
        Project project;
        StringBuilder stringBuilder = new StringBuilder();
        Event event = this.findLastEventToday();
        if (event != null && (project = Event.P_PROJ.of(event)) != null) {
            stringBuilder.append(Project.P_DESCR.of(project));
            TaskType taskType = Event.P_TASK.of(event);
            if (taskType != null) {
                stringBuilder.append(" / ");
                stringBuilder.append(TaskType.P_DESCR.of(taskType));
            }
        }
        this.systray.setTooltip(stringBuilder.toString());
        this.topFrame.setTitle(stringBuilder.toString());
    }

    public void showReport(String string) throws IOException {
        Writer writer = null;
        try {
            File file = File.createTempFile("_report.", ".html");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            writer.write(string);
            writer.close();
            this.getTopFrame().browse(file.toURI().toString());
        }
        catch (IOException iOException) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Can't close a temp file.");
                }
            }
            throw iOException;
        }
    }

    public boolean isDataRestored() {
        return this.dataRestored;
    }

    private void makeDataConversion(float f) {
        FileOutputStream fileOutputStream = null;
        try {
            String string = ApplTools.getFileContent(this.getDataFile(), Charset.forName("UTF-8"), Integer.MAX_VALUE);
            string = string.replaceAll("<Time javaClass=\"java.lang.String\">", "<Time>");
            File file = this.getDataFileTemp();
            File file2 = this.getDataFile();
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes("UTF-8"));
            fileOutputStream.close();
            ApplTools.rename(file, file2);
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException("Can't convert data file from version: " + f);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Bug", iOException);
                }
            }
        }
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.getTopFrame().getTabbedPane();
    }
}

