/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.core;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.LanguageManagerDialog;
import org.ujoframework.UjoProperty;

public class LanguageManager {
    private static final Logger LOGGER = Logger.getLogger(LanguageManager.class.getName());
    public static final String STOP_TRANSLATION = "~STOP~TRANSLATION";
    public static final Locale DEFAULT_LOCALE = new Locale("");
    private final String SWING_PREFIX = "javax.swing.J";
    private final String DOT = ".";
    public static final boolean DEBUG_MODE = false;
    public static final boolean enableTiming = false;
    protected Container basicContainer;
    protected String bundleName;
    protected WeakHashMap<Locale, ResourceBundle> bundleMap;
    protected Locale locale;
    protected boolean firstRuning = true;
    private boolean show;
    private StringBuilder keyConvertorBuffer = null;
    private static final String[] mText = new String[]{"getText", "setText"};
    private static final String[] mTitle = new String[]{"getTitle", "setTitle"};
    private static final Class[] parameterTypes1 = new Class[0];
    private static final Class[] parameterTypes2 = new Class[]{String.class};
    private static final String nl = "\n";
    private final boolean newSolution4Key = true;
    private StringBuilder properties;
    private StringBuilder warnings;

    public LanguageManager(Container container, Class clazz, boolean bl) {
        this.basicContainer = container != null ? container : new JPanel();
        this.bundleName = clazz.getPackage().getName() + ".text";
        this.bundleMap = new WeakHashMap(1);
        this.show = bl;
        if (this.show) {
            this.properties = new StringBuilder();
            this.warnings = new StringBuilder();
        }
    }

    public void setFirstRunTexts(Container container) {
        this.setFirstRunTexts(container, this.locale);
    }

    public void setFirstRunTexts(Container container, Locale locale) {
        this.firstRuning = true;
        this.setTexts(null, container);
    }

    public void setLocaleAndTranslate(Locale locale, boolean bl) {
        this.locale = this.getSupportedLocale(locale);
        if (bl) {
            this.setTexts(null, this.basicContainer);
        }
    }

    private Locale getSupportedLocale(Locale locale) {
        boolean bl = this.findPropertyBundle(locale);
        if (!bl) {
            locale = DEFAULT_LOCALE;
        }
        return locale;
    }

    private boolean findPropertyBundle(Locale locale) {
        String string = "/" + this.bundleName.replace('.', '/');
        String string2 = "_" + locale.toString();
        int n = string2.length();
        while (n > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string + string3 + ".properties";
            URL uRL = this.getClass().getResource(string4);
            if (uRL != null) {
                return true;
            }
            n = string2.substring(0, n).lastIndexOf(95);
        }
        return false;
    }

    public void setLocale(Locale locale, boolean bl) {
        this.setTexts(locale, bl ? this.basicContainer : null);
    }

    public void setTexts(Locale locale, Container container) {
        if (locale != null) {
            this.setLocale(locale, true);
        }
        if (container == null) {
            return;
        }
        long l = 0L;
        if (this.show) {
            this.properties.setLength(0);
            this.warnings.setLength(0);
            this.properties.append("# Properties for " + this.bundleName + " object (" + new Date() + ") :" + nl + nl);
            this.warnings.append("# Warnings for " + this.bundleName + " object (" + new Date() + ") :" + nl + nl);
        }
        this.keyConvertorBuffer = new StringBuilder(50);
        try {
            this.createName2(container);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Language", exception);
        }
        this.keyConvertorBuffer = null;
        if (this.show && this.firstRuning) {
            this.show();
        }
        this.firstRuning = false;
    }

    private void show() {
        new LanguageManagerDialog(this.basicContainer, this.properties.toString(), this.warnings.toString());
    }

    private String getClassType(Container container) {
        String string = container.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.startsWith("javax.swing.J") ? "." + string.substring("javax.swing.J".length()) : string.substring(n);
        }
        return string;
    }

    private void createName2(Container container) {
        block44: {
            int n;
            String[] stringArray;
            String string = null;
            if (container == null || STOP_TRANSLATION.equals(container.getName())) {
                return;
            }
            if (container instanceof JToolBar) {
                stringArray = (JToolBar)container;
                try {
                    for (n = 0; n < 1000; ++n) {
                        this.createName3(stringArray.getComponentAtIndex(n));
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Language", throwable);
                }
            } else if (container instanceof JTabbedPane) {
                stringArray = (JTabbedPane)container;
                for (n = 0; n < stringArray.getTabCount(); ++n) {
                    this.createName3(stringArray.getComponentAt(n));
                }
            } else if (container instanceof JScrollPane) {
                stringArray = (JScrollPane)container;
                this.createName3(stringArray.getViewport().getView());
            } else if (container instanceof JPanel || container instanceof JSplitPane || container instanceof JLayeredPane || container instanceof JOptionPane) {
                stringArray = container.getComponents();
                for (n = 0; n < stringArray.length; ++n) {
                    this.createName3(stringArray[n]);
                }
            } else if (container instanceof MenuElement) {
                stringArray = ((MenuElement)((Object)container)).getSubElements();
                for (n = 0; n < stringArray.length; ++n) {
                    this.createName3(stringArray[n]);
                }
            } else if (container instanceof JFrame) {
                this.createName2(((JFrame)container).getJMenuBar());
                this.createName2(((JFrame)container).getContentPane());
            } else if (container instanceof JDialog) {
                this.createName2(((JDialog)container).getJMenuBar());
                this.createName2(((JDialog)container).getContentPane());
            }
            if (container instanceof JTextComponent || container instanceof JTable || container instanceof JTree) {
                container.setLocale(this.locale);
                return;
            }
            string = this.getClassType(container);
            String string2 = container.getName();
            if (container instanceof JTabbedPane) {
                String string3;
                Component component;
                stringArray = (JTabbedPane)container;
                if (this.firstRuning && this.isEmptyName(string2) && stringArray.getTabCount() > 0) {
                    stringArray.setName("~TabbedPane");
                    for (n = 0; n < stringArray.getTabCount(); ++n) {
                        component = stringArray.getComponentAt(n);
                        if (component == null || !this.isEmptyName(component.getName())) continue;
                        string3 = stringArray.getTitleAt(n);
                        string2 = this.text2key(string3);
                        component.setName("~" + string2);
                        if (!this.show) continue;
                        this.properties.append(string + "." + this.text2key(string2) + "=" + stringArray.getTitleAt(n) + nl);
                    }
                }
                if (this.isDefinedName(stringArray.getName())) {
                    for (n = 0; n < stringArray.getTabCount(); ++n) {
                        component = stringArray.getComponentAt(n);
                        if (component == null || !this.isDefinedName(component.getName())) continue;
                        string2 = component.getName();
                        string3 = string2.startsWith("~") ? string + "." + string2.substring(1) : string2;
                        stringArray.setTitleAt(n, this.getText(string3));
                    }
                }
                container.setLocale(this.locale);
                return;
            }
            if (container instanceof JComponent && (stringArray = ((JComponent)container).getBorder()) instanceof TitledBorder) {
                String string4;
                TitledBorder titledBorder = (TitledBorder)stringArray;
                if (this.firstRuning && this.isEmptyName(string2)) {
                    string4 = titledBorder.getTitle();
                    string2 = "~" + this.text2key(string4);
                    container.setName(string2);
                    if (this.show) {
                        this.properties.append(string + "." + this.text2key(string4) + "=" + string4 + nl);
                    }
                }
                if (this.isDefinedName(string2)) {
                    string4 = string2.startsWith("~") ? string + "." + string2.substring(1) : string2;
                    try {
                        titledBorder.setTitle(this.getText(string4));
                        container.repaint();
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, "Language", throwable);
                    }
                }
                container.setLocale(this.locale);
                return;
            }
            if (!(container.getClass().equals(JPanel.class) || container.getClass().equals(JSplitPane.class) || container.getClass().equals(JScrollPane.class))) {
                try {
                    String string5;
                    Method method;
                    String string6;
                    String[] stringArray2 = stringArray = container instanceof JFrame || container instanceof JDialog ? mTitle : mText;
                    if (this.firstRuning && this.isEmptyName(string2) && ApplTools.isValid(string6 = (String)(method = container.getClass().getMethod(stringArray[0], parameterTypes1)).invoke((Object)container, new Object[0]))) {
                        string2 = "~" + this.text2key(string6);
                        container.setName(string2);
                        if (this.show) {
                            this.properties.append(string + "." + this.text2key(string6) + "=" + string6 + nl);
                        }
                    }
                    if (!this.isDefinedName(string2)) break block44;
                    method = container.getClass().getMethod(stringArray[1], parameterTypes2);
                    String string7 = string6 = string2.startsWith("~") ? string + "." + string2.substring(1) : string2;
                    if (container instanceof JButton || container instanceof JToggleButton || container instanceof JLabel) {
                        try {
                            string5 = this.getText(string6 + ".TIP");
                            if (string5 != null) {
                                ((JComponent)container).setToolTipText(string5);
                            }
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    string5 = this.getText(string6);
                    method.invoke((Object)container, string5);
                    if (container instanceof AbstractButton && string5 != null) {
                        AbstractButton abstractButton = (AbstractButton)container;
                        n = string5.indexOf(38);
                        if (n >= 0 && n + 1 < string5.length() && string5.charAt(n + 1) != '&') {
                            StringBuilder stringBuilder = new StringBuilder(string5);
                            stringBuilder.deleteCharAt(n);
                            stringBuilder.setLength(n);
                            stringBuilder.append(string5.substring(n + 1));
                            string5 = stringBuilder.toString();
                            abstractButton.setText(string5);
                            abstractButton.setMnemonic((int)Character.toUpperCase(string5.charAt(n)));
                            abstractButton.setDisplayedMnemonicIndex(n);
                        } else {
                            abstractButton.setMnemonic(0);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.err(container, "Not assigned by the Exception:" + throwable.getClass().getName() + " (" + throwable.getMessage() + ")");
                }
            }
        }
        container.setLocale(this.locale);
    }

    private final boolean isDefinedName(String string) {
        return ApplTools.isValid(string) && "~.".indexOf(string.charAt(0)) >= 0;
    }

    private final boolean isEmptyName(String string) {
        return !ApplTools.isValid(string);
    }

    private final void createName3(Object object) {
        if (object instanceof Container) {
            this.createName2((Container)object);
        }
    }

    private void err(Container container, String string) {
        if (this.show) {
            this.warnings.append("Container: " + container.getClass().getName() + " - " + string + nl);
        }
    }

    private String text2key(String string) {
        boolean bl;
        this.keyConvertorBuffer.setLength(0);
        boolean bl2 = bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl3 = bl2 = Character.isWhitespace(c) || !Character.isLetterOrDigit(c) && ".=+&".indexOf(c) < 0;
            if (c == '=') {
                this.keyConvertorBuffer.append("\\=");
            } else if (c != ':' && !bl2) {
                if (bl) {
                    if (this.bufferEndsUpperChar(this.keyConvertorBuffer)) {
                        this.keyConvertorBuffer.append('_');
                    }
                    this.keyConvertorBuffer.append(Character.toUpperCase(c));
                } else {
                    this.keyConvertorBuffer.append(c);
                }
            }
            bl = bl2;
        }
        return this.keyConvertorBuffer.toString();
    }

    private boolean bufferEndsUpperChar(StringBuilder stringBuilder) {
        boolean bl;
        if (stringBuilder.length() == 0) {
            bl = false;
        } else {
            char c = stringBuilder.charAt(stringBuilder.length() - 1);
            bl = Character.isUpperCase(c);
        }
        return bl;
    }

    public String getText(Class clazz, String string, Locale locale) {
        locale = this.getSupportedLocale(locale);
        String string2 = ResourceBundle.getBundle(clazz.getName(), locale).getString(string);
        return string2;
    }

    public String getTextAllways(Class clazz, String string, Locale locale) {
        return this.getTextAllways(clazz, string, null, locale);
    }

    public String getTextAllways(Class clazz, String string, String[] stringArray, Locale locale) {
        String string2;
        try {
            string2 = this.getText(clazz, string, locale);
            if (stringArray != null) {
                string2 = MessageFormat.format(string2, stringArray);
            }
        }
        catch (Throwable throwable) {
            string2 = string + " (an language message not found!)";
        }
        return string2;
    }

    public String getText(String string, boolean bl) throws MissingResourceException {
        try {
            return this.getText(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (bl) {
                throw missingResourceException;
            }
            System.err.println("KEY:" + string);
            return "[" + string + "]";
        }
    }

    public String getText(String string) {
        ResourceBundle resourceBundle = this.bundleMap.get(this.locale);
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, this.locale);
            this.bundleMap.clear();
            this.bundleMap.put(this.locale, resourceBundle);
        }
        return resourceBundle.getString(string);
    }

    public String getTextAllways(UjoProperty ujoProperty) {
        return this.getTextAllways("tab." + ujoProperty.getName());
    }

    public String getTextAllways(String string) {
        String string2;
        if (string == null) {
            string = "" + string;
        }
        try {
            string2 = this.getText(string);
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    public String getText(String string, Object ... objectArray) {
        String string2 = this.getText(string);
        string2 = MessageFormat.format(string2, objectArray);
        return string2;
    }

    public String getText(String string, Object object) {
        String string2 = object != null ? this.getText(string, new Object[]{object}) : this.getText(string);
        return string2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void showDebugData(Container container) {
    }
}

