/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import java.io.IOException;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.report.GroupSet;
import net.ponec.jworksheet.report.ReportB;
import net.ponec.jworksheet.report.SuperReport;
import net.ponec.jworksheet.report.TaskGroup;
import org.ujoframework.core.UjoComparator;

public class ReportA
extends SuperReport {
    protected GroupSet groupSet = null;

    protected void init() {
        if (this.groupSet == null) {
            UjoComparator ujoComparator = this.createUjoComparator();
            this.groupSet = new GroupSet(ujoComparator, Event.P_PERIOD);
        }
    }

    protected UjoComparator createUjoComparator() {
        UjoComparator ujoComparator = UjoComparator.newInstance(TaskGroup.P_PROJ, TaskGroup.P_TASK);
        return ujoComparator;
    }

    public void calculate(WorkDay workDay, Event event) {
        this.groupSet.addTime(event);
    }

    public String print() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(256);
        boolean bl = !ReportB.class.equals(this.getClass());
        this.printFilter(stringBuilder);
        this.printTableBeg(stringBuilder);
        int n = this.printDetail(stringBuilder);
        this.printTotal(n, bl, stringBuilder);
        this.printTableEnd(stringBuilder);
        String string = this.getReport(stringBuilder.toString(), this.reportTitle);
        return string;
    }

    public int printDetail(StringBuilder stringBuilder) throws IOException {
        int n = 0;
        stringBuilder.append("<tr>");
        stringBuilder.append("<th align=\"left\">").append(this.getText(Event.P_PROJ)).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText(Event.P_TASK)).append("</th>");
        stringBuilder.append("<th align=\"right\">").append(this.getText("Time[hours]")).append("</th>");
        stringBuilder.append("</tr>");
        for (TaskGroup taskGroup : this.groupSet.getGroups()) {
            Project project = TaskGroup.P_PROJ.of(taskGroup);
            TaskType taskType = TaskGroup.P_TASK.of(taskGroup);
            if (project != null && Project.P_PRIVATE.of(project).booleanValue()) continue;
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>").append(this.escape(project)).append("</td>");
            stringBuilder.append("<td>").append(this.escape(taskType)).append("</td>");
            stringBuilder.append("<td class=\"num\">").append(this.formatTime(taskGroup.getTime())).append("</td>");
            stringBuilder.append("</tr>");
            n += taskGroup.getTime();
        }
        return n;
    }

    protected void printTotal(int n, boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("<tr class=\"total\">");
        stringBuilder.append("<td class=\"alignLeft\">").append(this.getText("TotalTime")).append("</td>");
        if (bl) {
            stringBuilder.append("<td>").append("&nbsp;").append("</td>");
        }
        stringBuilder.append("<td>").append(this.formatTime(n)).append("</td>");
        stringBuilder.append("</tr>");
        float f = (float)this.getWorkDayCount() * Parameters.P_WORKING_HOURS.of(this.applContext.getParameters()).floatValue();
        stringBuilder.append("<tr class=\"total\">");
        stringBuilder.append("<td class=\"alignLeft\">").append(this.getText("Overtime")).append("</td>");
        if (bl) {
            stringBuilder.append("<td>").append("&nbsp;").append("</td>");
        }
        stringBuilder.append("<td>").append(this.formatTime(n - Math.round(f * 60.0f))).append("</td>");
        stringBuilder.append("</tr>");
    }

    protected GroupSet getGroupSet() {
        return this.groupSet;
    }

    public void setGroupSet(GroupSet groupSet) {
        this.groupSet = groupSet;
    }
}

