/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.CoordinateSystem;
import boplanets.planetSystem.Planet;
import boplanets.util.AstroMath;

public class EquatorSystem
extends CoordinateSystem {
    private static final double MIN_Ra = -180.0;
    private static final double MAX_Ra = 180.0;
    private double _longAscNodeObs;
    private double _inclinObs;
    private double _obliqObs;
    private double _argEquinox;
    private double[] _minMaxRa = new double[2];
    protected double[] _minMaxDec = new double[2];

    public EquatorSystem(Planet[] planetArray) {
        this._viewType = 2;
        int n = planetArray.length - 1;
        Planet planet = planetArray[n];
        this.setOrbParamsOfObserver(planet);
        this.localSetMinMaxCoordinates(planetArray);
    }

    @Override
    public void setOrbParamsOfObserver(Planet planet) {
        this._longAscNodeObs = planet.longAscNode;
        this._inclinObs = planet.inclination;
        this._argEquinox = planet.argEquinox;
        this._obliqObs = planet.obliqu;
    }

    @Override
    public void setMinMaxCoordinates(Planet[] planetArray) {
        this.localSetMinMaxCoordinates(planetArray);
    }

    private void localSetMinMaxCoordinates(Planet[] planetArray) {
        double[] dArray = EquatorSystem.getMinMaxEquatorCoordinates(planetArray);
        this._minMaxRa[0] = dArray[0];
        this._minMaxRa[1] = dArray[1];
        this._minMaxDec[0] = dArray[2];
        this._minMaxDec[1] = dArray[3];
    }

    @Override
    public double[] getNextCoordinates(Planet planet, double[] dArray) {
        double[] dArray2 = AstroMath.eclipticToEquator(this._longAscNodeObs, this._inclinObs, this._argEquinox, this._obliqObs, dArray);
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = Math.atan2(d2, d);
        double d5 = Math.atan2(d3, Math.sqrt(d * d + d2 * d2));
        double d6 = d4 * 57.29577951308232;
        double d7 = d5 * 57.29577951308232;
        planet.ra = d6;
        planet.dec = d7;
        double[] dArray3 = new double[]{d6, d7};
        return dArray3;
    }

    public double[] getRaDecDerivAtDate(long l, Planet planet, Planet planet2) {
        double[][] dArray = planet.getPositionAndTangensEclAtDate(l);
        double[] dArray2 = new double[]{dArray[0][0], dArray[0][1], dArray[0][2]};
        double[] dArray3 = new double[]{dArray[1][0], dArray[1][1], dArray[1][2]};
        double[][] dArray4 = planet2.getPositionAndTangensEclAtDate(l);
        double[] dArray5 = new double[]{dArray4[0][0], dArray4[0][1], dArray4[0][2]};
        double[] dArray6 = new double[]{dArray4[1][0], dArray4[1][1], dArray4[1][2]};
        double[] dArray7 = AstroMath.vectorDiff(dArray2, dArray5);
        double[] dArray8 = AstroMath.vectorDiff(dArray3, dArray6);
        double[] dArray9 = AstroMath.eclipticToEquator(this._longAscNodeObs, this._inclinObs, this._argEquinox, this._obliqObs, dArray7);
        double d = dArray9[0];
        double d2 = dArray9[1];
        double d3 = dArray9[2];
        double d4 = (Math.atan2(d2, d) + Math.PI * 2) % (Math.PI * 2);
        double d5 = Math.atan2(d3, Math.sqrt(d * d + d2 * d2));
        double[] dArray10 = AstroMath.eclipticToEquator(this._longAscNodeObs, this._inclinObs, this._argEquinox, this._obliqObs, dArray8);
        double d6 = dArray10[0];
        double d7 = dArray10[1];
        double d8 = (d * d7 - d2 * d6) / (d * d + d2 * d2);
        double[] dArray11 = new double[]{d4, d5, d8};
        return dArray11;
    }

    @Override
    protected double[] getSpecMapParams(int n, int n2) {
        double[] dArray = EquatorSystem.getMapParams(n, n2, this._minMaxRa, this._minMaxDec);
        return dArray;
    }

    protected static double[] getMinMaxEquatorCoordinates(Planet[] planetArray) {
        int n = planetArray.length - 1;
        Planet planet = planetArray[0];
        double d = -180.0;
        double d2 = 180.0;
        double[][] dArray = planet.minMaxRaDec;
        double d3 = dArray[1][0];
        double d4 = dArray[1][1];
        for (int i = 1; i < n; ++i) {
            planet = planetArray[i];
            dArray = planet.minMaxRaDec;
            double d5 = dArray[1][0];
            double d6 = dArray[1][1];
            if (d5 < d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        double[] dArray2 = new double[]{d, d2, d3, d4};
        return dArray2;
    }
}

