/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.Const;
import boplanets.gui.PlanetsView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectPlanets
extends JFrame
implements ListSelectionListener {
    private JButton btnClose;
    private JButton btnStart;
    private JCheckBox chkEarth;
    private JCheckBox chkJupiter;
    private JCheckBox chkMars;
    private JCheckBox chkMercury;
    private JCheckBox chkNeptune;
    private JCheckBox chkPluto;
    private JCheckBox chkSaturn;
    private JCheckBox chkSun;
    private JCheckBox chkUranus;
    private JCheckBox chkVenus;
    private JList jlstObserver;
    private JPanel pnlObserver;
    private JPanel pnlPlanets;
    private JScrollPane scpnObserver;
    private URL _iconImgUrl;
    private int _indObserver;
    private int _noSelectedPlanets;
    private PlanetsView _planetsView;

    public SelectPlanets() {
        int n;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            UIManager.put("OptionPane.messageFont", new Font("Arial", 0, 11));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string = "images/Earth.jpg";
        this._iconImgUrl = this.getClass().getResource(string);
        this.initComponents();
        this.setSize(230, 350);
        ListSelectionModel listSelectionModel = this.jlstObserver.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this._indObserver = 3;
        int[] nArray = new int[]{this._indObserver};
        this.jlstObserver.setSelectedIndices(nArray);
        JCheckBox jCheckBox = (JCheckBox)this.pnlPlanets.getComponent(this._indObserver);
        jCheckBox.setEnabled(false);
        int n2 = this.pnlPlanets.getComponentCount();
        this._noSelectedPlanets = 0;
        for (n = 0; n < n2; ++n) {
            jCheckBox = (JCheckBox)this.pnlPlanets.getComponent(n);
            if (n == this._indObserver || !jCheckBox.isSelected()) continue;
            ++this._noSelectedPlanets;
        }
        if (this._noSelectedPlanets == 0) {
            n = this._indObserver == n2 - 1 ? this._indObserver - 1 : this._indObserver + 1;
            jCheckBox = (JCheckBox)this.pnlPlanets.getComponent(n);
            jCheckBox.setSelected(true);
            this._noSelectedPlanets = 1;
        }
        this.getRootPane().setDefaultButton(this.btnStart);
        this.btnStart.requestFocusInWindow();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SelectPlanets().setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.pnlObserver = new JPanel();
        this.scpnObserver = new JScrollPane();
        this.jlstObserver = new JList<String>(Const.planetNames);
        this.pnlPlanets = new JPanel();
        this.chkSun = new JCheckBox();
        this.chkMercury = new JCheckBox();
        this.chkVenus = new JCheckBox();
        this.chkEarth = new JCheckBox();
        this.chkMars = new JCheckBox();
        this.chkJupiter = new JCheckBox();
        this.chkSaturn = new JCheckBox();
        this.chkUranus = new JCheckBox();
        this.chkNeptune = new JCheckBox();
        this.chkPluto = new JCheckBox();
        this.btnClose = new JButton();
        this.btnStart = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("BoPlanets");
        this.setIconImage(new ImageIcon(this._iconImgUrl).getImage());
        this.setMinimumSize(new Dimension(230, 350));
        this.setName("SelectPlanets");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SelectPlanets.this.SelectPlanets_WindowClosed(windowEvent);
            }
        });
        this.getContentPane().setLayout(new FlowLayout(1, 5, 10));
        this.pnlObserver.setBackground(Color.white);
        this.pnlObserver.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Select Observer", 0, 0, new Font("Arial", 1, 12), Color.blue));
        this.pnlObserver.setPreferredSize(new Dimension(100, 240));
        this.scpnObserver.setBorder(null);
        this.scpnObserver.setPreferredSize(new Dimension(90, 210));
        this.jlstObserver.setFont(new Font("Arial", 0, 11));
        this.jlstObserver.setSelectionMode(0);
        this.jlstObserver.setToolTipText("select one planet as observing planet");
        this.jlstObserver.setFixedCellHeight(21);
        this.scpnObserver.setViewportView(this.jlstObserver);
        this.pnlObserver.add(this.scpnObserver);
        this.getContentPane().add(this.pnlObserver);
        this.pnlPlanets.setBackground(Color.white);
        this.pnlPlanets.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Select Planets", 0, 0, new Font("Arial", 1, 12), Color.blue));
        this.pnlPlanets.setToolTipText("select planets to be oberserved; observer is disabled.");
        this.pnlPlanets.setPreferredSize(new Dimension(100, 240));
        this.pnlPlanets.setLayout(new FlowLayout(0, 5, 1));
        this.chkSun.setBackground(Color.white);
        this.chkSun.setFont(new Font("Arial", 0, 11));
        this.chkSun.setSelected(true);
        this.chkSun.setText("Sun");
        this.chkSun.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkSun.setMargin(new Insets(0, 0, 0, 0));
        this.chkSun.setPreferredSize(new Dimension(75, 20));
        this.chkSun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkSun);
        this.chkMercury.setBackground(Color.white);
        this.chkMercury.setFont(new Font("Arial", 0, 11));
        this.chkMercury.setSelected(true);
        this.chkMercury.setText("Mercury");
        this.chkMercury.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkMercury.setMargin(new Insets(0, 0, 0, 0));
        this.chkMercury.setPreferredSize(new Dimension(75, 20));
        this.chkMercury.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkMercury);
        this.chkVenus.setBackground(Color.white);
        this.chkVenus.setFont(new Font("Arial", 0, 11));
        this.chkVenus.setSelected(true);
        this.chkVenus.setText("Venus");
        this.chkVenus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVenus.setMargin(new Insets(0, 0, 0, 0));
        this.chkVenus.setPreferredSize(new Dimension(75, 20));
        this.chkVenus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkVenus);
        this.chkEarth.setBackground(Color.white);
        this.chkEarth.setFont(new Font("Arial", 0, 11));
        this.chkEarth.setSelected(true);
        this.chkEarth.setText("Earth");
        this.chkEarth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkEarth.setEnabled(false);
        this.chkEarth.setMargin(new Insets(0, 0, 0, 0));
        this.chkEarth.setPreferredSize(new Dimension(75, 20));
        this.chkEarth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkEarth);
        this.chkMars.setBackground(Color.white);
        this.chkMars.setFont(new Font("Arial", 0, 11));
        this.chkMars.setSelected(true);
        this.chkMars.setText("Mars");
        this.chkMars.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkMars.setMargin(new Insets(0, 0, 0, 0));
        this.chkMars.setPreferredSize(new Dimension(75, 20));
        this.chkMars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkMars);
        this.chkJupiter.setBackground(Color.white);
        this.chkJupiter.setFont(new Font("Arial", 0, 11));
        this.chkJupiter.setSelected(true);
        this.chkJupiter.setText("Jupiter");
        this.chkJupiter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkJupiter.setMargin(new Insets(0, 0, 0, 0));
        this.chkJupiter.setPreferredSize(new Dimension(75, 20));
        this.chkJupiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkJupiter);
        this.chkSaturn.setBackground(Color.white);
        this.chkSaturn.setFont(new Font("Arial", 0, 11));
        this.chkSaturn.setSelected(true);
        this.chkSaturn.setText("Saturn");
        this.chkSaturn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkSaturn.setMargin(new Insets(0, 0, 0, 0));
        this.chkSaturn.setPreferredSize(new Dimension(75, 20));
        this.chkSaturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkSaturn);
        this.chkUranus.setBackground(Color.white);
        this.chkUranus.setFont(new Font("Arial", 0, 11));
        this.chkUranus.setSelected(true);
        this.chkUranus.setText("Uranus");
        this.chkUranus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkUranus.setMargin(new Insets(0, 0, 0, 0));
        this.chkUranus.setPreferredSize(new Dimension(75, 20));
        this.chkUranus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkUranus);
        this.chkNeptune.setBackground(Color.white);
        this.chkNeptune.setFont(new Font("Arial", 0, 11));
        this.chkNeptune.setSelected(true);
        this.chkNeptune.setText("Neptune");
        this.chkNeptune.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNeptune.setMargin(new Insets(0, 0, 0, 0));
        this.chkNeptune.setPreferredSize(new Dimension(75, 20));
        this.chkNeptune.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkNeptune);
        this.chkPluto.setBackground(Color.white);
        this.chkPluto.setFont(new Font("Arial", 0, 11));
        this.chkPluto.setSelected(true);
        this.chkPluto.setText("Pluto");
        this.chkPluto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkPluto.setMargin(new Insets(0, 0, 0, 0));
        this.chkPluto.setPreferredSize(new Dimension(75, 20));
        this.chkPluto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.chkPlanetsActionPerformed(actionEvent);
            }
        });
        this.pnlPlanets.add(this.chkPluto);
        this.getContentPane().add(this.pnlPlanets);
        this.btnClose.setFont(new Font("Arial", 0, 11));
        this.btnClose.setText("Close");
        this.btnClose.setToolTipText("stops BoPlanets and closes the form");
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setDefaultCapable(false);
        this.btnClose.setPreferredSize(new Dimension(65, 20));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.btnCloseActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.btnClose);
        this.btnStart.setFont(new Font("Arial", 0, 11));
        this.btnStart.setText("Start");
        this.btnStart.setToolTipText("start viewing the selected planets");
        this.btnStart.setBorder(new SoftBevelBorder(0));
        this.btnStart.setPreferredSize(new Dimension(65, 20));
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlanets.this.btnStartActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.btnStart);
        this.pack();
    }

    private void SelectPlanets_WindowClosed(WindowEvent windowEvent) {
        if (this._planetsView != null) {
            this._planetsView.dispose();
            this._planetsView = null;
        }
    }

    private void chkPlanetsActionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        if (jCheckBox.isSelected()) {
            ++this._noSelectedPlanets;
        } else if (this._noSelectedPlanets < 2) {
            jCheckBox.setSelected(true);
        } else {
            --this._noSelectedPlanets;
        }
    }

    private void btnStartActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.getSelectedPlanets();
        this._planetsView = new PlanetsView(this._indObserver, nArray);
        this._planetsView.setVisible(true);
    }

    private void btnCloseActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (!bl && !listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            JCheckBox jCheckBox = (JCheckBox)this.pnlPlanets.getComponent(this._indObserver);
            JCheckBox jCheckBox2 = (JCheckBox)this.pnlPlanets.getComponent(n);
            this._indObserver = n;
            jCheckBox.setEnabled(true);
            jCheckBox2.setEnabled(false);
            if (jCheckBox.isSelected()) {
                ++this._noSelectedPlanets;
            }
            if (jCheckBox2.isSelected()) {
                if (this._noSelectedPlanets < 2) {
                    jCheckBox.setSelected(true);
                } else {
                    --this._noSelectedPlanets;
                }
            }
        }
    }

    private int[] getSelectedPlanets() {
        int[] nArray = new int[this._noSelectedPlanets];
        int n = this.pnlPlanets.getComponentCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.pnlPlanets.getComponent(i);
            if (i == this._indObserver || !jCheckBox.isSelected()) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }
}

