/*
 * Decompiled with CFR 0.152.
 */
package boplanets.util;

public class AstroMath {
    private static final double EPS7 = 1.0E-7;
    private static final double PI = Math.PI;
    public static final double PI2 = Math.PI * 2;
    public static final double RAD_TO_DEGREES = 57.29577951308232;
    public static final double DEGREE_TO_Rad = Math.PI / 180;

    public static double[] findRoot1Dim(Newton newton, double d) {
        double d2 = d;
        double[] dArray = newton.equation1Dim(d2);
        double d3 = dArray[0];
        double d4 = d * 1.25;
        double d5 = 2.0E-7;
        for (int i = 0; d5 > 1.0E-7 && i < 25; ++i) {
            double d6 = dArray[1];
            if (Math.abs(d6) < 1.0E-7) {
                d2 = (d2 + d4) * 0.5;
            } else {
                d4 = d2;
                double d7 = d3;
                d2 = -d7 / d6 + d4;
            }
            dArray = newton.equation1Dim(d2);
            d3 = dArray[0];
            d5 = Math.abs(d3);
        }
        double d8 = d5 <= 1.0E-7 ? 0.0 : -1.0;
        double[] dArray2 = new double[]{d2, d8};
        return dArray2;
    }

    public static double[] findRoot2Dim(Newton newton, double d, double d2) {
        double d3 = 0.1;
        double d4 = 0.1;
        double d5 = d;
        double d6 = d2;
        double d7 = d5;
        double d8 = d6;
        double[] dArray = newton.equation2Dim(d5, d6);
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = dArray[6];
        double d12 = 2.0E-7;
        for (int i = 0; d12 > 1.0E-7 && i < 25; ++i) {
            double d13 = dArray[2];
            double d14 = dArray[3];
            double d15 = dArray[4];
            double d16 = dArray[5];
            double d17 = d9;
            double d18 = d10;
            d3 = -d17 * d16 + d14 * d18;
            d4 = -d13 * d18 + d17 * d15;
            double d19 = (d4 /= d11) / (d3 /= d11);
            if (Math.abs(d19) > 1.0) {
                if (Math.abs(d4) > 1.2) {
                    d4 = -Math.signum(d4) * 0.3;
                    d3 = d4 / d19;
                }
            } else if (Math.abs(d3) > 1.2) {
                d3 = -Math.signum(d3) * 0.3;
                d4 = d3 * d19;
            }
            d7 = d5;
            d8 = d6;
            d5 = d7 + d3;
            d6 = d8 + d4;
            dArray = newton.equation2Dim(d5, d6);
            d9 = dArray[0];
            d10 = dArray[1];
            d11 = dArray[6];
            d12 = (Math.abs(d9) + Math.abs(d10)) * 0.5;
        }
        double d20 = d12 <= 1.0E-7 ? 0.0 : -1.0;
        double[] dArray2 = new double[]{d5, d6, d11, d20};
        return dArray2;
    }

    public static double kepplerEquation(double d, double d2) {
        double d3 = Math.sin(d2) * d + d2;
        double d4 = Math.sin(d3) * d + d2 - d3;
        int n = 0;
        while (Math.abs(d4) > 1.0E-7) {
            d3 = d4 / (-Math.cos(d3) * d + 1.0) + d3;
            d4 = Math.sin(d3) * d + d2 - d3;
            ++n;
        }
        return d3;
    }

    public static double getTrueAno(double d, double d2) {
        double d3 = (d + Math.PI * 2) % (Math.PI * 2);
        double d4 = Math.cos(d3);
        double d5 = Math.acos((d4 - d2) / (-d4 * d2 + 1.0));
        return d3 <= Math.PI ? d5 : Math.PI * 2 - d5;
    }

    public static double getExcAno(double d, double d2) {
        double d3 = (d + Math.PI * 2) % (Math.PI * 2);
        double d4 = Math.cos(d3);
        double d5 = Math.acos((d4 + d2) / (d4 * d2 + 1.0));
        return d3 <= Math.PI ? d5 : Math.PI * 2 - d5;
    }

    public static double getExcAnoOfOpposite(double d, double d2) {
        double d3 = AstroMath.getTrueAno(d, d2);
        return AstroMath.getExcAno(d3 + Math.PI, d2);
    }

    public static double[][] getEclGaussVector(double d, double d2, double d3) {
        double d4 = Math.cos(d3);
        double d5 = Math.cos(d2);
        double d6 = Math.cos(d);
        double d7 = Math.sin(d3);
        double d8 = Math.sin(d2);
        double d9 = Math.sin(d);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = d4 * d6 - d7 * d5 * d9;
        dArray[1] = d4 * d9 + d7 * d5 * d6;
        dArray[2] = d7 * d8;
        dArray2[0] = -d7 * d6 - d4 * d5 * d9;
        dArray2[1] = -d7 * d9 + d4 * d5 * d6;
        dArray2[2] = d4 * d8;
        double[][] dArrayArray = new double[][]{dArray, dArray2};
        return dArrayArray;
    }

    public static double[][] getEquGaussVectorObs(double d, double d2, double d3) {
        double d4 = d - d2;
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cos(d3);
        double[] dArray = new double[]{d6, d8 * d5, -(d7 * d5)};
        double[] dArray2 = new double[]{-d5, d8 * d6, -(d7 * d6)};
        double[][] dArrayArray = new double[][]{dArray, dArray2};
        return dArrayArray;
    }

    public static double[][] getEquGaussVectorPlanet(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.sin(d);
        double d9 = Math.cos(d);
        double d10 = Math.sin(d2);
        double d11 = Math.cos(d2);
        double d12 = Math.sin(d3);
        double d13 = Math.cos(d3);
        double d14 = Math.sin(d4);
        double d15 = Math.cos(d4);
        double d16 = Math.sin(d5);
        double d17 = Math.cos(d5);
        double d18 = Math.sin(d6);
        double d19 = Math.cos(d6);
        double d20 = Math.sin(d7);
        double d21 = Math.cos(d7);
        double[][] dArrayArray = new double[][]{{d10 * d18 * d20 * d12 + (d21 * d16 + d17 * d19 * d20) * (d13 * d8 + d9 * d11 * d12) + (d17 * d21 - d19 * d16 * d20) * (d9 * d13 - d11 * d8 * d12), (d11 * d14 + d15 * d13 * d10) * d18 * d20 + (d17 * d21 - d19 * d16 * d20) * (d8 * d14 * d10 + d15 * (-(d11 * d13 * d8) - d9 * d12)) + (d21 * d16 + d17 * d19 * d20) * (-(d9 * d14 * d10) + d15 * (d9 * d11 * d13 - d8 * d12)), (d15 * d11 - d13 * d14 * d10) * d18 * d20 + (d17 * d21 - d19 * d16 * d20) * (d15 * d8 * d10 - d14 * (-(d11 * d13 * d8) - d9 * d12)) + (d21 * d16 + d17 * d19 * d20) * (-(d9 * d15 * d10) - d14 * (d9 * d11 * d13 - d8 * d12))}, {d21 * d10 * d18 * d12 + (d17 * d19 * d21 - d16 * d20) * (d13 * d8 + d9 * d11 * d12) + (-(d19 * d21 * d16) - d17 * d20) * (d9 * d13 - d11 * d8 * d12), d21 * (d11 * d14 + d15 * d13 * d10) * d18 + (-(d19 * d21 * d16) - d17 * d20) * (d8 * d14 * d10 + d15 * (-(d11 * d13 * d8) - d9 * d12)) + (d17 * d19 * d21 - d16 * d20) * (-(d9 * d14 * d10) + d15 * (d9 * d11 * d13 - d8 * d12)), d21 * (d15 * d11 - d13 * d14 * d10) * d18 + (-(d19 * d21 * d16) - d17 * d20) * (d15 * d8 * d10 - d14 * (-(d11 * d13 * d8) - d9 * d12)) + (d17 * d19 * d21 - d16 * d20) * (-(d9 * d15 * d10) - d14 * (d9 * d11 * d13 - d8 * d12))}};
        return dArrayArray;
    }

    public static double[] orbToEcliptic(double d, double d2, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray[i] * d + dArray2[i] * d2;
        }
        return dArray3;
    }

    public static double[] eclipticToOrb(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d = dArray2[i] * dArray[i] + d;
            d2 = dArray3[i] * dArray[i] + d2;
        }
        double[] dArray4 = new double[]{d, d2};
        return dArray4;
    }

    public static double[] eclipticToEquator(double d, double d2, double d3, double d4, double[] dArray) {
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        double d9 = Math.cos(d3);
        double d10 = Math.sin(d3);
        double d11 = Math.cos(d4);
        double d12 = Math.sin(d4);
        double d13 = dArray[0] * (d5 * d9 - d7 * d6 * d10) + dArray[1] * (d9 * d6 + d5 * d7 * d10) + dArray[2] * (d8 * d10);
        double d14 = dArray[0] * (-d6 * d12 * d8 - d11 * (d7 * d9 * d6 + d5 * d10)) + dArray[1] * (d5 * d12 * d8 + d11 * (d5 * d7 * d9 - d6 * d10)) + dArray[2] * (-d7 * d12 + d11 * d9 * d8);
        double d15 = dArray[0] * (d11 * d6 * d8 - d12 * (d7 * d9 * d6 + d5 * d10)) + dArray[1] * (-d5 * d11 * d8 + d12 * (d5 * d7 * d9 - d6 * d10)) + dArray[2] * (d11 * d7 + d9 * d12 * d8);
        double[] dArray2 = new double[]{d13, d14, d15};
        return dArray2;
    }

    public static double[] equatorToHorizon(double d, double d2, double d3, double d4) {
        double d5 = Math.cos(d3);
        double d6 = d - d2;
        double d7 = d5 * Math.cos(d6);
        double d8 = d5 * Math.sin(d6);
        double d9 = Math.sin(d3);
        d5 = Math.cos(d4);
        double d10 = Math.sin(d4);
        double d11 = d7 * d10 - d9 * d5;
        double d12 = d8;
        double d13 = d7 * d5 + d9 * d10;
        double d14 = Math.atan2(d13, Math.sqrt(d11 * d11 + d12 * d12));
        double d15 = Math.atan2(d12, d11);
        double[] dArray = new double[]{d15, d14};
        return dArray;
    }

    public static double[] getOrbitalNormal(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        double[] dArray = new double[]{d6 * d4, -d6 * d3, d5};
        return dArray;
    }

    public static double[] getEquatorNormal(double d, double d2, double d3, double d4) {
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        double d9 = Math.cos(d3);
        double d10 = Math.sin(d3);
        double d11 = Math.cos(-d4);
        double d12 = Math.sin(-d4);
        double[] dArray = new double[]{d11 * d6 * d8 - d12 * (-d7 * d9 * d6 - d5 * d10), -d5 * d11 * d8 - d12 * (d5 * d7 * d9 - d6 * d10), d11 * d7 - d9 * d12 * d8};
        return dArray;
    }

    public static double[] minMaxCartesianCoord(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        if (d4 <= 1.0E-8) {
            d7 = 0.0;
            d6 = 0.0;
        } else {
            double d8;
            double d9;
            double d10 = d4 * d;
            double d11 = d5 * d2;
            if (Math.abs(d10) < 1.0E-7) {
                d9 = -1.5707963267948966;
                d8 = 1.5707963267948966;
            } else {
                d8 = Math.atan(d11 / d10);
                d9 = d8 >= 0.0 ? d8 - Math.PI : d8 + Math.PI;
            }
            double d12 = -d10 * Math.cos(d8) - d11 * Math.sin(d8);
            if (d12 > 0.0) {
                double d13 = d8;
                d8 = d9;
                d9 = d13;
            }
            double[] dArray = AstroMath.orbitalEllipseExc(d4, d5, d3, d9);
            d7 = dArray[0] * d + dArray[1] * d2;
            dArray = AstroMath.orbitalEllipseExc(d4, d5, d3, d8);
            d6 = dArray[0] * d + dArray[1] * d2;
        }
        double[] dArray = new double[]{d7, d6};
        return dArray;
    }

    public static double[] orbitalEllipseExc(double d, double d2, double d3, double d4) {
        double d5 = (Math.cos(d4) - d3) * d;
        double d6 = Math.sin(d4) * d2;
        double[] dArray = new double[]{d5, d6};
        return dArray;
    }

    public static double[] orbitalEllipse(double d, double d2, double d3) {
        double d4 = Math.cos(d3);
        double d5 = d / (d2 * d4 + 1.0);
        double[] dArray = new double[]{d5 * d4, Math.sin(d3) * d5};
        return dArray;
    }

    public static double[] quadraticEquation(double d, double d2) {
        double d3 = d * d / 4.0 - d2;
        if (d3 < 1.0E-7) {
            if (d3 < -1.0E-7) {
                return null;
            }
            d3 = 0.0;
        }
        d3 = Math.sqrt(d3);
        double d4 = -d / 2.0;
        double d5 = d4 - d3;
        double[] dArray = new double[]{d4 += d3, d5};
        return dArray;
    }

    public static double[] oppositeVector(double[] dArray) {
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = -dArray[i];
        }
        return dArray2;
    }

    public static double[] vectorDiff(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] vectorAdd(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static double[] vectorMultiply(double d, double[] dArray) {
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public static double scalarProduct(double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] vectorProduct(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public static double[] vectorProductByLng(double d, double[] dArray, double[] dArray2) {
        double[] dArray3 = AstroMath.vectorProduct(dArray, dArray2);
        double d2 = Math.sqrt(AstroMath.scalarProduct(dArray3, dArray3));
        double[] dArray4 = new double[3];
        if (d2 > 1.0E-7) {
            d2 = d / d2;
            for (int i = 0; i < 3; ++i) {
                dArray4[i] = dArray3[i] * d2;
            }
            return dArray4;
        }
        return null;
    }

    public static double[] rotateVector(double[] dArray, double d, double[] dArray2) {
        double[] dArray3 = AstroMath.vectorProduct(dArray, dArray2);
        double[] dArray4 = AstroMath.vectorProduct(dArray, dArray3);
        double d2 = AstroMath.scalarProduct(dArray, dArray2);
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double[] dArray5 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray5[i] = d2 * dArray[i] + d4 * dArray3[i] - d3 * dArray4[i];
        }
        return dArray5;
    }

    public static final double to0_2PiIntervall(double d) {
        double d2 = (d + Math.PI * 2) % (Math.PI * 2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public static interface Newton {
        public static final double PRECISION = 1.0E-7;
        public static final int ITERATIONS = 25;

        public double[] equation1Dim(double var1);

        public double[] equation2Dim(double var1, double var3);
    }
}

