/*
 * Decompiled with CFR 0.152.
 */
package boplanets.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalUtil {
    public static final long REF_DATE_J2000 = CalUtil.getRefDateJ2000();
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final GregorianCalendar GMT_CALENDAR = new GregorianCalendar(GMT_TIME_ZONE);
    private static final String GMT_PATTERN_ERA = "dd.MM.yyyy HH:mm:ss G z";
    private static final String GMT_PATTERN_NO_ERA = "dd.MM.yyyy HH:mm:ss z";
    private static final SimpleDateFormat GMT_FORMAT_ERA = CalUtil.createGmtFormat("dd.MM.yyyy HH:mm:ss G z");
    private static final SimpleDateFormat GMT_FORMAT_NO_ERA = CalUtil.createGmtFormat("dd.MM.yyyy HH:mm:ss z");

    public static String formatGmtDate(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIME_ZONE);
        gregorianCalendar.setTimeInMillis(l);
        Date date = gregorianCalendar.getTime();
        return GMT_FORMAT_ERA.format(date);
    }

    public static String formatGmtDateNoEra(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIME_ZONE);
        gregorianCalendar.setTimeInMillis(l);
        Date date = gregorianCalendar.getTime();
        return GMT_FORMAT_NO_ERA.format(date);
    }

    public static String formatDate(long l, long l2, SimpleDateFormat simpleDateFormat) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)simpleDateFormat.getCalendar();
        gregorianCalendar.setTimeInMillis(l + l2);
        Date date = gregorianCalendar.getTime();
        return simpleDateFormat.format(date);
    }

    private static long getRefDateJ2000() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear(14);
        gregorianCalendar.set(2000, 0, 1, 0, 0, 0);
        long l = gregorianCalendar.getTimeInMillis();
        return l;
    }

    private static SimpleDateFormat createGmtFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setCalendar(GMT_CALENDAR);
        return simpleDateFormat;
    }
}

