/*
 * Decompiled with CFR 0.152.
 */
package boplanets.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class NumberConverter {
    private static final String NO_VALID_NUMBER = "No valid number";

    public static String format(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(5);
        return numberFormat.format(d);
    }

    public static final double checkDecimalValue(String string, double d, double d2) throws NumberFormatException {
        if (string.length() > 0) {
            String string2 = string.trim();
            try {
                double d3 = NumberConverter.parse(string2);
                if (d3 <= d2 && d3 >= d) {
                    return d3;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        NumberFormatException numberFormatException = new NumberFormatException(NO_VALID_NUMBER);
        throw numberFormatException;
    }

    public static double parse(String string) throws ParseException {
        Serializable serializable;
        String string2 = string.trim();
        int n = string2.length();
        int n2 = 0;
        if (n > 0) {
            serializable = NumberFormat.getNumberInstance();
            ((NumberFormat)serializable).setGroupingUsed(false);
            ParsePosition parsePosition = new ParsePosition(n2);
            Number number = ((NumberFormat)serializable).parse(string2, parsePosition);
            n2 = parsePosition.getIndex();
            if (n2 >= n) {
                return number.doubleValue();
            }
        }
        serializable = new ParseException(NO_VALID_NUMBER, n2);
        throw serializable;
    }
}

