/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.ui.container.MyImageLabel;
import de.lehmannet.om.ui.dialog.FITSImageDialog;
import de.lehmannet.om.ui.dialog.ImageDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.RelativPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

public class ImageContainer
extends Container
implements MouseListener,
Scrollable {
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    public static final int THUMBNAIL_SIZE_WIDTH = 96;
    public static final int THUMBNAIL_SIZE_HEIGHT = 96;
    public static final String THUMBNAIL_NAME_FITS = "fits.png";
    private ObservationManager om = null;
    private boolean editable = false;
    private GridBagLayout layout = new GridBagLayout();
    private int numberOfImages = 0;

    public ImageContainer(List files, ObservationManager om, boolean editable) {
        this.om = om;
        this.editable = editable;
        this.createContainer();
        this.addImages(files);
    }

    public void addImages(List images) {
        int i;
        if (images == null || images.size() <= 0) {
            return;
        }
        Image image = null;
        Image thumb = null;
        MyImageLabel label = null;
        String path = null;
        GridBagConstraints c = new GridBagConstraints();
        for (i = 0; i < images.size(); ++i) {
            if (images.get(i) instanceof String) {
                path = (String)images.get(i);
                if (path.startsWith("." + File.separator)) {
                    path = this.om.getXmlCache().getXMLPathForSchemaElement(this.om.getSelectedTableElement()) + File.separator + path;
                }
            } else {
                path = ((File)images.get(i)).getAbsolutePath();
                if (path.startsWith("." + File.separator)) {
                    path = this.om.getXmlCache().getXMLPathForSchemaElement(this.om.getSelectedTableElement()) + File.separator + path;
                }
            }
            if (!(path.endsWith(".fits") || path.endsWith(".fit") || path.endsWith(".fts"))) {
                image = Toolkit.getDefaultToolkit().getImage(path);
                thumb = image.getScaledInstance(96, 96, 2);
            } else {
                thumb = Toolkit.getDefaultToolkit().getImage(this.om.getInstallDir() + File.separator + "images" + File.separator + THUMBNAIL_NAME_FITS);
            }
            label = new MyImageLabel(new ImageIcon(thumb), path);
            label.addMouseListener(this);
            ConstraintsBuilder.buildConstraints(c, i + this.numberOfImages, 0, 1, 1, 1, 1);
            this.layout.setConstraints(label, c);
            super.add(label);
            if (!this.editable) continue;
            JLabel delete = new JLabel(this.bundle.getString("imageContainer.deleteImage"));
            delete.setForeground(Color.BLUE);
            delete.addMouseListener(this);
            label.addDeleteButton(delete);
            ConstraintsBuilder.buildConstraints(c, i + this.numberOfImages, 1, 1, 1, 1, 1);
            this.layout.setConstraints(delete, c);
            super.add(delete);
        }
        this.numberOfImages += i;
    }

    public List getImages(String homeDir) {
        if (super.getComponents() == null) {
            return new ArrayList();
        }
        boolean relativePath = Boolean.valueOf(this.om.getConfiguration().getConfig("om.imagesDir.relaitve"));
        if (homeDir == null || "".equals(homeDir.trim())) {
            relativePath = false;
        }
        Component[] comps = super.getComponents();
        ArrayList<String> result = new ArrayList<String>(comps.length);
        for (int i = 0; i < comps.length; ++i) {
            MyImageLabel l = null;
            if (!(comps[i] instanceof MyImageLabel)) continue;
            l = (MyImageLabel)comps[i];
            if (relativePath) {
                result.add(RelativPath.getRelativePath(new File(homeDir), new File(l.getPath())));
                continue;
            }
            result.add(l.getPath());
        }
        return result;
    }

    private void createContainer() {
        super.setLayout(this.layout);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (e.getSource() instanceof MyImageLabel) {
                MyImageLabel l = (MyImageLabel)e.getSource();
                if (!(l.getPath().endsWith(".fits") || l.getPath().endsWith(".fit") || l.getPath().endsWith(".fts"))) {
                    new ImageDialog(l.getImage(), this.om);
                } else {
                    new FITSImageDialog(this.om, new File(l.getPath()));
                }
            } else {
                JLabel b = (JLabel)e.getSource();
                Component[] comps = super.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    MyImageLabel l = null;
                    if (!(comps[i] instanceof MyImageLabel) || !(l = (MyImageLabel)comps[i]).getDeleteButton().equals(b)) continue;
                    super.remove(l);
                    super.remove(b);
                    super.repaint();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }
}

