/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.SurfaceBrightness;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.util.FloatUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SurfaceBrightnessContainer
extends Container {
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private static final String BUNDLE_UNIT_PREFIX = "SurfaceBrightness.unit.";
    private static final String CALCULATION_INDICATOR = "~";
    private float value = Float.NaN;
    private String unit = "mags-per-squarearcsec";
    private boolean editable = false;
    private boolean calculated = false;
    private HashMap units = new HashMap();
    private JLabel Lunit = new JLabel();
    private JComboBox unitBox = new JComboBox();
    private JTextField valueField = new JTextField();

    public SurfaceBrightnessContainer(SurfaceBrightness sb, boolean editable, String[] sbUnits) {
        this.editable = editable;
        this.setUnits(sbUnits);
        this.setSurfaceBrightness(sb);
        this.createContainer();
    }

    public SurfaceBrightnessContainer(boolean editable, String[] sbUnits) {
        this.editable = editable;
        this.setUnits(sbUnits);
        this.createContainer();
    }

    public SurfaceBrightness getSurfaceBrightness() throws NumberFormatException {
        if (this.valueField.getText() != null && !"".equals(this.valueField.getText())) {
            try {
                String valueText = this.valueField.getText();
                if (this.isCalculatedValue()) {
                    valueText = valueText.substring(1);
                }
                this.value = FloatUtil.parseFloat((String)valueText);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Given surface brightness " + this.valueField.getText() + " cannot be parsed.");
            }
            if (this.editable) {
                String unitLabel = (String)this.unitBox.getSelectedItem();
                this.unit = this.getUnitFromLabel(unitLabel);
            }
            return new SurfaceBrightness(this.value, this.unit);
        }
        return null;
    }

    public void setSurfaceBrightness(SurfaceBrightness sb) {
        if (sb != null) {
            this.unit = sb.getUnit();
            this.value = sb.getValue();
            this.valueField.setText(this.getValue());
            this.Lunit.setText(this.getUnitLabel(this.unit));
            this.unitBox.setSelectedItem(this.getUnitLabel(this.unit));
        } else {
            this.value = Float.NaN;
        }
    }

    public void setSurfaceBrightness(SurfaceBrightness sb, boolean calculatedValue) {
        this.setSurfaceBrightness(sb);
        if (calculatedValue) {
            this.valueField.setText(CALCULATION_INDICATOR + this.getValue());
            this.valueField.setToolTipText(this.bundle.getString("info.fst_BSB.calculated"));
        }
    }

    public boolean isCalculatedValue() {
        return this.valueField.getText() != null && this.valueField.getText().startsWith(CALCULATION_INDICATOR);
    }

    public void setToolTipText(String text) {
        this.valueField.setToolTipText(text);
        if (!this.editable) {
            this.Lunit.setToolTipText(text);
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.valueField.setEditable(this.editable);
    }

    private void setUnits(String[] units) {
        int i;
        int[] checkedOK = new int[units.length];
        Arrays.fill(checkedOK, -1);
        int x = 0;
        for (i = 0; i < units.length; ++i) {
            if (!SurfaceBrightness.isValidUnit((String)units[i])) continue;
            checkedOK[x++] = i;
        }
        x = 0;
        for (i = 0; i < checkedOK.length; ++i) {
            if (checkedOK[i] == -1 || this.units.containsKey(units[checkedOK[i]])) continue;
            this.units.put(units[checkedOK[i]], this.getUnitLabel(units[checkedOK[i]]));
            this.unitBox.addItem(this.getUnitLabel(units[checkedOK[i]]));
            this.unitBox.setSelectedItem(this.getUnitLabel(units[checkedOK[i]]));
        }
    }

    public void createContainer() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 80, 100);
        constraints.fill = 2;
        this.valueField.setEditable(this.editable);
        gridbag.setConstraints(this.valueField, constraints);
        super.add(this.valueField);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 20, 100);
        constraints.fill = 2;
        if (this.editable) {
            gridbag.setConstraints(this.unitBox, constraints);
            super.add(this.unitBox);
        } else {
            this.Lunit = new JLabel(this.getUnitLabel(this.unit));
            gridbag.setConstraints(this.Lunit, constraints);
            super.add(this.Lunit);
        }
    }

    private String getValue() {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        return df.format(this.value);
    }

    private String getUnitLabel(String unit) {
        return this.bundle.getString(BUNDLE_UNIT_PREFIX + unit);
    }

    private String getUnitFromLabel(String label) {
        if (!this.units.containsValue(label)) {
            return null;
        }
        Iterator iterator = this.units.keySet().iterator();
        String currentKey = null;
        while (iterator.hasNext()) {
            currentKey = (String)iterator.next();
            if (!this.units.get(currentKey).equals(label)) continue;
            return currentKey;
        }
        return null;
    }
}

