/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.dialog.ExtensionTableModel;
import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ExtensionInfoDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = 3369603577422579950L;
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private JButton close = new JButton(this.bundle.getString("extensionInfo.button.close"));
    private JTable infoTable = null;
    private ObservationManager om = null;

    public ExtensionInfoDialog(ObservationManager om) {
        super(om);
        this.om = om;
        super.setTitle(this.bundle.getString("extensionInfo.title"));
        super.setSize(3369603577422579950L, 390, 180);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton && source.equals(this.close)) {
            this.dispose();
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 5, 1, 99);
        constraints.anchor = 17;
        constraints.fill = 1;
        this.infoTable = new JTable(new ExtensionTableModel(this.om.getExtensionLoader().getExtensions()));
        this.infoTable.setRowSelectionAllowed(false);
        TableColumn col0 = this.infoTable.getColumnModel().getColumn(0);
        TableColumn col1 = this.infoTable.getColumnModel().getColumn(1);
        col0.setPreferredWidth((int)((double)col0.getWidth() + (double)col1.getWidth() / 1.5));
        JScrollPane scrollPane = new JScrollPane(this.infoTable);
        gridbag.setConstraints(scrollPane, constraints);
        super.getContentPane().add(scrollPane);
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 1, 1, 1, 1);
        constraints.fill = 2;
        this.close.addActionListener(this);
        gridbag.setConstraints(this.close, constraints);
        super.getContentPane().add(this.close);
    }
}

