/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.navigation.ObservationManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public class ImageDialog
extends JDialog
implements ActionListener,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = -3798904199589986801L;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private Image origImage = null;
    private Image image = null;
    private JLabel imageLabel = null;

    public ImageDialog(Image image, ObservationManager om) {
        super((Frame)om, true);
        this.om = om;
        this.image = image;
        this.origImage = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 1);
        while (!tracker.checkID(1, true)) {
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException ie) {}
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int width = image.getWidth(this) + 40;
        int height = image.getHeight(this) + 50;
        if ((double)width > dim.getWidth()) {
            width = (int)dim.getWidth();
        }
        if ((double)height > dim.getHeight() - 20.0) {
            height = (int)dim.getHeight() - 20;
        }
        super.setSize(width, height);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.addKeyListener(this);
        this.initDialog();
        super.setTitle(this.bundle.getString("dialog.image.title"));
        this.setVisible(true);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '+') {
            this.zoomIn();
        } else if (e.getKeyChar() == '-') {
            this.zoomOut();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void zoomIn() {
        this.image = this.origImage.getScaledInstance(this.image.getWidth(this) << 1, this.image.getHeight(this) << 1, 1);
        ImageIcon icon = new ImageIcon(this.image);
        this.imageLabel.setIcon(icon);
        this.imageLabel.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
        super.update(super.getGraphics());
    }

    private void zoomOut() {
        this.image = this.origImage.getScaledInstance(this.image.getWidth(this) >> 1, this.image.getHeight(this) >> 1, 1);
        ImageIcon icon = new ImageIcon(this.image);
        this.imageLabel.setIcon(icon);
        this.imageLabel.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
        super.update(super.getGraphics());
    }

    private void initDialog() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (dim.width - 40 < this.origImage.getWidth(this) || dim.height - 50 < this.origImage.getHeight(this)) {
            int w = this.origImage.getWidth(this);
            int h = this.origImage.getHeight(this);
            while ((w >>= 1) > dim.width || (h >>= 1) > dim.height) {
            }
            this.image = this.origImage.getScaledInstance(w, h, 1);
        } else {
            this.image = this.origImage;
        }
        ImageIcon icon = new ImageIcon(this.image);
        this.imageLabel = new JLabel(icon);
        this.imageLabel.addMouseWheelListener(this);
        JScrollPane scroll = new JScrollPane(this.imageLabel);
        this.imageLabel.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
        this.getContentPane().add(scroll);
        JMenuBar menuBar = new JMenuBar();
        JMenu windowMenu = new JMenu(this.bundle.getString("dialog.image.menu.window"));
        windowMenu.setMnemonic('w');
        menuBar.add(windowMenu);
        JMenuItem close = new JMenuItem(this.bundle.getString("dialog.image.menu.window.close"));
        close.setMnemonic('c');
        close.setActionCommand("c");
        close.addActionListener(this);
        windowMenu.add(close);
        JMenu zoomMenu = new JMenu(this.bundle.getString("dialog.image.menu.zoom"));
        windowMenu.setMnemonic('z');
        menuBar.add(zoomMenu);
        JMenuItem zoomIn = new JMenuItem(this.bundle.getString("dialog.image.menu.zoom.in") + " (+)");
        zoomIn.setMnemonic('i');
        zoomIn.setActionCommand("+");
        zoomIn.addActionListener(this);
        zoomMenu.add(zoomIn);
        JMenuItem zoomOut = new JMenuItem(this.bundle.getString("dialog.image.menu.zoom.out") + " (-)");
        zoomOut.setMnemonic('o');
        zoomOut.setActionCommand("-");
        zoomOut.addActionListener(this);
        zoomMenu.add(zoomOut);
        this.setJMenuBar(menuBar);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            if ("-".equals(e.getActionCommand())) {
                this.zoomOut();
            } else if ("+".equals(e.getActionCommand())) {
                this.zoomIn();
            } else if ("c".equals(e.getActionCommand())) {
                this.dispose();
            }
        }
    }
}

