/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation.tableModel;

import de.lehmannet.om.IImager;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;

public class ImagerTableModel
extends AbstractSchemaTableModel {
    private static final String MODEL_ID = "Imager";

    public ImagerTableModel(IImager[] imagers) {
        this.elements = imagers;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getID() {
        return MODEL_ID;
    }

    public int getRowCount() {
        if (this.elements == null) {
            return 5;
        }
        return this.elements.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = "";
        if (this.elements == null) {
            return value;
        }
        IImager imager = (IImager)this.elements[rowIndex];
        switch (columnIndex) {
            case 0: {
                value = imager.getVendor();
                break;
            }
            case 1: {
                value = imager.getModel();
                break;
            }
            case 2: {
                value = imager.getRemarks() != null && imager.getRemarks().length() > 15 ? imager.getRemarks().substring(0, 15) : imager.getRemarks();
            }
        }
        return value;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.imager.vendor");
                break;
            }
            case 1: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.imager.model");
                break;
            }
            case 2: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.imager.remarks");
            }
        }
        return name;
    }
}

