/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation.tableModel;

import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class TargetTableModel
extends AbstractSchemaTableModel {
    private static final String MODEL_ID = "Target";
    private ObservationManager om = null;

    public TargetTableModel(ITarget[] target, ObservationManager om) {
        this.om = om;
        this.elements = target;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getID() {
        return MODEL_ID;
    }

    public int getRowCount() {
        if (this.elements == null || this.elements.length == 0) {
            return 3;
        }
        return this.elements.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = "";
        if (this.elements == null || this.elements.length == 0) {
            return value;
        }
        if (rowIndex >= this.elements.length) {
            return value;
        }
        ITarget target = (ITarget)this.elements[rowIndex];
        switch (columnIndex) {
            case 0: {
                value = target.getDisplayName();
                break;
            }
            case 1: {
                String[] alias = target.getAliasNames();
                if (alias == null) break;
                for (int x = 0; x < alias.length; ++x) {
                    value = value + alias[x];
                    if (x >= alias.length - 1) continue;
                    value = value + "; ";
                }
                break;
            }
            case 2: {
                if (target.getPosition() == null) break;
                value = "" + target.getPosition().getRa();
                break;
            }
            case 3: {
                if (target.getPosition() == null) break;
                value = "" + target.getPosition().getDec();
                break;
            }
            case 4: {
                value = this.om.getExtensionLoader().getSchemaUILoader().getDisplayNameForType(target.getXSIType());
                break;
            }
            case 5: {
                if (target.getConstellation() == null) break;
                boolean i18N = Boolean.valueOf(this.om.getConfiguration().getConfig("om.constellation.useI18N", "true"));
                if (i18N) {
                    value = target.getConstellation().getDisplayName();
                    break;
                }
                value = target.getConstellation().getName();
                break;
            }
            case 6: {
                value = target.getDatasource() != null ? target.getDatasource() : target.getObserver().getDisplayName();
            }
        }
        return value;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.name");
                break;
            }
            case 1: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.aliasnames");
                break;
            }
            case 2: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.ra");
                break;
            }
            case 3: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.dec");
                break;
            }
            case 4: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.type");
                break;
            }
            case 5: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.constellation");
                break;
            }
            case 6: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.target.source");
            }
        }
        return name;
    }

    public void addTarget(ITarget target) {
        ArrayList<ISchemaElement> list = new ArrayList<ISchemaElement>(Arrays.asList(this.elements));
        list.add((ISchemaElement)target);
        this.elements = list.toArray(new ITarget[0]);
    }

    public void deleteTarget(ITarget target) {
        ArrayList<ISchemaElement> list = new ArrayList<ISchemaElement>(Arrays.asList(this.elements));
        list.remove(target);
        this.elements = list.toArray(new ITarget[0]);
    }

    public void setTargets(ITarget[] targets) {
        this.elements = targets;
    }

    public ITarget[] getAllTargets() {
        return (ITarget[])this.elements;
    }
}

