/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.project;

import de.lehmannet.om.GenericTarget;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.CatalogLoader;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.panel.AbstractSearchPanel;
import de.lehmannet.om.ui.project.ProjectCatalog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

class ProjectLoaderRunnable
implements Runnable {
    private List projectList = null;
    private File projectFile = null;
    private ObservationManager om = null;
    private List userTargets = null;
    private boolean debug = false;

    public ProjectLoaderRunnable(ObservationManager om, List projectList, List userTargets, File projectFile, boolean debug) {
        this.om = om;
        this.projectList = projectList;
        this.projectFile = projectFile;
        this.userTargets = userTargets;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ProjectCatalog pc;
        if (this.debug) {
            System.out.println("Project loading start: " + this.projectFile.getName() + " " + System.currentTimeMillis());
        }
        if ((pc = this.loadProjectCatalog(this.projectFile)) != null) {
            List list = this.projectList;
            synchronized (list) {
                this.projectList.add(pc);
            }
        }
        if (this.debug) {
            System.out.println("Project loading done: " + this.projectFile.getName() + " " + System.currentTimeMillis());
        }
    }

    private ITarget searchForTarget(String line) {
        String targetName;
        String USER_KEY = "USER";
        String catalogName = null;
        if (line.indexOf(",") != -1) {
            catalogName = line.substring(0, line.indexOf(","));
        }
        if ((targetName = line.substring(line.indexOf(",") + 1)) == null || "".equals(targetName.trim())) {
            return null;
        }
        if (catalogName != null && "USER".equals(catalogName.toUpperCase())) {
            String ut_name = null;
            String t_name = this.formatName(targetName);
            if (!this.userTargets.isEmpty()) {
                ListIterator iterator = this.userTargets.listIterator();
                ITarget current = null;
                if (iterator.hasNext()) {
                    current = (ITarget)iterator.next();
                    ut_name = this.formatName(current.getName());
                    if (ut_name.equals(t_name)) {
                        return current;
                    }
                    if (current.getAliasNames() != null && current.getAliasNames().length > 0) {
                        String[] aNames = current.getAliasNames();
                        for (int j = 0; j < aNames.length; ++j) {
                            ut_name = this.formatName(aNames[j]);
                            if (!ut_name.equals(t_name)) continue;
                            return current;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        CatalogLoader catalogLoader = this.om.getExtensionLoader().getCatalogLoader();
        ITarget target = null;
        if (catalogName != null) {
            target = catalogLoader.getTarget(catalogName, this.formatName(targetName));
        }
        if (target != null) {
            return target;
        }
        String[] catalogNames = catalogLoader.getCatalogNames();
        for (int i = 0; i < catalogNames.length; ++i) {
            AbstractSearchPanel searchPanel = catalogLoader.getCatalog(catalogNames[i]).getSearchPanel();
            if (searchPanel != null) {
                searchPanel.search(targetName);
                target = searchPanel.getSearchResult();
            }
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private String formatName(String name) {
        name = name.trim();
        name = name.replaceAll(" ", "");
        name = name.toUpperCase();
        return name;
    }

    public ProjectCatalog loadProjectCatalog(File projectFile) {
        String PROJECT_NAME_KEY = "ProjectName";
        if (!projectFile.exists()) {
            return null;
        }
        ArrayList<Object> targets = new ArrayList<Object>();
        ITarget target = null;
        String name = null;
        try {
            FileInputStream fis = new FileInputStream(projectFile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("ProjectName")) {
                    name = line.substring(line.indexOf("=") + 1);
                    continue;
                }
                target = this.searchForTarget(line);
                if (target == null) {
                    String projectName = name == null ? projectFile.getName() : name;
                    String targetName = line.substring(line.indexOf(",") + 1);
                    targets.add(new GenericTarget(targetName, projectName));
                    continue;
                }
                targets.add(target);
            }
        }
        catch (IOException ioe) {
            System.err.println("Cannot load project file: " + projectFile + "\n" + ioe);
        }
        if (targets.isEmpty()) {
            return null;
        }
        if (name == null) {
            name = projectFile.getName();
            name = name.substring(0, name.indexOf("."));
        }
        ProjectCatalog pc = new ProjectCatalog(name, targets.toArray(new ITarget[0]));
        return pc;
    }
}

