/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.project.ProjectCatalog;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class StatisticsQueryDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = -3368366919141412617L;
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private ICatalog[] catalogs = null;
    private JButton cancel = new JButton(this.bundle.getString("dialog.button.cancel"));
    private JButton ok = new JButton(this.bundle.getString("dialog.button.ok"));
    private JCheckBox[] catalogCheckBoxes = null;
    private ArrayList result = null;

    public StatisticsQueryDialog(ObservationManager om) {
        super(om);
        super.setTitle(this.bundle.getString("dialog.statisticsQuery.title"));
        this.om = om;
        String[] catalogNames = om.getExtensionLoader().getCatalogLoader().getListableCatalogNames();
        ProjectCatalog[] projectCatalogs = this.om.getProjects();
        int catalogNumber = catalogNames.length;
        if (projectCatalogs != null) {
            catalogNumber += projectCatalogs.length;
        }
        this.catalogs = new ICatalog[catalogNumber];
        this.catalogCheckBoxes = new JCheckBox[catalogNumber];
        this.result = new ArrayList(catalogNumber);
        for (int i = 0; i < catalogNames.length; ++i) {
            this.catalogs[i] = om.getExtensionLoader().getCatalogLoader().getCatalog(catalogNames[i]);
        }
        int x = 0;
        if (projectCatalogs != null) {
            for (int i = catalogNames.length; i < catalogNumber; ++i) {
                this.catalogs[i] = projectCatalogs[x++];
            }
        }
        super.setSize(-3368366919141412617L, 540, 170);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initDialog();
        super.pack();
        super.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.cancel)) {
                this.dispose();
            } else {
                for (int i = 0; i < this.catalogCheckBoxes.length; ++i) {
                    if (!this.catalogCheckBoxes[i].isSelected()) continue;
                    this.result.add(this.catalogs[i]);
                }
                this.dispose();
            }
        }
    }

    public List getSelectedCatalogs() {
        return this.result;
    }

    private void initDialog() {
        int i;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 4, 1, 100, 1);
        constraints.fill = 10;
        JLabel headerLabel = new JLabel(this.bundle.getString("dialog.statisticsQuery.header"));
        gridbag.setConstraints(headerLabel, constraints);
        super.getContentPane().add(headerLabel);
        constraints.fill = 2;
        for (i = 0; i < this.catalogCheckBoxes.length; ++i) {
            ConstraintsBuilder.buildConstraints(constraints, 1, i + 1, 3, 1, 100, 1);
            this.catalogCheckBoxes[i] = new JCheckBox(this.catalogs[i].getName(), true);
            this.catalogCheckBoxes[i].setFont(new Font("Arial", 3, 12));
            gridbag.setConstraints(this.catalogCheckBoxes[i], constraints);
            super.getContentPane().add(this.catalogCheckBoxes[i]);
        }
        ConstraintsBuilder.buildConstraints(constraints, 0, ++i, 4, 1, 100, 1);
        constraints.fill = 10;
        JLabel note = new JLabel(this.bundle.getString("dialog.statisticsQuery.note"));
        note.setFont(new Font("Arial", 2, 10));
        gridbag.setConstraints(note, constraints);
        super.getContentPane().add(note);
        ConstraintsBuilder.buildConstraints(constraints, 0, ++i, 2, 1, 50, 1);
        constraints.fill = 2;
        gridbag.setConstraints(this.ok, constraints);
        this.ok.addActionListener(this);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 2, i, 2, 1, 50, 1);
        gridbag.setConstraints(this.cancel, constraints);
        this.cancel.addActionListener(this);
        super.getContentPane().add(this.cancel);
    }
}

