/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IFilter;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Filter
extends SchemaElement
implements IFilter {
    private String model = new String();
    private String type = new String();
    private String color = null;
    private String wratten = null;
    private String schott = null;
    private String vendor = null;
    private boolean available = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Filter(Node filter) throws SchemaException, IllegalArgumentException {
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter node cannot be NULL. ");
        }
        Element filterElement = (Element)filter;
        NodeList children = null;
        Element child = null;
        String ID = filterElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Filter must have a ID. ");
        }
        super.setID(ID);
        children = filterElement.getElementsByTagName("model");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Filter must have exact one model name. ");
        }
        child = (Element)children.item(0);
        String model = "";
        if (child == null) {
            throw new SchemaException("Filter must have a model name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Filter cannot have an empty model name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                model = model + textElements.item(te).getNodeValue();
            }
            this.setModel(model);
        }
        children = filterElement.getElementsByTagName("type");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Filter must have exact one type. ");
        }
        child = (Element)children.item(0);
        String type = "";
        if (child == null) {
            throw new SchemaException("Filter must have a type. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Filter cannot have an empty type. ");
        NodeList textElements2 = child.getChildNodes();
        if (textElements2 != null && textElements2.getLength() > 0) {
            for (int te = 0; te < textElements2.getLength(); ++te) {
                type = type + textElements2.item(te).getNodeValue();
            }
            this.setType(type);
        }
        NodeList list = filterElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() != 8 || !"Element no longer available".equals(c.getNodeValue())) continue;
            this.available = false;
            break;
        }
        child = null;
        children = filterElement.getElementsByTagName("color");
        String color = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving color from filter. ");
                NodeList textElements3 = child.getChildNodes();
                if (textElements3 != null && textElements3.getLength() > 0) {
                    for (int te = 0; te < textElements3.getLength(); ++te) {
                        color = color + textElements3.item(te).getNodeValue();
                    }
                    this.setColor(color);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Filter can have only one color. ");
            }
        }
        child = null;
        children = filterElement.getElementsByTagName("wratten");
        String wratten = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving wratten value from filter. ");
                NodeList textElements4 = child.getChildNodes();
                if (textElements4 != null && textElements4.getLength() > 0) {
                    for (int te = 0; te < textElements4.getLength(); ++te) {
                        wratten = wratten + textElements4.item(te).getNodeValue();
                    }
                    this.setWratten(wratten);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Filter can have only one wratten value. ");
            }
        }
        child = null;
        children = filterElement.getElementsByTagName("schott");
        String schott = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving schott value from filter. ");
                NodeList textElements5 = child.getChildNodes();
                if (textElements5 != null && textElements5.getLength() > 0) {
                    for (int te = 0; te < textElements5.getLength(); ++te) {
                        schott = schott + textElements5.item(te).getNodeValue();
                    }
                    this.setSchott(schott);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Filter can have only one schott value. ");
            }
        }
        child = null;
        children = filterElement.getElementsByTagName("vendor");
        String vendor = "";
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving vendor name from filter. ");
            NodeList textElements6 = child.getChildNodes();
            if (textElements6 == null || textElements6.getLength() <= 0) return;
            for (int te = 0; te < textElements6.getLength(); ++te) {
                vendor = vendor + textElements6.item(te).getNodeValue();
            }
            this.setVendor(vendor);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Filter can have only one vendor name. ");
        }
    }

    public Filter(String model, String type) throws IllegalArgumentException {
        this.setModel(model);
        this.setType(type);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Filter Model: ");
        buffer.append(this.getModel() + "\n");
        buffer.append("Type: ");
        buffer.append(this.getType() + "\n");
        if (this.color != null) {
            buffer.append("Color: ");
            buffer.append(this.getColor() + "\n");
        }
        if (this.wratten != null) {
            buffer.append("Wratten: ");
            buffer.append(this.getWratten() + "\n");
        }
        if (this.schott != null) {
            buffer.append("Schott: ");
            buffer.append(this.getSchott() + "\n");
        }
        return buffer.toString();
    }

    public String getDisplayName() {
        String dn = this.getModel();
        return dn;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailability(boolean available) {
        this.available = available;
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("filter");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Filter = ownerDoc.createElement("filter");
        e_Filter.setAttribute("id", super.getID());
        element.appendChild(e_Filter);
        if (!this.isAvailable()) {
            Comment comment = ownerDoc.createComment("Element no longer available");
            e_Filter.appendChild(comment);
        }
        Element e_Model = ownerDoc.createElement("model");
        CDATASection n_ModelText = ownerDoc.createCDATASection(this.model);
        e_Model.appendChild(n_ModelText);
        e_Filter.appendChild(e_Model);
        if (this.vendor != null) {
            Element e_Vendor = ownerDoc.createElement("vendor");
            CDATASection n_VendorText = ownerDoc.createCDATASection(this.vendor);
            e_Vendor.appendChild(n_VendorText);
            e_Filter.appendChild(e_Vendor);
        }
        Element e_Type = ownerDoc.createElement("type");
        CDATASection n_TypeText = ownerDoc.createCDATASection(this.type);
        e_Type.appendChild(n_TypeText);
        e_Filter.appendChild(e_Type);
        if (this.color != null) {
            Element e_Color = ownerDoc.createElement("color");
            CDATASection n_ColorText = ownerDoc.createCDATASection(this.color);
            e_Color.appendChild(n_ColorText);
            e_Filter.appendChild(e_Color);
        }
        if (this.wratten != null) {
            Element e_Wratten = ownerDoc.createElement("wratten");
            CDATASection n_WrattenText = ownerDoc.createCDATASection(this.wratten);
            e_Wratten.appendChild(n_WrattenText);
            e_Filter.appendChild(e_Wratten);
        }
        if (this.schott != null) {
            Element e_Schott = ownerDoc.createElement("schott");
            CDATASection n_SchottText = ownerDoc.createCDATASection(this.schott);
            e_Schott.appendChild(n_SchottText);
            e_Filter.appendChild(e_Schott);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("filter");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Filters = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("filters");
            if (nodeList.getLength() == 0) {
                e_Filters = ownerDoc.createElement("filters");
                ownerDoc.getDocumentElement().appendChild(e_Filters);
            } else {
                e_Filters = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Filters);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) throws IllegalArgumentException {
        if (color == null || "".equals(color.trim())) {
            return;
        }
        if (!this.getType().equals("color")) {
            throw new IllegalArgumentException("Filter type is not color.\nsetColor(...) can only be called on color filters");
        }
        if (!("blue".equals(color) || "deep blue".equals(color) || "deep red".equals(color) || "deep yellow".equals(color) || "green".equals(color) || "light green".equals(color) || "light red".equals(color) || "light yellow".equals(color) || "medium blue".equals(color) || "pale blue".equals(color) || "orange".equals(color) || "red".equals(color) || "violet".equals(color) || "yellow".equals(color) || "yellow-green".equals(color))) {
            throw new IllegalArgumentException("Given color is unknown.\n");
        }
        this.color = color;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        if (model == null || "".equals(model.trim())) {
            throw new IllegalArgumentException("Filter model cannot be null or empty string.\n");
        }
        this.model = model;
    }

    public String getSchott() {
        return this.schott;
    }

    public void setSchott(String schott) {
        if (schott != null && "".equals(schott.trim())) {
            this.schott = null;
            return;
        }
        this.schott = schott;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null || "".equals(type.trim())) {
            throw new IllegalArgumentException("Type cannot be null or empty string.\n");
        }
        if ("broad band".equals(type) || "color".equals(type) || "corrective".equals(type) || "H-alpha".equals(type) || "H-beta".equals(type) || "narrow band".equals(type) || "solar".equals(type) || "neutral".equals(type) || "O-III".equals(type) || "other".equals(type)) {
            if ("color".equals(this.type) && !"color".equals(type)) {
                this.color = null;
            }
        } else {
            throw new IllegalArgumentException("Given filter type is unknown.\n");
        }
        this.type = type;
    }

    public String getWratten() {
        return this.wratten;
    }

    public void setWratten(String wratten) {
        if (wratten != null && "".equals(wratten.trim())) {
            this.wratten = null;
            return;
        }
        this.wratten = wratten;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }
}

