/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.util.SchemaException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RootElement {
    public static final String XML_NS_KEY = "xmlns:oal";
    public static final String XML_NS = "http://groups.google.com/group/openastronomylog";
    public static final String XML_SI_KEY = "xmlns:xsi";
    public static final String XML_SI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_LOCATION_KEY = "xsi:schemaLocation";
    public static final String XML_SCHEMA_LOCATION = "http://groups.google.com/group/openastronomylog oal21.xsd";
    public static final String XML_SCHEMA_VERSION_KEY = "version";
    public static final String XML_SCHEMA_VERSION = "2.1";
    public static final String XML_OBSERVATION_CONTAINER = "oal:observations";
    public static final String XML_SESSION_CONTAINER = "sessions";
    public static final String XML_TARGET_CONTAINER = "targets";
    public static final String XML_OBSERVER_CONTAINER = "observers";
    public static final String XML_SITE_CONTAINER = "sites";
    public static final String XML_SCOPE_CONTAINER = "scopes";
    public static final String XML_EYEPIECE_CONTAINER = "eyepieces";
    public static final String XML_IMAGER_CONTAINER = "imagers";
    public static final String XML_FILTER_CONTAINER = "filters";
    public static final String XML_LENS_CONTAINER = "lenses";
    private ArrayList observationList = new ArrayList();
    private ArrayList observerList = new ArrayList();
    private ArrayList siteList = new ArrayList();
    private ArrayList scopeList = new ArrayList();
    private ArrayList eyepieceList = new ArrayList();
    private ArrayList imagerList = new ArrayList();
    private ArrayList sessionList = new ArrayList();
    private ArrayList targetList = new ArrayList();
    private ArrayList filterList = new ArrayList();
    private ArrayList lensList = new ArrayList();

    public Collection getObservations() {
        return this.observationList;
    }

    public Collection getEyepieceList() {
        return this.eyepieceList;
    }

    public Collection getImagerList() {
        return this.imagerList;
    }

    public Collection getObserverList() {
        return this.observerList;
    }

    public Collection getScopeList() {
        return this.scopeList;
    }

    public Collection getSessionList() {
        return this.sessionList;
    }

    public Collection getSiteList() {
        return this.siteList;
    }

    public Collection getTargetList() {
        return this.targetList;
    }

    public Collection getFilterList() {
        return this.filterList;
    }

    public Collection getLensList() {
        return this.lensList;
    }

    public void addObservation(IObservation observation) throws SchemaException {
        if (observation == null) {
            throw new SchemaException("Observation cannot be null. ");
        }
        this.observationList.add(observation);
    }

    public void addObservations(Collection observations) throws SchemaException {
        if (observations == null) {
            throw new SchemaException("Observations cannot be null. ");
        }
        this.observationList.addAll(observations);
    }

    public void addEyepiece(IEyepiece eyepiece) throws SchemaException {
        if (eyepiece == null) {
            throw new SchemaException("Eyepiece cannot be null. ");
        }
        this.eyepieceList.add(eyepiece);
    }

    public void addEyepieces(Collection eyepieces) throws SchemaException {
        if (eyepieces == null) {
            throw new SchemaException("Eyepieces cannot be null. ");
        }
        this.eyepieceList.addAll(eyepieces);
    }

    public void addImager(IImager imager) throws SchemaException {
        if (imager == null) {
            throw new SchemaException("Imager cannot be null. ");
        }
        this.imagerList.add(imager);
    }

    public void addImagers(Collection imagers) throws SchemaException {
        if (imagers == null) {
            throw new SchemaException("Imagers cannot be null. ");
        }
        this.imagerList.addAll(imagers);
    }

    public void addSite(ISite site) throws SchemaException {
        if (site == null) {
            throw new SchemaException("Site cannot be null. ");
        }
        this.siteList.add(site);
    }

    public void addSites(Collection sites) throws SchemaException {
        if (sites == null) {
            throw new SchemaException("Sites cannot be null. ");
        }
        this.siteList.addAll(sites);
    }

    public void addScope(IScope scope) throws SchemaException {
        if (scope == null) {
            throw new SchemaException("Scope cannot be null. ");
        }
        this.scopeList.add(scope);
    }

    public void addScopes(Collection scopes) throws SchemaException {
        if (scopes == null) {
            throw new SchemaException("Scopes cannot be null. ");
        }
        this.scopeList.addAll(scopes);
    }

    public void addSession(ISession session) throws SchemaException {
        if (session == null) {
            throw new SchemaException("Session cannot be null. ");
        }
        this.sessionList.add(session);
    }

    public void addSessions(Collection sessions) throws SchemaException {
        if (sessions == null) {
            throw new SchemaException("Sessions cannot be null. ");
        }
        this.sessionList.addAll(sessions);
    }

    public void addObserver(IObserver observer) throws SchemaException {
        if (observer == null) {
            throw new SchemaException("Observer cannot be null. ");
        }
        this.observerList.add(observer);
    }

    public void addObservers(Collection observers) throws SchemaException {
        if (observers == null) {
            throw new SchemaException("Observers cannot be null. ");
        }
        this.observerList.addAll(observers);
    }

    public void addTarget(ITarget target) throws SchemaException {
        if (target == null) {
            throw new SchemaException("Target cannot be null. ");
        }
        this.targetList.add(target);
    }

    public void addTargets(Collection targets) throws SchemaException {
        if (targets == null) {
            throw new SchemaException("Targets cannot be null. ");
        }
        this.targetList.addAll(targets);
    }

    public void addFilter(IFilter filter) throws SchemaException {
        if (filter == null) {
            throw new SchemaException("Filter cannot be null. ");
        }
        this.filterList.add(filter);
    }

    public void addFilters(Collection filters) throws SchemaException {
        if (filters == null) {
            throw new SchemaException("Filters cannot be null. ");
        }
        this.filterList.addAll(filters);
    }

    public void addLens(ILens lens) throws SchemaException {
        if (lens == null) {
            throw new SchemaException("Lens cannot be null. ");
        }
        this.lensList.add(lens);
    }

    public void addLenses(Collection lenses) throws SchemaException {
        if (lenses == null) {
            throw new SchemaException("Lenses cannot be null. ");
        }
        this.lensList.addAll(lenses);
    }

    public void serializeAsXml(File xmlFile) throws SchemaException {
        if (xmlFile == null) {
            throw new SchemaException("File cannot be null. ");
        }
        Document newSchema = this.getDocument();
        OutputFormat outputFormat = new OutputFormat(newSchema, "ISO-8859-1", true);
        XMLSerializer serializer = new XMLSerializer(outputFormat);
        try {
            FileOutputStream fos = new FileOutputStream(xmlFile);
            serializer.setOutputByteStream((OutputStream)fos);
            serializer.serialize(newSchema);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new SchemaException("File not found: " + xmlFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new SchemaException("Error while serializing. Nested Exception is: ", (Throwable)ioe);
        }
    }

    public Document getDocument() throws SchemaException {
        Document newSchema = null;
        try {
            newSchema = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new SchemaException("Unable to create new XML document. ", (Throwable)pce);
        }
        Element root = newSchema.createElement(XML_OBSERVATION_CONTAINER);
        root.setAttribute(XML_NS_KEY, XML_NS);
        root.setAttribute(XML_SI_KEY, XML_SI);
        root.setAttribute(XML_SCHEMA_LOCATION_KEY, XML_SCHEMA_LOCATION);
        root.setAttribute(XML_SCHEMA_VERSION_KEY, XML_SCHEMA_VERSION);
        newSchema.appendChild(root);
        root = this.addObserverToXmlElement(root);
        root = this.addSiteToXmlElement(root);
        root = this.addSessionToXmlElement(root);
        root = this.addTargetToXmlElement(root);
        root = this.addScopeToXmlElement(root);
        root = this.addEyepieceToXmlElement(root);
        root = this.addLensToXmlElement(root);
        root = this.addFilterToXmlElement(root);
        root = this.addImagerToXmlElement(root);
        Iterator iterator = this.observationList.iterator();
        IObservation current = null;
        while (iterator.hasNext()) {
            current = (IObservation)iterator.next();
            current.addToXmlElement(root);
        }
        return newSchema;
    }

    private Element addEyepieceToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Eyepiece = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_EYEPIECE_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Eyepiece = ownerDoc.createElement(XML_EYEPIECE_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Eyepiece);
        } else {
            e_Eyepiece = (Element)nodeList.item(0);
        }
        Iterator iterator = this.eyepieceList.iterator();
        IEyepiece current = null;
        while (iterator.hasNext()) {
            current = (IEyepiece)iterator.next();
            current.addToXmlElement(e_Eyepiece);
        }
        return root;
    }

    private Element addImagerToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Imager = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_IMAGER_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Imager = ownerDoc.createElement(XML_IMAGER_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Imager);
        } else {
            e_Imager = (Element)nodeList.item(0);
        }
        Iterator iterator = this.imagerList.iterator();
        IImager current = null;
        while (iterator.hasNext()) {
            current = (IImager)iterator.next();
            current.addToXmlElement(e_Imager);
        }
        return root;
    }

    private Element addSiteToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Site = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_SITE_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Site = ownerDoc.createElement(XML_SITE_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Site);
        } else {
            e_Site = (Element)nodeList.item(0);
        }
        Iterator iterator = this.siteList.iterator();
        ISite current = null;
        while (iterator.hasNext()) {
            current = (ISite)iterator.next();
            current.addToXmlElement(e_Site);
        }
        return root;
    }

    private Element addObserverToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Observer = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_OBSERVER_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Observer = ownerDoc.createElement(XML_OBSERVER_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Observer);
        } else {
            e_Observer = (Element)nodeList.item(0);
        }
        Iterator iterator = this.observerList.iterator();
        IObserver current = null;
        while (iterator.hasNext()) {
            current = (IObserver)iterator.next();
            current.addToXmlElement(e_Observer);
        }
        return root;
    }

    private Element addTargetToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Target = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_TARGET_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Target = ownerDoc.createElement(XML_TARGET_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Target);
        } else {
            e_Target = (Element)nodeList.item(0);
        }
        Iterator iterator = this.targetList.iterator();
        ITarget current = null;
        while (iterator.hasNext()) {
            current = (ITarget)iterator.next();
            current.addToXmlElement(e_Target);
        }
        return root;
    }

    private Element addFilterToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Filter = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_FILTER_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Filter = ownerDoc.createElement(XML_FILTER_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Filter);
        } else {
            e_Filter = (Element)nodeList.item(0);
        }
        Iterator iterator = this.filterList.iterator();
        IFilter current = null;
        while (iterator.hasNext()) {
            current = (IFilter)iterator.next();
            current.addToXmlElement(e_Filter);
        }
        return root;
    }

    private Element addLensToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Lens = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_LENS_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Lens = ownerDoc.createElement(XML_LENS_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Lens);
        } else {
            e_Lens = (Element)nodeList.item(0);
        }
        Iterator iterator = this.lensList.iterator();
        ILens current = null;
        while (iterator.hasNext()) {
            current = (ILens)iterator.next();
            current.addToXmlElement(e_Lens);
        }
        return root;
    }

    private Element addSessionToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Session = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_SESSION_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Session = ownerDoc.createElement(XML_SESSION_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Session);
        } else {
            e_Session = (Element)nodeList.item(0);
        }
        Iterator iterator = this.sessionList.iterator();
        ISession current = null;
        while (iterator.hasNext()) {
            current = (ISession)iterator.next();
            current.addToXmlElement(e_Session);
        }
        return root;
    }

    private Element addScopeToXmlElement(Element root) {
        if (root == null) {
            return null;
        }
        Document ownerDoc = root.getOwnerDocument();
        Element e_Scope = null;
        NodeList nodeList = ownerDoc.getElementsByTagName(XML_SCOPE_CONTAINER);
        if (nodeList.getLength() == 0) {
            e_Scope = ownerDoc.createElement(XML_SCOPE_CONTAINER);
            ownerDoc.getDocumentElement().appendChild(e_Scope);
        } else {
            e_Scope = (Element)nodeList.item(0);
        }
        Iterator iterator = this.scopeList.iterator();
        IScope current = null;
        while (iterator.hasNext()) {
            current = (IScope)iterator.next();
            current.addToXmlElement(e_Scope);
        }
        return root;
    }
}

