/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.Angle;
import de.lehmannet.om.ISite;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Site
extends SchemaElement
implements ISite {
    private String name = null;
    private float elevation = Float.NaN;
    private String iauCode = null;
    private Angle longitude = null;
    private Angle latitude = null;
    private int timezone = Integer.MAX_VALUE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Site(Node site) throws SchemaException, IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("Parameter site node cannot be NULL. ");
        }
        Element siteElement = (Element)site;
        Element child = null;
        NodeList children = null;
        String ID = siteElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Site must have a ID. ");
        }
        super.setID(ID);
        children = siteElement.getElementsByTagName("name");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Site must have exact one name. ");
        }
        child = (Element)children.item(0);
        String name = "";
        if (child == null) {
            throw new SchemaException("Site must have a name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Site cannot have an empty name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                name = name + textElements.item(te).getNodeValue();
            }
            this.setName(name);
        }
        child = null;
        children = siteElement.getElementsByTagName("longitude");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Site must have exact one longitude. ");
        }
        child = (Element)children.item(0);
        Angle longitude = null;
        if (child == null) {
            throw new SchemaException("Site must have a longitude. ");
        }
        String value = child.getFirstChild().getNodeValue();
        String unit = child.getAttribute("unit");
        longitude = new Angle(Double.parseDouble(value), unit);
        this.setLongitude(longitude);
        child = null;
        children = siteElement.getElementsByTagName("latitude");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Site must have exact one latitude. ");
        }
        child = (Element)children.item(0);
        Angle latitude = null;
        if (child == null) {
            throw new SchemaException("Site must have a latitude. ");
        }
        String value2 = child.getFirstChild().getNodeValue();
        String unit2 = child.getAttribute("unit");
        latitude = new Angle(Double.parseDouble(value2), unit2);
        this.setLatitude(latitude);
        child = null;
        children = siteElement.getElementsByTagName("timezone");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Site must have exact one timezone. ");
        }
        child = (Element)children.item(0);
        String timezone = null;
        if (child == null) {
            throw new SchemaException("Site must have a timezone. ");
        }
        timezone = child.getFirstChild().getNodeValue();
        this.setTimezone(Integer.parseInt(timezone));
        child = null;
        children = siteElement.getElementsByTagName("elevation");
        String elevation = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving elevation from site. ");
                elevation = child.getFirstChild().getNodeValue();
                this.setElevation(FloatUtil.parseFloat((String)elevation));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Site can have only one elevation level. ");
            }
        }
        child = null;
        children = siteElement.getElementsByTagName("code");
        String iauCode = null;
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving IAU code from site. ");
            iauCode = child.getFirstChild().getNodeValue();
            this.setIAUCode(iauCode);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Site can have only one IAU code. ");
        }
    }

    public Site(String name, Angle longitude, Angle latitude, int timezone) throws IllegalArgumentException {
        this.setName(name);
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setTimezone(timezone);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Site: Name=");
        buffer.append(this.name);
        if (this.iauCode != null) {
            buffer.append(" IAU Code=");
            buffer.append(this.iauCode);
        }
        buffer.append(" Longitude=");
        buffer.append(this.longitude);
        buffer.append(" Latitude=");
        buffer.append(this.latitude);
        if (!Float.isNaN(this.elevation)) {
            buffer.append(" Elevation=");
            buffer.append(this.elevation);
        }
        buffer.append(" Timezone=");
        buffer.append(this.timezone);
        return buffer.toString();
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("site");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Site = ownerDoc.createElement("site");
        e_Site.setAttribute("id", super.getID());
        element.appendChild(e_Site);
        Element e_Name = ownerDoc.createElement("name");
        CDATASection n_NameText = ownerDoc.createCDATASection(this.name);
        e_Name.appendChild(n_NameText);
        e_Site.appendChild(e_Name);
        Element e_Longitude = ownerDoc.createElement("longitude");
        e_Longitude = this.longitude.setToXmlElement(e_Longitude);
        e_Site.appendChild(e_Longitude);
        Element e_Latitude = ownerDoc.createElement("latitude");
        e_Latitude = this.latitude.setToXmlElement(e_Latitude);
        e_Site.appendChild(e_Latitude);
        if (!Float.isNaN(this.elevation)) {
            Element e_Elevation = ownerDoc.createElement("elevation");
            Text n_ElevationText = ownerDoc.createTextNode(String.valueOf(this.elevation));
            e_Elevation.appendChild(n_ElevationText);
            e_Site.appendChild(e_Elevation);
        }
        Element e_Timezone = ownerDoc.createElement("timezone");
        Text n_TimezoneText = ownerDoc.createTextNode(Integer.toString(this.timezone));
        e_Timezone.appendChild(n_TimezoneText);
        e_Site.appendChild(e_Timezone);
        if (this.iauCode != null) {
            Element e_IAUCode = ownerDoc.createElement("code");
            Text n_IAUCodeText = ownerDoc.createTextNode(this.iauCode);
            e_IAUCode.appendChild(n_IAUCodeText);
            e_Site.appendChild(e_IAUCode);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("site");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Sites = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("sites");
            if (nodeList.getLength() == 0) {
                e_Sites = ownerDoc.createElement("sites");
                ownerDoc.getDocumentElement().appendChild(e_Sites);
            } else {
                e_Sites = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Sites);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.name;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public void setLatitude(Angle latitude) throws IllegalArgumentException {
        if (latitude == null) {
            throw new IllegalArgumentException("Latitude cannot be null. ");
        }
        this.latitude = latitude;
    }

    public void setLongitude(Angle longitude) throws IllegalArgumentException {
        if (longitude == null) {
            throw new IllegalArgumentException("Longitude cannot be null. ");
        }
        this.longitude = longitude;
    }

    public void setName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Site name cannot be null. ");
        }
        this.name = name;
    }

    public void setTimezone(int timezone) throws IllegalArgumentException {
        if (timezone > 720 || timezone < -720) {
            throw new IllegalArgumentException("Timezone cannot be > 720 or < -720. ");
        }
        this.timezone = timezone;
    }

    public void setIAUCode(String IAUCode) {
        if (IAUCode != null && "".equals(IAUCode.trim())) {
            this.iauCode = null;
            return;
        }
        this.iauCode = IAUCode;
    }

    public void setElevation(float elevation) {
        this.elevation = elevation;
    }

    public float getElevation() {
        return this.elevation;
    }

    public String getIAUCode() {
        return this.iauCode;
    }
}

