/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsCard;
import eap.fits.FitsCardException;
import eap.fits.FitsException;
import eap.fits.NoSuchFitsCardException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FitsHeader {
    private List cards = new ArrayList();
    private Map index = new HashMap();
    private boolean isComplete = false;

    public boolean isComplete() {
        return this.isComplete;
    }

    public int blockCount() {
        return (this.cards.size() + 36 - 1) / 36;
    }

    public void add(FitsCard fitsCard) {
        if (this.isComplete) {
            this.cards.add(this.cards.size() - 1, fitsCard);
        } else {
            this.cards.add(fitsCard);
        }
        this.index.put(fitsCard.key(), fitsCard);
        if (fitsCard.key().equals("END")) {
            this.isComplete = true;
        }
    }

    public boolean add(byte[] byArray) {
        boolean bl = false;
        for (int i = 0; i < 36 && !this.isComplete(); ++i) {
            this.add(new FitsCard(byArray, i * 80));
        }
        return this.isComplete();
    }

    public boolean hasCard(String string) {
        return this.index.containsKey(string);
    }

    public FitsCard card(String string) throws NoSuchFitsCardException {
        FitsCard fitsCard = (FitsCard)this.index.get(string);
        if (fitsCard == null) {
            throw new NoSuchFitsCardException("No key " + string + " in " + this);
        }
        return fitsCard;
    }

    public FitsCard card(int n) throws NoSuchFitsCardException {
        try {
            FitsCard fitsCard = (FitsCard)this.cards.get(n);
            return fitsCard;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchFitsCardException("No card " + n + " in " + this);
        }
    }

    public int cardCount() {
        return this.cards.size();
    }

    public int dataSize() throws FitsCardException {
        int n = this.card("NAXIS").intValue();
        int n2 = n == 0 ? 0 : Math.abs(this.card("BITPIX").intValue()) / 8;
        for (int i = 1; i <= n; ++i) {
            n2 *= this.card("NAXIS" + i).intValue();
        }
        try {
            n2 += this.card("PCOUNT").intValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            // empty catch block
        }
        return n2;
    }

    public String getName() {
        try {
            if (this.card(0).key().equals("SIMPLE")) {
                return "PRIMARY";
            }
            return this.card("EXTNAME").stringValue();
        }
        catch (FitsCardException fitsCardException) {
            return "";
        }
    }

    public String getType() throws FitsException {
        try {
            return this.card("XTENSION").stringValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            if (this.hasCard("SIMPLE")) {
                return "IMAGE";
            }
            throw new FitsException("No SIMPLE or XTENSION keyword in " + this);
        }
    }
}

