/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.RealImageConsumer;
import eap.fits.RealImageProducer;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageDigitizer
implements RealImageConsumer,
ImageProducer {
    RealImageProducer source;
    ColorModel color;
    int height;
    int width;
    double min;
    double max;
    Set consumers;
    boolean sending = false;
    int int_NaN_value;
    byte byte_NaN_value;
    double gamma;
    Set listeners;
    int total_pixels;
    int pixels_done;
    double change_amount;
    int change_amount_pixels;

    public ImageDigitizer(RealImageProducer realImageProducer, ColorModel colorModel) {
        this.source = realImageProducer;
        this.color = colorModel;
        this.consumers = new HashSet();
        this.byte_NaN_value = 0;
        this.int_NaN_value = 0;
        this.gamma = 1.0;
        this.listeners = new HashSet();
        this.change_amount = 0.01;
        this.pixels_done = 0;
    }

    public void setImageSource(RealImageProducer realImageProducer) {
        this.abortSend();
        this.source = realImageProducer;
    }

    public void setNaNvalue(int n) {
        this.int_NaN_value = n;
    }

    public void setNaNvalue(byte by) {
        this.byte_NaN_value = by;
    }

    public void setColorModel(ColorModel colorModel) {
        this.color = colorModel;
    }

    public ColorModel getColorModel() {
        return this.color;
    }

    public void setGamma(double d) {
        this.gamma = 1.0 / d;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void setChangeIncrement(double d) {
        this.change_amount = d;
        this.change_amount_pixels = (int)((double)this.total_pixels * d);
    }

    private void checkProgress() {
        if (this.listeners.size() == 0 || this.pixels_done % this.change_amount_pixels != 0) {
            return;
        }
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)iterator.next();
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public double getProgress() {
        return (double)this.pixels_done / (double)this.total_pixels;
    }

    public void abortSend() {
        if (!this.sending) {
            return;
        }
        this.imageComplete(4);
    }

    public void imageComplete(int n) {
        this.source.removeConsumer(this);
        HashSet hashSet = new HashSet(this.consumers);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
            imageConsumer.imageComplete(n);
        }
        this.sending = false;
        this.pixels_done = 0;
        this.fireChangeEvent();
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.total_pixels = n * n2;
        this.change_amount_pixels = (int)((double)this.total_pixels * this.change_amount);
        if (this.change_amount_pixels < 1) {
            this.change_amount_pixels = 1;
        }
        Iterator iterator = this.consumers.iterator();
        while (iterator.hasNext()) {
            ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
            imageConsumer.setDimensions(n, n2);
            imageConsumer.setColorModel(this.color);
        }
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public void setHints(int n) {
        Iterator iterator = this.consumers.iterator();
        while (iterator.hasNext()) {
            ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
            imageConsumer.setHints(n);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray, int n5, int n6) {
        block5: {
            int n7;
            block4: {
                n7 = this.color.getPixelSize();
                if (n7 != 8) break block4;
                byte[] byArray = new byte[n3 * n4];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = this.digitizeToByte(dArray[i + n5]);
                    ++this.pixels_done;
                    this.checkProgress();
                }
                Iterator iterator = this.consumers.iterator();
                while (iterator.hasNext()) {
                    ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
                    imageConsumer.setPixels(n, n2, n3, n4, this.color, byArray, 0, n6);
                }
                break block5;
            }
            if (n7 != 32) break block5;
            int[] nArray = new int[n3 * n4];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.digitizeToInt(dArray[i + n5]);
                ++this.pixels_done;
                this.checkProgress();
            }
            Iterator iterator = this.consumers.iterator();
            while (iterator.hasNext()) {
                ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
                imageConsumer.setPixels(n, n2, n3, n4, this.color, nArray, 0, n6);
            }
        }
    }

    public double scalePixel(double d) {
        double d2 = (d - this.min) / (this.max - this.min);
        if (this.gamma != 1.0) {
            d2 = Math.pow(d2, this.gamma);
        }
        return d2;
    }

    public byte digitizeToByte(double d) {
        if (Double.isNaN(d)) {
            return this.byte_NaN_value;
        }
        double d2 = this.scalePixel(d);
        int n = (int)(d2 * 255.0);
        if (n >= 0) {
            return (byte)n;
        }
        return (byte)(n - 127 + -128);
    }

    public int digitizeToInt(double d) {
        if (Double.isNaN(d)) {
            return this.int_NaN_value;
        }
        double d2 = this.scalePixel(d);
        return (int)(d2 * -1.0 - -2.147483648E9);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.consumers.add(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.remove(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.sending = true;
        this.addConsumer(imageConsumer);
        this.source.startProduction(this);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.sending = true;
        this.addConsumer(imageConsumer);
        this.source.requestTopDownLeftRightResend(this);
    }
}

