/*
 * Decompiled with CFR 0.152.
 */
package eap.fitsbrowser;

import eap.fits.FitsFile;
import eap.fitsbrowser.FITSFileDisplay;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Browser
extends JFrame
implements ActionListener {
    JMenuBar menu_bar;
    JFileChooser file_chooser;
    FITSFileDisplay display;
    FitsFile fits;

    public Browser() {
        this.addWindowListener(new Closer());
        this.menu_bar = new JMenuBar();
        this.setJMenuBar(this.menu_bar);
        JMenu jMenu = new JMenu("File");
        this.menu_bar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open", 84);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save", 84);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit", 84);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.display = new FITSFileDisplay();
        this.getContentPane().add(this.display);
        this.display.setPreferredSize(new Dimension(608, 337));
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open")) {
            try {
                this.openFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("Save")) {
            try {
                this.save();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("Exit")) {
            this.exit();
        }
    }

    private void exit() {
        System.exit(0);
    }

    public void openFile() throws IOException {
        if (this.file_chooser == null) {
            this.file_chooser = new JFileChooser(System.getProperty("user.dir"));
        }
        if (this.file_chooser.showOpenDialog(this) == 0) {
            this.display.load(this.file_chooser.getSelectedFile());
        }
    }

    public void save() throws IOException {
        if (this.file_chooser == null) {
            this.file_chooser = new JFileChooser(System.getProperty("user.dir"));
        }
        if (this.file_chooser.showSaveDialog(this) == 0) {
            this.display.save(this.file_chooser.getSelectedFile());
        }
    }

    public static void main(String[] stringArray) throws IOException {
        Browser browser = new Browser();
        if (stringArray.length > 0) {
            browser.display.load(stringArray[0]);
        } else {
            browser.display.load(FitsFile.createEmpty());
        }
    }

    private class Closer
    extends WindowAdapter {
        private Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Browser.this.exit();
        }
    }
}

