/*
 * Decompiled with CFR 0.152.
 */
package eap.fitsbrowser;

import eap.fits.FitsException;
import eap.fits.FitsImageData;
import eap.fits.ImageDigitizer;
import eap.fits.RealImageProducer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FitsImageViewer
extends JPanel {
    FitsImageData data;
    RealImageProducer view;
    ImageDigitizer digitizer;
    Toolkit toolkit;
    Image image;
    MediaTracker tracker;
    Picture picture;
    GammaAdjuster gamma_adjuster;
    Monitor monitor;

    public FitsImageViewer(FitsImageData fitsImageData) throws FitsException {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.red);
        this.data = fitsImageData;
        this.view = fitsImageData.createView();
        ColorModel colorModel = this.makeColorModel(Color.black, Color.white);
        this.digitizer = new ImageDigitizer(this.view, colorModel);
        this.toolkit = this.getToolkit();
        this.image = this.toolkit.createImage(this.digitizer);
        this.picture = new Picture();
        this.add(this.picture);
    }

    public void allowGammaCorrection() {
        if (this.gamma_adjuster != null) {
            return;
        }
        this.gamma_adjuster = new GammaAdjuster();
        this.add(this.gamma_adjuster);
        this.validate();
    }

    public void showProgress() {
        this.add(new Monitor());
        this.validate();
    }

    private void updateImage() {
        this.tracker.removeImage(this.image);
        this.image = this.toolkit.createImage(this.digitizer);
        this.tracker.addImage(this.image, 0);
        this.picture.repaint();
    }

    public void setImage(FitsImageData fitsImageData) throws FitsException {
        this.data = fitsImageData;
        this.view = fitsImageData.createView();
        this.digitizer.setImageSource(this.view);
        this.updateImage();
    }

    public void setGamma(double d) {
        this.digitizer.setGamma(d);
        this.updateImage();
    }

    public ColorModel makeColorModel(Color color, Color color2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i <= 255; ++i) {
            float f = (float)i / 255.0f;
            float f2 = (fArray2[0] - fArray[0]) * f + fArray[0];
            float f3 = (fArray2[1] - fArray[1]) * f + fArray[1];
            float f4 = (fArray2[2] - fArray[2]) * f + fArray[2];
            Color color3 = Color.getHSBColor(f2, f3, f4);
            int n = color3.getRed();
            byArray[i] = n >= 0 && n <= 127 ? (byte)n : (byte)(n - 256);
            n = color3.getGreen();
            byArray2[i] = n >= 0 && n <= 127 ? (byte)n : (byte)(n - 256);
            n = color3.getBlue();
            byArray3[i] = n >= 0 && n <= 127 ? (byte)n : (byte)(n - 256);
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    private class GammaAdjuster
    extends JPanel
    implements ChangeListener {
        JSlider slider;
        JLabel label;
        DecimalFormat format;
        int slider_granularity;

        public GammaAdjuster() {
            this.setLayout(new BorderLayout());
            this.setLayout(new BoxLayout(this, 0));
            this.slider_granularity = 1000;
            this.slider = new JSlider(0, this.slider_granularity, this.slider_granularity / 2);
            this.slider.addChangeListener(this);
            this.add((Component)this.slider, "Center");
            this.format = (DecimalFormat)NumberFormat.getInstance();
            this.label = new JLabel();
            this.showGammaValue(this.getGamma());
            this.add((Component)this.label, "East");
        }

        public void stateChanged(ChangeEvent changeEvent) {
            double d = this.getGamma();
            this.showGammaValue(d);
            if (!this.slider.getValueIsAdjusting()) {
                FitsImageViewer.this.setGamma(d);
            }
        }

        private double getGamma() {
            double d = (double)this.slider.getValue() / (double)this.slider_granularity;
            double d2 = Math.tan(d * Math.PI * 0.5);
            return d2;
        }

        private void showGammaValue(double d) {
            this.label.setText("gamma=" + this.format.format(d));
        }
    }

    private class Monitor
    extends JProgressBar
    implements ChangeListener {
        public Monitor() {
            FitsImageViewer.this.digitizer.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setValue((int)(FitsImageViewer.this.digitizer.getProgress() * 100.0));
        }
    }

    private class Picture
    extends JPanel {
        int image_width;
        int image_height;

        public Picture() {
            FitsImageViewer.this.tracker = new MediaTracker(this);
            FitsImageViewer.this.tracker.addImage(FitsImageViewer.this.image, 0);
            FitsImageViewer.this.tracker.checkAll(true);
            this.image_width = FitsImageViewer.this.image.getWidth(this);
            this.image_height = FitsImageViewer.this.image.getHeight(this);
            this.setPreferredSize(new Dimension(this.image_width, this.image_height));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n * this.image_height >= this.image_width * n2) {
                n = this.image_width * n2 / this.image_height;
            } else {
                n2 = this.image_height * n / this.image_width;
            }
            graphics2D.drawImage(FitsImageViewer.this.image, 0, 0, n, n2, this);
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            boolean bl = super.imageUpdate(image, n, n2, n3, n4, n5);
            return bl;
        }
    }
}

