/*
 * Decompiled with CFR 0.152.
 */
package eap.fitsbrowser;

import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsHDU;
import eap.fits.FitsHeader;
import eap.fits.FitsImageData;
import eap.fits.FitsTableData;
import eap.fitsbrowser.FitsImageViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HDUDisplay
extends JTabbedPane {
    FitsHDU hdu;
    JPanel headerDisplay;
    JComponent dataDisplay;

    public HDUDisplay(FitsHDU fitsHDU) throws FitsException {
        JComponent jComponent;
        FitsHeader fitsHeader = fitsHDU.getHeader();
        int n = fitsHeader.cardCount();
        JTextArea jTextArea = new JTextArea(n, 80);
        jTextArea.setFont(new Font("Courier", 0, 12));
        jTextArea.setLineWrap(false);
        for (int i = 0; i < n; ++i) {
            jTextArea.append(fitsHeader.card(i) + "\n");
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension = new Dimension(dimension.width, dimension.width / 3);
        jScrollPane.setPreferredSize(dimension);
        this.add("Header", jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.red), fitsHeader.getName(), 3, 3));
        FitsData fitsData = fitsHDU.getData();
        try {
            if (fitsData.blockCount() > 0) {
                jComponent = new FitsImageViewer((FitsImageData)fitsData);
                ((FitsImageViewer)jComponent).showProgress();
                ((FitsImageViewer)jComponent).allowGammaCorrection();
                this.add(fitsHeader.getType(), jComponent);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            jComponent = new JTable((FitsTableData)fitsData);
            ((JTable)jComponent).setAutoResizeMode(0);
            ((JTable)jComponent).setPreferredScrollableViewportSize(new Dimension(500, 70));
            jComponent.addMouseMotionListener(new TableMouse());
            this.add(fitsHeader.getType(), new JScrollPane(jComponent));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private class TableMouse
    extends MouseMotionAdapter {
        int last_row = -1;

        TableMouse() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint()) + 1;
            if (n != this.last_row) {
                jTable.setToolTipText("row " + n);
                this.last_row = n;
            }
        }
    }
}

