/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHDUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class FitsFile {
    private File file;
    private RandomAccessFile raFile;
    private Vector hdUnits = new Vector(1);
    private boolean changeHDU = false;

    public FitsFile() {
    }

    public FitsFile(DataInput file) throws FitsException {
        this();
        this.scanFitsFile(file, false);
    }

    public FitsFile(DataInput file, boolean sflag) throws FitsException {
        this();
        this.scanFitsFile(file, sflag);
    }

    public FitsFile(File file) throws IOException, FitsException {
        this();
        this.raFile = new RandomAccessFile(file, "r");
        this.file = file;
        this.scanFitsFile(this.raFile, false);
    }

    public FitsFile(String filename) throws IOException, FitsException {
        this(new File(filename));
    }

    private void scanFitsFile(DataInput file, boolean sflag) throws FitsException {
        int no_hdu = 0;
        try {
            while (true) {
                FitsHDUnit hdu = new FitsHDUnit(file, sflag);
                this.hdUnits.setSize(no_hdu++);
                this.hdUnits.addElement(hdu);
            }
        }
        catch (FitsException e) {
            if (no_hdu < 1) {
                throw new FitsException("Not a FITS file", 1);
            }
            this.hdUnits.trimToSize();
            return;
        }
    }

    protected void finalize() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
        }
        this.file = null;
    }

    public static boolean isFitsFile(File file) {
        int nb = 0;
        byte[] card = new byte[80];
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            nb = raf.read(card);
            raf.close();
        }
        catch (IOException e) {
            return false;
        }
        if (nb < 80) {
            return false;
        }
        String str = new String(card);
        return str.startsWith("SIMPLE  = ");
    }

    public static boolean isFitsFile(String filename) {
        return FitsFile.isFitsFile(new File(filename));
    }

    public void addHDUnit(FitsHDUnit hdu) {
        this.hdUnits.addElement(hdu);
        this.changeHDU = true;
    }

    public void insertHDUnitAt(FitsHDUnit hdu, int index) {
        this.hdUnits.insertElementAt(hdu, index);
        this.changeHDU = true;
    }

    public void removeHDUnitAt(int index) {
        this.hdUnits.removeElementAt(index);
        this.changeHDU = true;
    }

    public final FitsHDUnit getHDUnit(int no) {
        int n = 0;
        if (no < 0) {
            return (FitsHDUnit)this.hdUnits.firstElement();
        }
        if (no >= this.hdUnits.size()) {
            return (FitsHDUnit)this.hdUnits.lastElement();
        }
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            FitsHDUnit hdu = (FitsHDUnit)enumeration.nextElement();
            if (n == no) {
                return hdu;
            }
            ++n;
        }
        return (FitsHDUnit)this.hdUnits.lastElement();
    }

    public void saveFile() throws IOException, FitsException {
        if (this.changeHDU) {
            throw new FitsException("HD Units of file have been changes", 1);
        }
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            if (((FitsHDUnit)enumeration.nextElement()).canSave()) continue;
            throw new FitsException("No space in FITS header", 6);
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).saveFile(raf);
        }
        raf.close();
    }

    public void writeFile(DataOutput file) throws IOException, FitsException {
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).writeFile(file);
        }
    }

    public void writeFile(File file) throws IOException, FitsException {
        if (file == null) {
            throw new FitsException("Cannot write to null-pointer file", 1);
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new FitsException("Cannot overwrite special file", 1);
            }
            if (this.file != null && this.file.getCanonicalPath().equals(file.getCanonicalPath())) {
                throw new FitsException("Cannot overwrite itself", 1);
            }
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        this.writeFile(raf);
        raf.close();
    }

    public void writeFile(String filename) throws IOException, FitsException {
        this.writeFile(new File(filename));
    }

    public void closeFile() {
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).closeFile();
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file = null;
    }

    public final int getNoHDUnits() {
        return this.hdUnits.size();
    }

    public String getName() {
        String name = "";
        if (this.file != null) {
            try {
                name = this.file.getCanonicalPath();
            }
            catch (IOException e) {
                name = this.file.getAbsolutePath();
            }
        }
        return name;
    }

    public File getFile() {
        return this.file;
    }
}

