/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsKeyword;
import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FitsHeader {
    private Vector keywords = null;
    private Hashtable kwHash;
    private Hashtable commentHash;
    private int headerSpace = 0;

    public FitsHeader() {
        this.keywords = new Vector(36, 36);
        this.kwHash = new Hashtable();
        this.commentHash = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public FitsHeader(DataInput file) throws FitsException {
        super();
        record = new byte[2880];
        line = new byte[80];
        try {
            file.readFully(record, 0, 2880);
            kw = new FitsKeyword(record);
            if (!kw.getName().equals("SIMPLE") && !kw.getName().equals("XTENSION")) {
                throw new FitsException("Not Standard records", 4);
            }
        }
        catch (IOException e) {
            throw new FitsException("No more data", 4);
        }
        catch (FitsException e) {
            throw new FitsException("", 4);
        }
        no_kw = 1;
        this.keywords = new Vector<E>(36, 36);
        no_kw = 0;
        try {
            n = 0;
            while (true) {
                k = 0;
                while (k < 80) {
                    line[k] = record[n++];
                    ++k;
                }
                kw = new FitsKeyword(line);
                this.keywords.setSize(no_kw++);
                this.keywords.addElement(kw);
                if (2880 > n) continue;
                file.readFully(record, 0, 2880);
                n = 0;
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot read header", 4);
        }
        catch (FitsException e) {
            if (e.getType() != 3) {
                throw new FitsException("Bad FITS keyword", 4);
            }
            idx = this.keywords.size() - 1;
            ** while (((FitsKeyword)this.keywords.elementAt((int)idx)).isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            this.keywords.removeElementAt(idx--);
            continue;
        }
lbl43:
        // 1 sources

        this.keywords.trimToSize();
        this.headerSpace = (1 + no_kw / 36) * 36;
        this.kwHash = new Hashtable<K, V>(this.keywords.size());
        this.commentHash = new Hashtable<K, V>();
        list = this.keywords.elements();
        while (list.hasMoreElements()) {
            kw = (FitsKeyword)list.nextElement();
            this.hashKeyword(kw);
        }
    }

    public void addKeyword(FitsKeyword kw) {
        if (kw == null) {
            return;
        }
        this.keywords.addElement(kw);
        this.hashKeyword(kw);
    }

    public void insertKeywordAt(FitsKeyword kw, int index) {
        if (kw == null) {
            return;
        }
        this.keywords.insertElementAt(kw, index);
        this.hashKeyword(kw);
    }

    public void removeKeywordAt(int index) {
        FitsKeyword kw = (FitsKeyword)this.keywords.elementAt(index);
        if (kw == null) {
            return;
        }
        this.kwHash.remove(kw.getName());
        this.keywords.removeElementAt(index);
    }

    private void hashKeyword(FitsKeyword kw) {
        if (kw == null) {
            return;
        }
        if (kw.getType() == 1) {
            Vector<FitsKeyword> vec = (Vector<FitsKeyword>)this.commentHash.get(kw.getName());
            if (vec == null) {
                vec = new Vector<FitsKeyword>();
                this.commentHash.put(kw.getName(), vec);
            }
            vec.addElement(kw);
        } else {
            this.kwHash.put(kw.getName(), kw);
        }
    }

    public final int getType() {
        if (this.keywords.size() < 3) {
            return -1;
        }
        int type = -1;
        FitsKeyword kw = (FitsKeyword)this.keywords.elementAt(0);
        if (kw.getName().equals("SIMPLE") && kw.getBool()) {
            kw = (FitsKeyword)this.kwHash.get("NAXIS1");
            type = kw != null && kw.getInt() == 0 ? ((kw = (FitsKeyword)this.kwHash.get("GROUPS")) != null && kw.getBool() ? 4 : 1) : 1;
        } else if (kw.getName().equals("XTENSION")) {
            type = kw.getString().startsWith("IMAGE") ? 1 : (kw.getString().startsWith("BINTABLE") ? 2 : (kw.getString().startsWith("TABLE") ? 3 : 0));
        }
        return type;
    }

    public final long getDataSize() {
        if (this.kwHash == null) {
            return 0L;
        }
        int type = this.getType();
        FitsKeyword kw = (FitsKeyword)this.kwHash.get("NAXIS");
        long naxis = kw.getInt();
        if (naxis < 1L) {
            return 0L;
        }
        kw = (FitsKeyword)this.kwHash.get("BITPIX");
        long n_byte = Math.abs(kw.getInt()) / 8;
        long d_size = 1L;
        int n = 1;
        while ((long)n <= naxis) {
            if (type != 4 || n != 1) {
                kw = (FitsKeyword)this.kwHash.get("NAXIS" + n);
                d_size *= (long)kw.getInt();
            }
            ++n;
        }
        kw = (FitsKeyword)this.kwHash.get("PCOUNT");
        if (kw != null) {
            d_size += (long)kw.getInt();
        }
        if ((kw = (FitsKeyword)this.kwHash.get("GCOUNT")) != null) {
            d_size *= (long)kw.getInt();
        }
        return d_size *= n_byte;
    }

    public final String getName() {
        FitsKeyword kw = (FitsKeyword)this.kwHash.get("EXTNAME");
        if (kw == null || kw.getType() != 2) {
            return "NONE";
        }
        return kw.getString();
    }

    public final int getVersion() {
        FitsKeyword kw = (FitsKeyword)this.kwHash.get("EXTVER");
        if (kw == null || kw.getType() != 4) {
            return 1;
        }
        return kw.getInt();
    }

    public final int getNoKeywords() {
        return this.keywords.size();
    }

    public final FitsKeyword getKeyword(int no) {
        if (no < 0 || this.keywords.size() <= no) {
            return null;
        }
        return (FitsKeyword)this.keywords.elementAt(no);
    }

    public final FitsKeyword getKeyword(String name) {
        Vector vec;
        FitsKeyword kw = (FitsKeyword)this.kwHash.get(name);
        if (kw == null && (vec = (Vector)this.commentHash.get(name)) != null) {
            kw = (FitsKeyword)vec.firstElement();
        }
        return kw;
    }

    public final FitsKeyword[] getKeywords(String name) {
        FitsKeyword kw = (FitsKeyword)this.kwHash.get(name);
        if (kw == null) {
            Vector vec = (Vector)this.commentHash.get(name);
            if (vec == null) {
                return null;
            }
            FitsKeyword[] setKw = new FitsKeyword[vec.size()];
            int n = 0;
            while (n < vec.size()) {
                setKw[n] = (FitsKeyword)vec.elementAt(n);
                ++n;
            }
            return setKw;
        }
        FitsKeyword[] setKw = new FitsKeyword[]{kw};
        return setKw;
    }

    public final Enumeration getKeywords() {
        return this.keywords.elements();
    }

    public String toString() {
        int size = this.keywords.size();
        StringBuffer hd = new StringBuffer(80 * size);
        Enumeration enumeration = this.keywords.elements();
        while (enumeration.hasMoreElements()) {
            FitsKeyword kw = (FitsKeyword)enumeration.nextElement();
            hd.append(kw.toString());
        }
        return hd.toString();
    }

    public int getHeaderSpace() {
        return this.headerSpace;
    }

    public void setExtension(int type) {
        FitsKeyword kw;
        switch (type) {
            case 1: {
                kw = new FitsKeyword("XTENSION", "IMAGE", "Image extension");
                break;
            }
            case 2: {
                kw = new FitsKeyword("XTENSION", "BINTABLE", "Binary table extension");
                break;
            }
            case 3: {
                kw = new FitsKeyword("XTENSION", "TABLE", "ASCII table extension");
                break;
            }
            default: {
                return;
            }
        }
        this.removeKeywordAt(0);
        this.insertKeywordAt(kw, 0);
    }
}

