/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsData;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsWCS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FitsMatrix
extends FitsData {
    private int noValues;
    private int noColumns;
    private int noRows;
    private int dataFormat = -32;
    private int bytesPerData = 4;
    private boolean scaling = false;
    private double zero = 0.0;
    private double scale = 1.0;
    private FitsWCS wcs;

    public FitsMatrix(FitsHeader header, DataInput file, boolean sflag) throws FitsException {
        super(header, file, sflag);
        if (this.type != 1) {
            throw new FitsException("Wrong header type", 4);
        }
        FitsKeyword kw = header.getKeyword("BITPIX");
        if (kw == null || kw.getType() != 4) {
            throw new FitsException("Invalid or missing BITPIX", 4);
        }
        this.dataFormat = kw.getInt();
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(header);
        kw = header.getKeyword("BSCALE");
        if (kw != null) {
            this.scale = kw.getReal();
            if (this.scale != 1.0) {
                this.scaling = true;
            }
        }
        if ((kw = header.getKeyword("BZERO")) != null) {
            this.zero = kw.getReal();
            if (this.zero != 0.0) {
                this.scaling = true;
            }
        }
        this.noColumns = this.naxis[0];
        this.noRows = this.noValues / this.noColumns;
    }

    public FitsMatrix(int bitpix, int[] nax) throws FitsException {
        super(bitpix, nax);
        this.type = 1;
        this.dataFormat = bitpix;
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(nax.length);
        this.noColumns = this.naxis[0];
        this.noRows = this.noValues / this.noColumns;
    }

    public FitsHeader getHeader() {
        FitsHeader hdr = super.getHeader();
        hdr.addKeyword(new FitsKeyword("", ""));
        int n = 1;
        while (n <= this.naxis.length) {
            hdr.addKeyword(new FitsKeyword("CRPIX" + n, this.wcs.crpix[n - 1], "Reference pixel"));
            hdr.addKeyword(new FitsKeyword("CRVAL" + n, this.wcs.crval[n - 1], "Coordinate at reference pixel"));
            hdr.addKeyword(new FitsKeyword("CDELT" + n, this.wcs.cdelt[n - 1], "Coordinate increament per pixel"));
            ++n;
        }
        return hdr;
    }

    public short[] getShortValues(int offset, int size, short[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new short[size];
        }
        int n = 0;
        DataInputStream dis = this.getInStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = (short)dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = (short)dis.readInt();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (short)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    public int[] getIntValues(int offset, int size, int[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new int[size];
        }
        int n = 0;
        DataInputStream dis = this.getInStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = dis.readInt();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot read data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (int)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    public float[] getFloatValues(int offset, int size, float[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new float[size];
        }
        int n = 0;
        DataInputStream dis = this.getInStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = dis.readInt();
                    }
                    break;
                }
                case -32: {
                    while (n < size) {
                        data[n++] = dis.readFloat();
                    }
                    break;
                }
                case -64: {
                    while (n < size) {
                        data[n++] = (float)dis.readDouble();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot read data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (float)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    public int[] getRow(int rowIdx) throws FitsException {
        int[] data = new int[this.noColumns];
        int offset = rowIdx * this.noColumns;
        float[] fdata = new float[this.noColumns];
        this.getFloatValues(offset, this.noColumns, fdata);
        int n = 0;
        while (n < this.noColumns) {
            data[n] = (int)Math.rint(fdata[n]);
            ++n;
        }
        return data;
    }

    private DataInputStream getInStream(int offset, int size) throws FitsException {
        DataInputStream dis;
        try {
            this.dataFile.seek(this.dataOffset + (long)(offset * this.bytesPerData));
            if (this.noValues < offset + size) {
                size = this.noValues - offset;
            }
            byte[] dbuf = new byte[size * this.bytesPerData];
            this.dataFile.read(dbuf);
            dis = new DataInputStream(new ByteArrayInputStream(dbuf));
        }
        catch (IOException e) {
            throw new FitsException("Cannot read InStream data", 5);
        }
        return dis;
    }

    public void setShortValues(int offset, short[] sdata) throws FitsException {
        if (offset < 0 || this.noValues <= offset) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (sdata == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(sdata.length * this.bytesPerData);
        DataOutputStream dos = new DataOutputStream(baos);
        if (this.scaling) {
            throw new FitsException("Scaling of short not supported", 5);
        }
        int n = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data to BYTE", 5);
                }
                case 16: {
                    while (n < sdata.length) {
                        dos.writeShort(sdata[n++]);
                    }
                    break;
                }
                case 32: {
                    while (n < sdata.length) {
                        dos.writeInt(sdata[n++]);
                    }
                    break;
                }
                case -32: {
                    while (n < sdata.length) {
                        dos.writeFloat(sdata[n++]);
                    }
                    break;
                }
                case -64: {
                    while (n < sdata.length) {
                        dos.writeDouble(sdata[n++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(offset * this.bytesPerData));
                this.dataFile.write(baos.toByteArray());
            } else {
                byte[] vals = baos.toByteArray();
                n = (int)(this.dataOffset * (long)this.bytesPerData);
                int i = 0;
                while (i < vals.length) {
                    this.dataArray[n++] = vals[i];
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot convert data", 5);
        }
    }

    public void setIntValues(int offset, int[] idata) throws FitsException {
        if (offset < 0 || this.noValues <= offset) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (idata == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(idata.length * this.bytesPerData);
        DataOutputStream dos = new DataOutputStream(baos);
        if (this.scaling) {
            throw new FitsException("Scaling of int not supported", 5);
        }
        int n = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data", 5);
                }
                case 16: {
                    while (n < idata.length) {
                        dos.writeShort((short)idata[n++]);
                    }
                    break;
                }
                case 32: {
                    while (n < idata.length) {
                        dos.writeInt(idata[n++]);
                    }
                    break;
                }
                case -32: {
                    while (n < idata.length) {
                        dos.writeFloat(idata[n++]);
                    }
                    break;
                }
                case -64: {
                    while (n < idata.length) {
                        dos.writeDouble(idata[n++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(offset * this.bytesPerData));
                this.dataFile.write(baos.toByteArray());
            } else {
                byte[] vals = baos.toByteArray();
                n = (int)(this.dataOffset * (long)this.bytesPerData);
                int i = 0;
                while (i < vals.length) {
                    this.dataArray[n++] = vals[i];
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot write data", 5);
        }
    }

    public void setFloatValues(int offset, float[] data) throws FitsException {
        if (offset < 0 || this.noValues <= offset) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (data == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length * this.bytesPerData);
        DataOutputStream dos = new DataOutputStream(baos);
        if (this.scaling) {
            int i = 0;
            while (i < data.length) {
                data[i] = (float)(((double)data[i] - this.zero) / this.scale);
                ++i;
            }
        }
        int n = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data", 5);
                }
                case 16: {
                    while (n < data.length) {
                        dos.writeShort((short)data[n++]);
                    }
                    break;
                }
                case 32: {
                    while (n < data.length) {
                        dos.writeInt((int)data[n++]);
                    }
                    break;
                }
                case -32: {
                    while (n < data.length) {
                        dos.writeFloat(data[n++]);
                    }
                    break;
                }
                case -64: {
                    while (n < data.length) {
                        dos.writeDouble(data[n++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(offset * this.bytesPerData));
                this.dataFile.write(baos.toByteArray());
            } else {
                byte[] vals = baos.toByteArray();
                n = (int)(this.dataOffset * (long)this.bytesPerData);
                int i = 0;
                while (i < vals.length) {
                    this.dataArray[n++] = vals[i];
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot write data", 5);
        }
    }

    public int getNoValues() {
        return this.noValues;
    }

    public void setCrpix(double[] crp) {
        this.wcs.crpix = new double[this.naxis.length];
        int n = 0;
        while (n < this.naxis.length) {
            this.wcs.crpix[n] = crp != null && n < crp.length ? crp[n] : 1.0;
            ++n;
        }
    }

    public double[] getCrpix() {
        return this.wcs.crpix;
    }

    public void setCrval(double[] crv) {
        this.wcs.crval = new double[this.naxis.length];
        int n = 0;
        while (n < this.naxis.length) {
            this.wcs.crval[n] = crv != null && n < crv.length ? crv[n] : 1.0;
            ++n;
        }
    }

    public double[] getCrval() {
        return this.wcs.crval;
    }

    public void setCdelt(double[] cd) {
        this.wcs.cdelt = new double[this.naxis.length];
        int n = 0;
        while (n < this.naxis.length) {
            this.wcs.cdelt[n] = cd != null && n < cd.length ? cd[n] : 1.0;
            ++n;
        }
    }

    public double[] getCdelt() {
        return this.wcs.cdelt;
    }

    public FitsWCS getWCS() {
        return this.wcs;
    }

    public double[] toWCS(double[] pix) {
        return this.wcs.toWCS(pix);
    }

    public double[] toPixel(double[] wc) {
        return this.wcs.toPixel(wc);
    }

    public int getNoColumns() {
        return this.noColumns;
    }

    public int getNoRows() {
        return this.noRows;
    }

    public int getBytesPerData() {
        return this.bytesPerData;
    }

    public void setBytesPerData(int bytesPerData) {
        this.bytesPerData = bytesPerData;
    }

    public int getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(int dataFormat) {
        this.dataFormat = dataFormat;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    public double getZero() {
        return this.zero;
    }

    public void setZero(double zero) {
        this.zero = zero;
    }

    public void setNoColumns(int noColumns) {
        this.noColumns = noColumns;
    }

    public void setNoRows(int noRows) {
        this.noRows = noRows;
    }

    public void setNoValues(int noValues) {
        this.noValues = noValues;
    }
}

