/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.gui.ExtendedFileFilter;
import de.andreasroerig.util.RegParams;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends JFileChooser
implements ComponentListener {
    public FileChooser(String dir) {
        super(dir);
        this.addComponentListener(this);
        this.setMultiSelectionEnabled(true);
        FileFilter ff = this.getFileFilter();
        this.removeChoosableFileFilter(ff);
        this.resize();
    }

    public FileChooser(String dir, String fname) {
        super(dir);
        this.addComponentListener(this);
        File theFile = new File(fname);
        this.setMultiSelectionEnabled(false);
        this.setDialogType(1);
        this.setSelectedFile(theFile);
        this.resize();
    }

    protected void resize() {
        RegParams rp = RegParams.instance();
        if (rp.getFcWinHeight() > 0 && rp.getFcWinWidth() > 0) {
            this.setPreferredSize(new Dimension(rp.getFcWinWidth(), rp.getFcWinHeight()));
        }
    }

    public String getPath() {
        String res = null;
        File theFile = this.getSelectedFile();
        if (theFile != null) {
            res = theFile.getPath();
            res = res.substring(0, res.lastIndexOf(theFile.getName()));
        }
        return res;
    }

    public void setFilterFitsTiff(int defaultType) {
        ExtendedFileFilter[] eff = new ExtendedFileFilter[]{new ExtendedFileFilter(1), new ExtendedFileFilter(0)};
        this.addFileFilters(eff, defaultType);
    }

    public String getName() {
        String res = null;
        File theFile = this.getSelectedFile();
        if (theFile != null) {
            res = theFile.getName();
        }
        return res;
    }

    public String getNameWithoutExtension() {
        String res = this.getName();
        if (res != null) {
            res = res.substring(0, res.lastIndexOf("."));
        }
        return res;
    }

    public String getExtension() {
        String res = this.getName();
        if (res != null) {
            res = res.substring(res.lastIndexOf("."), res.length());
        }
        return res;
    }

    public int getExtendedFileFilterType() {
        return ((ExtendedFileFilter)this.getFileFilter()).getType();
    }

    public boolean isFilterTypeFits() {
        return ((ExtendedFileFilter)this.getFileFilter()).getType() == 1;
    }

    public boolean isFilterTypeTiff() {
        return ((ExtendedFileFilter)this.getFileFilter()).getType() == 0;
    }

    public void addFileFilter(ExtendedFileFilter eff) {
        this.addChoosableFileFilter(eff);
    }

    public void addFileFilters(ExtendedFileFilter[] eff, int defaultType) {
        int last = 0;
        int i = 0;
        while (i < eff.length) {
            if (eff[i].getType() != defaultType) {
                this.addChoosableFileFilter(eff[i]);
            } else {
                last = i;
            }
            ++i;
        }
        this.addChoosableFileFilter(eff[last]);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        RegParams rp = RegParams.instance();
        Rectangle rec = this.getBounds();
        rp.setFcWinHeight(rec.height);
        rp.setFcWinWidth(rec.width);
    }

    public void componentShown(ComponentEvent e) {
    }
}

