/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.match;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.NoTriangleException;
import de.andreasroerig.match.MatchException;
import de.andreasroerig.match.Star;
import de.andreasroerig.match.StarTriangle;
import de.andreasroerig.match.TopVotes;
import de.andreasroerig.match.Trans;
import de.andreasroerig.util.RegParams;
import de.andreasroerig.util.SLogger;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class Match
implements Runnable {
    private StarTriangle[] st1;
    private StarTriangle[] st2;
    private Star[] saA;
    private Star[] saB;
    private int numstars;
    private RegParams regPar = RegParams.instance();
    private boolean recalc;
    private int maxiterations = 3;
    private Bild bild1;
    private Bild bild2;
    private Trans theResultTrans;

    public Match() {
        this.numstars = RegParams.instance().getMaxNumStars();
    }

    public synchronized void run() {
        Trans theTrans = null;
        SLogger.debug("run start *");
        SLogger.debug("maxNumStars=" + this.regPar.getMaxNumStars());
        SLogger.debug("transformMode=" + this.regPar.getTransformMode());
        try {
            this.saA = this.bild1.getStarArray();
            this.saB = this.bild2.getStarArray();
            Vector vt1 = this.starsToTriangles(this.saA);
            Vector vt2 = this.starsToTriangles(this.saB);
            this.st1 = this.verifyTriangles(vt1);
            this.st2 = this.verifyTriangles(vt2);
            int[][] vm = this.makeVoteMatrix(this.saA, this.saB, this.st1, this.st2);
            TopVotes topVotes = new TopVotes();
            topVotes.calcVotes(vm);
            int numMatches = topVotes.getASize();
            SLogger.debug("findTrans Number of Matches: " + numMatches);
            theTrans = this.iterate(topVotes);
            SLogger.debug("nach iterate");
        }
        catch (MatchException e) {
            SLogger.debug("Exception in run");
            SLogger.error(e);
            theTrans = null;
            SLogger.error(e);
        }
        this.theResultTrans = theTrans;
        this.notify();
        this.notify();
        this.notify();
        SLogger.debug("run ende");
    }

    public void do_run() {
        Trans theTrans = null;
        SLogger.debug("do_run start *");
        SLogger.debug("maxNumStars=" + this.regPar.getMaxNumStars());
        SLogger.debug("transformMode=" + this.regPar.getTransformMode());
        try {
            this.saA = this.bild1.getStarArray();
            this.saB = this.bild2.getStarArray();
            Vector vt1 = this.starsToTriangles(this.saA);
            Vector vt2 = this.starsToTriangles(this.saB);
            this.st1 = this.verifyTriangles(vt1);
            this.st2 = this.verifyTriangles(vt2);
            int[][] vm = this.makeVoteMatrix(this.saA, this.saB, this.st1, this.st2);
            TopVotes topVotes = new TopVotes();
            topVotes.calcVotes(vm);
            int numMatches = topVotes.getASize();
            SLogger.debug("findTrans Number of Matches: " + numMatches);
            theTrans = this.iterate(topVotes);
            SLogger.debug("nach iterate");
        }
        catch (MatchException e) {
            SLogger.debug("Exception in run");
            SLogger.error(e);
            theTrans = null;
            SLogger.error(e);
        }
        this.theResultTrans = theTrans;
        SLogger.debug("do_run ende");
    }

    public Trans findTrans() {
        SLogger.debug("findTrans start");
        this.do_run();
        SLogger.debug("findTrans end");
        return this.theResultTrans;
    }

    public Trans findTrans2(Star[] sa1, Star[] sa2) {
        Trans theTrans;
        Vector<StarTriangle> m1 = new Vector<StarTriangle>();
        Vector<StarTriangle> m2 = new Vector<StarTriangle>();
        SLogger.debug("findTrans2 start");
        try {
            Star aStar = new Star();
            aStar.setSortCriteria(1);
            Arrays.sort(sa1, aStar);
            Arrays.sort(sa2, aStar);
            this.saA = sa1;
            this.saB = sa2;
            this.st1 = this.starsToCloseTriangles(sa1);
            this.st2 = this.starsToCloseTriangles(sa2);
            int maxLoopIdx = this.regPar.getMaxNumStars();
            int maxIdx = Math.min(sa1.length - 3, maxLoopIdx);
            int i = 0;
            while (i < maxIdx) {
                int idx = this.findMatchingST(i);
                if (idx >= 0) {
                    m1.addElement(this.st1[i]);
                    m2.addElement(this.st2[idx]);
                }
                ++i;
            }
            this.st1 = new StarTriangle[m1.size()];
            this.st2 = new StarTriangle[m1.size()];
            i = 0;
            while (i < m1.size()) {
                this.st1[i] = (StarTriangle)m1.elementAt(i);
                this.st2[i] = (StarTriangle)m2.elementAt(i);
                ++i;
            }
            int[][] vm = this.makeVoteMatrix(sa1, sa2, this.st1, this.st2);
            TopVotes topVotes = new TopVotes();
            topVotes.calcVotes(vm);
            int numMatches = topVotes.getASize();
            SLogger.debug("findTrans2 Number of Matches: " + numMatches);
            theTrans = this.iterate(topVotes);
        }
        catch (MatchException e) {
            SLogger.error(e);
            theTrans = null;
            SLogger.error(e);
        }
        SLogger.debug("findTrans2 end");
        return theTrans;
    }

    private int findMatchingST(int i) {
        double eps = 0.002;
        int result = -1;
        StarTriangle str1 = this.st1[i];
        int idx = Arrays.binarySearch(this.st2, str1);
        if (idx < 0) {
            idx = -idx;
        }
        double xt1 = str1.xt;
        double yt1 = str1.yt;
        try {
            double minDistance = 1.0;
            int minIndex = idx;
            int j = idx - 10;
            while (j < idx + 10) {
                if (j >= 0 && j < this.st2.length - 1) {
                    double bQuadrat;
                    double xt2 = this.st2[j].xt;
                    double yt2 = this.st2[j].yt;
                    double aQuadrat = Math.pow(xt1 - xt2, 2.0);
                    double distance = Math.sqrt(aQuadrat + (bQuadrat = Math.pow(yt1 - yt2, 2.0)));
                    if (distance < eps && distance < minDistance) {
                        minDistance = distance;
                        str1.setTsDistance(distance);
                        this.st2[j].setTsDistance(distance);
                        result = j;
                    }
                }
                ++j;
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Trans iterate(TopVotes tv) throws MatchException {
        Trans trans = null;
        int required_pairs = 0;
        int start_pairs = 0;
        int[] winner_index_A = tv.getWinIdxA();
        int[] winner_index_B = tv.getWinIdxB();
        int nbright = tv.getASize();
        int[] winner_votes = tv.getWinVotes();
        SLogger.debug("iterate start");
        try {
            switch (this.regPar.getTransformMode()) {
                case 0: {
                    required_pairs = 3;
                    start_pairs = 6;
                    break;
                }
                case 1: {
                    required_pairs = 6;
                    start_pairs = 24;
                    break;
                }
                case 2: {
                    required_pairs = 8;
                    start_pairs = 32;
                    break;
                }
                default: {
                    SLogger.debug("iterate: invalid transform mode " + this.regPar.getTransformMode());
                }
            }
            int initial_pairs = this.recalc ? this.numstars : start_pairs;
            trans = this.calcTrans(initial_pairs, tv);
            int nr = nbright;
            Star[] a_prime = new Star[this.saA.length];
            double[] dist2 = new double[this.saA.length];
            double[] dist2_sorted = new double[this.saA.length];
            double max_dist2 = this.regPar.getMatchMaxDist() * this.regPar.getMatchMaxDist();
            boolean is_ok = true;
            int iters_so_far = 0;
            while (iters_so_far < this.maxiterations) {
                int j;
                SLogger.debug("iterate in iteration " + iters_so_far);
                int nb = 0;
                int i = 0;
                while (i < nr) {
                    Star sa = this.saA[winner_index_A[i]];
                    double newx = trans.calcX(sa.getDx(), sa.getDy());
                    double newy = trans.calcY(sa.getDx(), sa.getDy());
                    a_prime[i] = new Star(newx, newy);
                    ++i;
                }
                i = 0;
                while (i < nr) {
                    Star sb = this.saB[winner_index_B[i]];
                    double xdiff = a_prime[i].dx - sb.dx;
                    double ydiff = a_prime[i].dy - sb.dy;
                    dist2[i] = xdiff * xdiff + ydiff * ydiff;
                    dist2_sorted[i] = dist2[i];
                    ++i;
                }
                Arrays.sort(dist2_sorted);
                i = 0;
                while (i < nr) {
                    if (dist2[i] > max_dist2) {
                        j = i + 1;
                        while (j < nr) {
                            winner_votes[j - 1] = winner_votes[j];
                            winner_index_A[j - 1] = winner_index_A[j];
                            winner_index_B[j - 1] = winner_index_B[j];
                            dist2[j - 1] = dist2[j];
                            ++j;
                        }
                        --nr;
                        ++nb;
                        --i;
                    }
                    ++i;
                }
                double sigma = nr < 2 ? 0.0 : this.findPercentile(dist2_sorted, nr, this.regPar.getMatchPercentile());
                if (sigma <= this.regPar.getMatchHaltSigma()) {
                    is_ok = true;
                    break;
                }
                i = 0;
                while (i < nr) {
                    if (dist2[i] > this.regPar.getMatchNSigma() * sigma) {
                        j = i + 1;
                        while (j < nr) {
                            winner_votes[j - 1] = winner_votes[j];
                            winner_index_A[j - 1] = winner_index_A[j];
                            winner_index_B[j - 1] = winner_index_B[j];
                            dist2[j - 1] = dist2[j];
                            ++j;
                        }
                        --nr;
                        ++nb;
                        --i;
                    }
                    ++i;
                }
                if (nb == 0) {
                    is_ok = true;
                    break;
                }
                if (nr < required_pairs) {
                    SLogger.debug("iterate: only " + nr + " points remain, fewer than " + required_pairs + " required");
                    is_ok = false;
                    break;
                }
                trans = this.calcTrans(nr, tv);
                ++iters_so_far;
            }
            if (iters_so_far == this.maxiterations) {
                SLogger.debug("SUCCESS(?): iters_so_far " + iters_so_far + "  = max_iterations");
            }
            trans.nr = nr;
            trans.sig = this.findPercentile(dist2_sorted, nr, this.regPar.getStdevPercentile());
            if (!is_ok) {
                SLogger.debug("Error");
            }
        }
        catch (NullPointerException e) {
            SLogger.debug("iterate NPE " + e.getMessage());
            SLogger.error(e);
            e.printStackTrace();
        }
        SLogger.debug("iterate end");
        return trans;
    }

    private double findPercentile(double[] ar, int num, double perc) {
        int index = (int)Math.floor((double)num * perc + 0.5);
        if (index >= num) {
            index = num - 1;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= ar.length) {
            index = ar.length - 1;
        }
        return ar[index];
    }

    private Trans calcTrans(int nbright, TopVotes tv) throws MatchException {
        Trans t = null;
        nbright = (tv = this.checkWinners(tv)).getASize() < nbright ? tv.getASize() : nbright;
        switch (this.regPar.getTransformMode()) {
            case 0: {
                t = this.calcTransLinear(nbright, tv);
                break;
            }
            case 1: {
                t = this.calcTransQuadratic(nbright, tv);
                break;
            }
            case 2: {
                t = this.calcTransCubic(nbright, tv);
            }
        }
        return t;
    }

    private TopVotes checkWinners(TopVotes tv) {
        int[] wiA = tv.getWinIdxA();
        int[] wiB = tv.getWinIdxB();
        double max_radius = this.regPar.getTriangleRadius();
        boolean changes = false;
        int nbright = tv.getASize();
        StarTriangle t1 = null;
        StarTriangle t2 = null;
        int i = 0;
        while (i < nbright) {
            try {
                if (i < nbright - 2) {
                    t1 = new StarTriangle(this.saA[wiA[i]], wiA[i], this.saA[wiA[i + 1]], wiA[i + 1], this.saA[wiA[i + 2]], wiA[i + 2]);
                    t2 = new StarTriangle(this.saB[wiB[i]], wiB[i], this.saB[wiB[i + 1]], wiB[i + 1], this.saB[wiB[i + 2]], wiB[i + 2]);
                }
                if (i == nbright - 2) {
                    t1 = new StarTriangle(this.saA[wiA[i]], wiA[i], this.saA[wiA[i + 1]], wiA[i + 1], this.saA[wiA[0]], wiA[0]);
                    t2 = new StarTriangle(this.saB[wiB[i]], wiB[i], this.saB[wiB[i + 1]], wiB[i + 1], this.saB[wiB[0]], wiB[0]);
                }
                if (i == nbright - 1) {
                    t1 = new StarTriangle(this.saA[wiA[i]], wiA[i], this.saA[wiA[0]], wiA[0], this.saA[wiA[1]], wiA[1]);
                    t2 = new StarTriangle(this.saB[wiB[i]], wiB[i], this.saB[wiB[0]], wiB[0], this.saB[wiB[1]], wiB[1]);
                }
                double ba_min = t1.ba - max_radius;
                double ba_max = t1.ba + max_radius;
                if (t2.ba >= ba_min && t2.ba <= ba_max) {
                    this.bild1.addMatch(t1);
                    this.bild2.addMatch(t2);
                    this.bild1.setSt(t1);
                    this.bild2.setSt(t2);
                    t1.setVerified(true);
                    t2.setVerified(true);
                } else {
                    t1.setVerified(false);
                    t2.setVerified(false);
                    changes = true;
                    SLogger.debug("Match failed i = " + i);
                }
            }
            catch (NoTriangleException e) {
                SLogger.debug("NoTriangleException i = " + i);
            }
            ++i;
        }
        if (changes) {
            int[] wv = tv.getWinVotes();
            int[] winVotes = new int[tv.getASize()];
            int[] winIdxA = new int[tv.getASize()];
            int[] winIdxB = new int[tv.getASize()];
            Hashtable ht = this.bild1.getMatchStarIndices();
            int j = 0;
            i = 0;
            while (i < nbright) {
                if (ht.containsKey(new Integer(wiA[i]))) {
                    winVotes[j] = wv[i];
                    winIdxA[j] = wiA[i];
                    winIdxB[j] = wiB[i];
                    ++j;
                }
                ++i;
            }
            tv.setWinVotes(winVotes);
            tv.setWinIdxA(winIdxA);
            tv.setWinIdxB(winIdxB);
            tv.setASize(j);
        }
        return tv;
    }

    private Trans calcTransLinear(int nbright, TopVotes tv) throws MatchException {
        Trans trans = new Trans();
        int startPairs = 6;
        int[] winner_index_A = tv.getWinIdxA();
        int[] winner_index_B = tv.getWinIdxB();
        double[][] matrix = new double[3][3];
        double[] vector = new double[3];
        trans.order = 0;
        double sum = 0.0;
        double sumx1 = 0.0;
        double sumy1 = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sumx1sq = 0.0;
        double sumy1sq = 0.0;
        double sumx1x2 = 0.0;
        double sumx1y1 = 0.0;
        double sumx1y2 = 0.0;
        double sumy1x2 = 0.0;
        double sumy1y2 = 0.0;
        StarTriangle st = new StarTriangle();
        int i = 0;
        while (i < nbright) {
            Star s1 = this.saA[winner_index_A[i]];
            Star s2 = this.saB[winner_index_B[i]];
            st.setS1(s1);
            st.setS2(s1);
            st.setS3(s1);
            this.bild1.setSt(st);
            this.bild1.addMatch(st);
            st.setS1(s2);
            st.setS2(s2);
            st.setS3(s2);
            this.bild2.setSt(st);
            this.bild2.addMatch(st);
            sum += 1.0;
            sumx1 += s1.dx;
            sumx2 += s2.dx;
            sumy1 += s1.dy;
            sumy2 += s2.dy;
            sumx1sq += s1.dx * s1.dx;
            sumy1sq += s1.dy * s1.dy;
            sumx1x2 += s1.dx * s2.dx;
            sumx1y1 += s1.dx * s1.dy;
            sumx1y2 += s1.dx * s2.dy;
            sumy1x2 += s1.dy * s2.dx;
            sumy1y2 += s1.dy * s2.dy;
            ++i;
        }
        matrix[0][0] = sumx1sq;
        matrix[0][1] = sumx1y1;
        matrix[0][2] = sumx1;
        matrix[1][0] = sumx1y1;
        matrix[1][1] = sumy1sq;
        matrix[1][2] = sumy1;
        matrix[2][0] = sumx1;
        matrix[2][1] = sumy1;
        matrix[2][2] = sum;
        vector[0] = sumx1x2;
        vector[1] = sumy1x2;
        vector[2] = sumx2;
        this.gaussMatrix(matrix, 3, vector);
        double solved_a = vector[0];
        double solved_b = vector[1];
        double solved_c = vector[2];
        matrix[0][0] = sumx1sq;
        matrix[0][1] = sumx1y1;
        matrix[0][2] = sumx1;
        matrix[1][0] = sumx1y1;
        matrix[1][1] = sumy1sq;
        matrix[1][2] = sumy1;
        matrix[2][0] = sumx1;
        matrix[2][1] = sumy1;
        matrix[2][2] = sum;
        vector[0] = sumx1y2;
        vector[1] = sumy1y2;
        vector[2] = sumy2;
        this.gaussMatrix(matrix, 3, vector);
        double solved_d = vector[0];
        double solved_e = vector[1];
        double solved_f = vector[2];
        trans.a = solved_c;
        trans.b = solved_a;
        trans.c = solved_b;
        trans.d = solved_f;
        trans.e = solved_d;
        trans.f = solved_e;
        return trans;
    }

    private Trans calcTransQuadratic(int nbright, TopVotes tv) throws MatchException {
        Trans trans = new Trans();
        int startPairs = 12;
        int[] winner_index_A = tv.getWinIdxA();
        int[] winner_index_B = tv.getWinIdxB();
        double[][] matrix = new double[6][6];
        double[] vector = new double[6];
        trans.order = 1;
        double sum = 0.0;
        double sumx1 = 0.0;
        double sumy1 = 0.0;
        double sumx1sq = 0.0;
        double sumx1y1 = 0.0;
        double sumy1sq = 0.0;
        double sumx1cu = 0.0;
        double sumx1sqy1 = 0.0;
        double sumx1y1sq = 0.0;
        double sumy1cu = 0.0;
        double sumx1qu = 0.0;
        double sumx1cuy1 = 0.0;
        double sumx1sqy1sq = 0.0;
        double sumx1y1cu = 0.0;
        double sumy1qu = 0.0;
        double sumx2 = 0.0;
        double sumx2x1 = 0.0;
        double sumx2y1 = 0.0;
        double sumx2x1sq = 0.0;
        double sumx2x1y1 = 0.0;
        double sumx2y1sq = 0.0;
        double sumy2 = 0.0;
        double sumy2x1 = 0.0;
        double sumy2y1 = 0.0;
        double sumy2x1sq = 0.0;
        double sumy2x1y1 = 0.0;
        double sumy2y1sq = 0.0;
        int i = 0;
        while (i < nbright) {
            Star s1 = this.saA[winner_index_A[i]];
            Star s2 = this.saB[winner_index_B[i]];
            sumx2 += s2.dx;
            sumx2x1 += s2.dx * s1.dx;
            sumx2y1 += s2.dx * s1.dy;
            sumx2x1sq += s2.dx * s1.dx * s1.dx;
            sumx2x1y1 += s2.dx * s1.dx * s1.dy;
            sumx2y1sq += s2.dx * s1.dy * s1.dy;
            sumy2 += s2.dy;
            sumy2x1 += s2.dy * s1.dx;
            sumy2y1 += s2.dy * s1.dy;
            sumy2x1sq += s2.dy * s1.dx * s1.dx;
            sumy2x1y1 += s2.dy * s1.dx * s1.dy;
            sumy2y1sq += s2.dy * s1.dy * s1.dy;
            sum += 1.0;
            sumx1 += s1.dx;
            sumy1 += s1.dy;
            sumx1sq += s1.dx * s1.dx;
            sumx1y1 += s1.dx * s1.dy;
            sumy1sq += s1.dy * s1.dy;
            sumx1cu += s1.dx * s1.dx * s1.dx;
            sumx1sqy1 += s1.dx * s1.dx * s1.dy;
            sumx1y1sq += s1.dx * s1.dy * s1.dy;
            sumy1cu += s1.dy * s1.dy * s1.dy;
            sumx1qu += s1.dx * s1.dx * s1.dx * s1.dx;
            sumx1cuy1 += s1.dx * s1.dx * s1.dx * s1.dy;
            sumx1sqy1sq += s1.dx * s1.dx * s1.dy * s1.dy;
            sumx1y1cu += s1.dx * s1.dy * s1.dy * s1.dy;
            sumy1qu += s1.dy * s1.dy * s1.dy * s1.dy;
            ++i;
        }
        matrix[0][0] = sum;
        matrix[0][1] = sumx1;
        matrix[0][2] = sumy1;
        matrix[0][3] = sumx1sq;
        matrix[0][4] = sumx1y1;
        matrix[0][5] = sumy1sq;
        matrix[1][0] = sumx1;
        matrix[1][1] = sumx1sq;
        matrix[1][2] = sumx1y1;
        matrix[1][3] = sumx1cu;
        matrix[1][4] = sumx1sqy1;
        matrix[1][5] = sumx1y1sq;
        matrix[2][0] = sumy1;
        matrix[2][1] = sumx1y1;
        matrix[2][2] = sumy1sq;
        matrix[2][3] = sumx1sqy1;
        matrix[2][4] = sumx1y1sq;
        matrix[2][5] = sumy1cu;
        matrix[3][0] = sumx1sq;
        matrix[3][1] = sumx1cu;
        matrix[3][2] = sumx1sqy1;
        matrix[3][3] = sumx1qu;
        matrix[3][4] = sumx1cuy1;
        matrix[3][5] = sumx1sqy1sq;
        matrix[4][0] = sumx1y1;
        matrix[4][1] = sumx1sqy1;
        matrix[4][2] = sumx1y1sq;
        matrix[4][3] = sumx1cuy1;
        matrix[4][4] = sumx1sqy1sq;
        matrix[4][5] = sumx1y1cu;
        matrix[5][0] = sumy1sq;
        matrix[5][1] = sumx1y1sq;
        matrix[5][2] = sumy1cu;
        matrix[5][3] = sumx1sqy1sq;
        matrix[5][4] = sumx1y1cu;
        matrix[5][5] = sumy1qu;
        vector[0] = sumx2;
        vector[1] = sumx2x1;
        vector[2] = sumx2y1;
        vector[3] = sumx2x1sq;
        vector[4] = sumx2x1y1;
        vector[5] = sumx2y1sq;
        this.gaussMatrix(matrix, 6, vector);
        double solved_a = vector[0];
        double solved_b = vector[1];
        double solved_c = vector[2];
        double solved_d = vector[3];
        double solved_e = vector[4];
        double solved_f = vector[5];
        matrix[0][0] = sum;
        matrix[0][1] = sumx1;
        matrix[0][2] = sumy1;
        matrix[0][3] = sumx1sq;
        matrix[0][4] = sumx1y1;
        matrix[0][5] = sumy1sq;
        matrix[1][0] = sumx1;
        matrix[1][1] = sumx1sq;
        matrix[1][2] = sumx1y1;
        matrix[1][3] = sumx1cu;
        matrix[1][4] = sumx1sqy1;
        matrix[1][5] = sumx1y1sq;
        matrix[2][0] = sumy1;
        matrix[2][1] = sumx1y1;
        matrix[2][2] = sumy1sq;
        matrix[2][3] = sumx1sqy1;
        matrix[2][4] = sumx1y1sq;
        matrix[2][5] = sumy1cu;
        matrix[3][0] = sumx1sq;
        matrix[3][1] = sumx1cu;
        matrix[3][2] = sumx1sqy1;
        matrix[3][3] = sumx1qu;
        matrix[3][4] = sumx1cuy1;
        matrix[3][5] = sumx1sqy1sq;
        matrix[4][0] = sumx1y1;
        matrix[4][1] = sumx1sqy1;
        matrix[4][2] = sumx1y1sq;
        matrix[4][3] = sumx1cuy1;
        matrix[4][4] = sumx1sqy1sq;
        matrix[4][5] = sumx1y1cu;
        matrix[5][0] = sumy1sq;
        matrix[5][1] = sumx1y1sq;
        matrix[5][2] = sumy1cu;
        matrix[5][3] = sumx1sqy1sq;
        matrix[5][4] = sumx1y1cu;
        matrix[5][5] = sumy1qu;
        vector[0] = sumy2;
        vector[1] = sumy2x1;
        vector[2] = sumy2y1;
        vector[3] = sumy2x1sq;
        vector[4] = sumy2x1y1;
        vector[5] = sumy2y1sq;
        this.gaussMatrix(matrix, 6, vector);
        double solved_g = vector[0];
        double solved_h = vector[1];
        double solved_i = vector[2];
        double solved_j = vector[3];
        double solved_k = vector[4];
        double solved_l = vector[5];
        trans.a = solved_a;
        trans.b = solved_b;
        trans.c = solved_c;
        trans.d = solved_d;
        trans.e = solved_e;
        trans.f = solved_f;
        trans.g = solved_g;
        trans.h = solved_h;
        trans.i = solved_i;
        trans.j = solved_j;
        trans.k = solved_k;
        trans.l = solved_l;
        return trans;
    }

    private Trans calcTransCubic(int nbright, TopVotes tv) throws MatchException {
        Trans trans = new Trans();
        int startPairs = 16;
        int[] winner_index_A = tv.getWinIdxA();
        int[] winner_index_B = tv.getWinIdxB();
        double[][] matrix = new double[8][8];
        double[] vector = new double[8];
        trans.order = 2;
        double sum = 0.0;
        double sumx1 = 0.0;
        double sumy1 = 0.0;
        double sumx1sq = 0.0;
        double sumx1y1 = 0.0;
        double sumy1sq = 0.0;
        double sumx1cu = 0.0;
        double sumx1sqy1 = 0.0;
        double sumx1y1sq = 0.0;
        double sumy1cu = 0.0;
        double sumx1qu = 0.0;
        double sumx1cuy1 = 0.0;
        double sumx1sqy1sq = 0.0;
        double sumx1y1cu = 0.0;
        double sumy1qu = 0.0;
        double sumx1R = 0.0;
        double sumy1R = 0.0;
        double sumx1sqR = 0.0;
        double sumx1y1R = 0.0;
        double sumy1sqR = 0.0;
        double sumx1cuR = 0.0;
        double sumx1sqy1R = 0.0;
        double sumx1y1sqR = 0.0;
        double sumy1cuR = 0.0;
        double sumx1sqRsq = 0.0;
        double sumx1y1Rsq = 0.0;
        double sumy1sqRsq = 0.0;
        double sumx2 = 0.0;
        double sumx2x1 = 0.0;
        double sumx2y1 = 0.0;
        double sumx2x1sq = 0.0;
        double sumx2x1y1 = 0.0;
        double sumx2y1sq = 0.0;
        double sumx2x1R = 0.0;
        double sumx2y1R = 0.0;
        double sumy2 = 0.0;
        double sumy2x1 = 0.0;
        double sumy2y1 = 0.0;
        double sumy2x1sq = 0.0;
        double sumy2x1y1 = 0.0;
        double sumy2y1sq = 0.0;
        double sumy2x1R = 0.0;
        double sumy2y1R = 0.0;
        int i = 0;
        while (i < nbright) {
            Star s1 = this.saA[winner_index_A[i]];
            Star s2 = this.saB[winner_index_B[i]];
            double R = s1.dx * s1.dx + s1.dy * s1.dy;
            sumx2 += s2.dx;
            sumx2x1 += s2.dx * s1.dx;
            sumx2y1 += s2.dx * s1.dy;
            sumx2x1sq += s2.dx * s1.dx * s1.dx;
            sumx2x1y1 += s2.dx * s1.dx * s1.dy;
            sumx2y1sq += s2.dx * s1.dy * s1.dy;
            sumx2x1R += s2.dx * s1.dx * R;
            sumx2y1R += s2.dx * s1.dy * R;
            sumy2 += s2.dy;
            sumy2x1 += s2.dy * s1.dx;
            sumy2y1 += s2.dy * s1.dy;
            sumy2x1sq += s2.dy * s1.dx * s1.dx;
            sumy2x1y1 += s2.dy * s1.dx * s1.dy;
            sumy2y1sq += s2.dy * s1.dy * s1.dy;
            sumy2x1R += s2.dy * s1.dx * R;
            sumy2y1R += s2.dy * s1.dy * R;
            sum += 1.0;
            sumx1 += s1.dx;
            sumy1 += s1.dy;
            sumx1sq += s1.dx * s1.dx;
            sumx1y1 += s1.dx * s1.dy;
            sumy1sq += s1.dy * s1.dy;
            sumx1cu += s1.dx * s1.dx * s1.dx;
            sumx1sqy1 += s1.dx * s1.dx * s1.dy;
            sumx1y1sq += s1.dx * s1.dy * s1.dy;
            sumy1cu += s1.dy * s1.dy * s1.dy;
            sumx1qu += s1.dx * s1.dx * s1.dx * s1.dx;
            sumx1cuy1 += s1.dx * s1.dx * s1.dx * s1.dy;
            sumx1sqy1sq += s1.dx * s1.dx * s1.dy * s1.dy;
            sumx1y1cu += s1.dx * s1.dy * s1.dy * s1.dy;
            sumy1qu += s1.dy * s1.dy * s1.dy * s1.dy;
            sumx1R += s1.dx * R;
            sumy1R += s1.dy * R;
            sumx1sqR += s1.dx * s1.dx * R;
            sumx1y1R += s1.dx * s1.dy * R;
            sumy1sqR += s1.dy * s1.dy * R;
            sumx1cuR += s1.dx * s1.dx * s1.dx * R;
            sumx1sqy1R += s1.dx * s1.dx * s1.dy * R;
            sumx1y1sqR += s1.dx * s1.dy * s1.dy * R;
            sumy1cuR += s1.dy * s1.dy * s1.dy * R;
            sumx1sqRsq += s1.dx * s1.dx * R * R;
            sumx1y1Rsq += s1.dx * s1.dy * R * R;
            sumy1sqRsq += s1.dy * s1.dy * R * R;
            ++i;
        }
        matrix[0][0] = sum;
        matrix[0][1] = sumx1;
        matrix[0][2] = sumy1;
        matrix[0][3] = sumx1sq;
        matrix[0][4] = sumx1y1;
        matrix[0][5] = sumy1sq;
        matrix[0][6] = sumx1R;
        matrix[0][7] = sumy1R;
        matrix[1][0] = sumx1;
        matrix[1][1] = sumx1sq;
        matrix[1][2] = sumx1y1;
        matrix[1][3] = sumx1cu;
        matrix[1][4] = sumx1sqy1;
        matrix[1][5] = sumx1y1sq;
        matrix[1][6] = sumx1sqR;
        matrix[1][7] = sumx1y1R;
        matrix[2][0] = sumy1;
        matrix[2][1] = sumx1y1;
        matrix[2][2] = sumy1sq;
        matrix[2][3] = sumx1sqy1;
        matrix[2][4] = sumx1y1sq;
        matrix[2][5] = sumy1cu;
        matrix[2][6] = sumx1y1R;
        matrix[2][7] = sumy1sqR;
        matrix[3][0] = sumx1sq;
        matrix[3][1] = sumx1cu;
        matrix[3][2] = sumx1sqy1;
        matrix[3][3] = sumx1qu;
        matrix[3][4] = sumx1cuy1;
        matrix[3][5] = sumx1sqy1sq;
        matrix[3][6] = sumx1cuR;
        matrix[3][7] = sumx1sqy1R;
        matrix[4][0] = sumx1y1;
        matrix[4][1] = sumx1sqy1;
        matrix[4][2] = sumx1y1sq;
        matrix[4][3] = sumx1cuy1;
        matrix[4][4] = sumx1sqy1sq;
        matrix[4][5] = sumx1y1cu;
        matrix[4][6] = sumx1sqy1R;
        matrix[4][7] = sumx1y1sqR;
        matrix[5][0] = sumy1sq;
        matrix[5][1] = sumx1y1sq;
        matrix[5][2] = sumy1cu;
        matrix[5][3] = sumx1sqy1sq;
        matrix[5][4] = sumx1y1cu;
        matrix[5][5] = sumy1qu;
        matrix[5][6] = sumx1y1sqR;
        matrix[5][7] = sumy1cuR;
        matrix[6][0] = sumx1R;
        matrix[6][1] = sumx1sqR;
        matrix[6][2] = sumx1y1R;
        matrix[6][3] = sumx1cuR;
        matrix[6][4] = sumx1sqy1R;
        matrix[6][5] = sumx1y1sqR;
        matrix[6][6] = sumx1sqRsq;
        matrix[6][7] = sumx1y1Rsq;
        matrix[7][0] = sumy1R;
        matrix[7][1] = sumx1y1R;
        matrix[7][2] = sumy1sqR;
        matrix[7][3] = sumx1sqy1R;
        matrix[7][4] = sumx1y1sqR;
        matrix[7][5] = sumy1cuR;
        matrix[7][6] = sumx1y1Rsq;
        matrix[7][7] = sumy1sqRsq;
        vector[0] = sumx2;
        vector[1] = sumx2x1;
        vector[2] = sumx2y1;
        vector[3] = sumx2x1sq;
        vector[4] = sumx2x1y1;
        vector[5] = sumx2y1sq;
        vector[6] = sumx2x1R;
        vector[7] = sumx2y1R;
        this.gaussMatrix(matrix, 8, vector);
        double solved_a = vector[0];
        double solved_b = vector[1];
        double solved_c = vector[2];
        double solved_d = vector[3];
        double solved_e = vector[4];
        double solved_f = vector[5];
        double solved_g = vector[6];
        double solved_h = vector[7];
        matrix[0][0] = sum;
        matrix[0][1] = sumx1;
        matrix[0][2] = sumy1;
        matrix[0][3] = sumx1sq;
        matrix[0][4] = sumx1y1;
        matrix[0][5] = sumy1sq;
        matrix[0][6] = sumx1R;
        matrix[0][7] = sumy1R;
        matrix[1][0] = sumx1;
        matrix[1][1] = sumx1sq;
        matrix[1][2] = sumx1y1;
        matrix[1][3] = sumx1cu;
        matrix[1][4] = sumx1sqy1;
        matrix[1][5] = sumx1y1sq;
        matrix[1][6] = sumx1sqR;
        matrix[1][7] = sumx1y1R;
        matrix[2][0] = sumy1;
        matrix[2][1] = sumx1y1;
        matrix[2][2] = sumy1sq;
        matrix[2][3] = sumx1sqy1;
        matrix[2][4] = sumx1y1sq;
        matrix[2][5] = sumy1cu;
        matrix[2][6] = sumx1y1R;
        matrix[2][7] = sumy1sqR;
        matrix[3][0] = sumx1sq;
        matrix[3][1] = sumx1cu;
        matrix[3][2] = sumx1sqy1;
        matrix[3][3] = sumx1qu;
        matrix[3][4] = sumx1cuy1;
        matrix[3][5] = sumx1sqy1sq;
        matrix[3][6] = sumx1cuR;
        matrix[3][7] = sumx1sqy1R;
        matrix[4][0] = sumx1y1;
        matrix[4][1] = sumx1sqy1;
        matrix[4][2] = sumx1y1sq;
        matrix[4][3] = sumx1cuy1;
        matrix[4][4] = sumx1sqy1sq;
        matrix[4][5] = sumx1y1cu;
        matrix[4][6] = sumx1sqy1R;
        matrix[4][7] = sumx1y1sqR;
        matrix[5][0] = sumy1sq;
        matrix[5][1] = sumx1y1sq;
        matrix[5][2] = sumy1cu;
        matrix[5][3] = sumx1sqy1sq;
        matrix[5][4] = sumx1y1cu;
        matrix[5][5] = sumy1qu;
        matrix[5][6] = sumx1y1sqR;
        matrix[5][7] = sumy1cuR;
        matrix[6][0] = sumx1R;
        matrix[6][1] = sumx1sqR;
        matrix[6][2] = sumx1y1R;
        matrix[6][3] = sumx1cuR;
        matrix[6][4] = sumx1sqy1R;
        matrix[6][5] = sumx1y1sqR;
        matrix[6][6] = sumx1sqRsq;
        matrix[6][7] = sumx1y1Rsq;
        matrix[7][0] = sumy1R;
        matrix[7][1] = sumx1y1R;
        matrix[7][2] = sumy1sqR;
        matrix[7][3] = sumx1sqy1R;
        matrix[7][4] = sumx1y1sqR;
        matrix[7][5] = sumy1cuR;
        matrix[7][6] = sumx1y1Rsq;
        matrix[7][7] = sumy1sqRsq;
        vector[0] = sumy2;
        vector[1] = sumy2x1;
        vector[2] = sumy2y1;
        vector[3] = sumy2x1sq;
        vector[4] = sumy2x1y1;
        vector[5] = sumy2y1sq;
        vector[6] = sumy2x1R;
        vector[7] = sumy2y1R;
        this.gaussMatrix(matrix, 8, vector);
        double solved_i = vector[0];
        double solved_j = vector[1];
        double solved_k = vector[2];
        double solved_l = vector[3];
        double solved_m = vector[4];
        double solved_n = vector[5];
        double solved_o = vector[6];
        double solved_p = vector[7];
        trans.a = solved_a;
        trans.b = solved_b;
        trans.c = solved_c;
        trans.d = solved_d;
        trans.e = solved_e;
        trans.f = solved_f;
        trans.g = solved_g;
        trans.h = solved_h;
        trans.i = solved_i;
        trans.j = solved_j;
        trans.k = solved_k;
        trans.l = solved_l;
        trans.m = solved_m;
        trans.n = solved_n;
        trans.o = solved_o;
        trans.p = solved_p;
        return trans;
    }

    private void gaussMatrix(double[][] matrix, int num, double[] vector) throws MatchException {
        int j;
        double[] biggest_val = new double[num];
        double[] solution_vector = new double[num];
        int i = 0;
        while (i < num) {
            biggest_val[i] = Math.abs(matrix[i][0]);
            j = 1;
            while (j < num) {
                if (Math.abs(matrix[i][j]) > biggest_val[i]) {
                    biggest_val[i] = Math.abs(matrix[i][j]);
                }
                ++j;
            }
            if (biggest_val[i] == 0.0) {
                throw new MatchException("gauss_matrix: biggest val in row " + i + " is zero.");
            }
            ++i;
        }
        i = 0;
        while (i < num - 1) {
            this.gauss_pivot(matrix, num, vector, biggest_val, i);
            if (Math.abs(matrix[i][i] / biggest_val[i]) < this.regPar.getMatrixTolerance()) {
                SLogger.debug("gauss_matrix: Y: row  has tiny value.");
                throw new MatchException("gauss_matrix: Y: row  has tiny value.");
            }
            j = i + 1;
            while (j < num) {
                double factor = matrix[j][i] / matrix[i][i];
                int k = i + 1;
                while (k < num) {
                    double[] dArray = matrix[j];
                    int n = k;
                    dArray[n] = dArray[n] - factor * matrix[i][k];
                    ++k;
                }
                int n = j++;
                vector[n] = vector[n] - factor * vector[i];
            }
            ++i;
        }
        if (Math.abs(matrix[num - 1][num - 1] / biggest_val[num - 1]) < this.regPar.getMatrixTolerance()) {
            SLogger.debug("gauss_matrix: Z: row " + num + " has tiny value " + matrix[num - 1][num - 1] + " / " + biggest_val[num - 1]);
            throw new MatchException("gauss_matrix: Z: row " + num + " has tiny value " + matrix[num - 1][num - 1] + " / " + biggest_val[num - 1]);
        }
        solution_vector[num - 1] = vector[num - 1] / matrix[num - 1][num - 1];
        i = num - 2;
        while (i >= 0) {
            double sum = 0.0;
            j = i + 1;
            while (j < num) {
                sum += matrix[i][j] * solution_vector[j];
                ++j;
            }
            solution_vector[i] = (vector[i] - sum) / matrix[i][i];
            --i;
        }
        i = 0;
        while (i < num) {
            vector[i] = solution_vector[i];
            ++i;
        }
    }

    private void gauss_pivot(double[][] matrix, int num, double[] vector, double[] biggest_val, int row) {
        int pivot_row = row;
        double big = Math.abs(matrix[row][row] / biggest_val[row]);
        int i = row + 1;
        while (i < num) {
            double other_big = Math.abs(matrix[i][row] / biggest_val[i]);
            if (other_big > big) {
                big = other_big;
                pivot_row = i;
            }
            ++i;
        }
        if (pivot_row != row) {
            double tmp;
            int col = row;
            while (col < num) {
                tmp = matrix[pivot_row][col];
                matrix[pivot_row][col] = matrix[row][col];
                matrix[row][col] = tmp;
                ++col;
            }
            tmp = vector[pivot_row];
            vector[pivot_row] = vector[row];
            vector[row] = tmp;
            tmp = biggest_val[pivot_row];
            biggest_val[pivot_row] = biggest_val[row];
            biggest_val[row] = tmp;
        }
    }

    private StarTriangle[] starsToCloseTriangles(Star[] sa1) {
        Vector v = new Vector();
        StarTriangle st = null;
        Star aStar = new Star();
        aStar.setSortCriteria(2);
        Arrays.sort(sa1, aStar);
        int i = 0;
        while (i < sa1.length / 2) {
            aStar = sa1[i];
            sa1[i] = sa1[sa1.length - 1 - i];
            sa1[i].index = i;
            sa1[sa1.length - 1 - i] = aStar;
            sa1[sa1.length - 1 - i].index = sa1.length - 1 - i;
            ++i;
        }
        int maxLoopIdx = this.regPar.getMaxNumStars();
        int maxIdx = Math.min(sa1.length - 3, maxLoopIdx);
        Object[] tSpace = new StarTriangle[maxIdx];
        i = 0;
        while (i < maxIdx) {
            try {
                st = this.getCloseStarTriangle(i, sa1);
                tSpace[i] = st;
            }
            catch (NoTriangleException e) {
                SLogger.debug("NoTriangleException.");
            }
            ++i;
        }
        Arrays.sort(tSpace);
        return tSpace;
    }

    public void verifyMatches(Vector v1, Vector v2) {
        double avgScaleFactor = 0.0;
        double medianScaleFactor = 0.0;
        double medianAngle = 0.0;
        int vecSize = v1.size();
        int i = 0;
        SLogger.debug("Verifying Matches...");
        try {
            StarTriangle b2m1;
            StarTriangle b1m1;
            i = 0;
            while (i < vecSize) {
                b1m1 = (StarTriangle)v1.elementAt(i);
                b2m1 = (StarTriangle)v2.elementAt(i);
                if (b1m1.xt < 0.9 && b2m1.xt < 0.9) {
                    b1m1.setVerified(true);
                    b2m1.setVerified(true);
                }
                ++i;
            }
            this.removeInvalidMatches(v1);
            this.removeInvalidMatches(v2);
            vecSize = v1.size();
            if (this.regPar.getSameScale()) {
                medianScaleFactor = 1.0;
            } else {
                medianScaleFactor = this.calcMedianScaleFactor(v1, v2);
                SLogger.debug("medianScaleFactor=" + medianScaleFactor);
            }
            i = 0;
            while (i < vecSize) {
                b1m1 = (StarTriangle)v1.elementAt(i);
                b2m1 = (StarTriangle)v2.elementAt(i);
                double dist1 = b1m1.s2.calcDistance(b1m1.s3);
                double dist2 = b2m1.s2.calcDistance(b2m1.s3);
                double scaleFactor = dist1 / dist2;
                if (this.regPar.getSameScale()) {
                    medianScaleFactor = 1.0;
                }
                if (Math.abs(medianScaleFactor - scaleFactor) > medianScaleFactor / 50.0) {
                    b1m1.setVerified(false);
                    b2m1.setVerified(false);
                    SLogger.debug("Verify failed i=" + i);
                } else {
                    b1m1.setVerified(true);
                    b2m1.setVerified(true);
                    SLogger.debug("Verify ok i=" + i);
                }
                ++i;
            }
            this.removeInvalidMatches(v1);
            this.removeInvalidMatches(v2);
            vecSize = v1.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            SLogger.debug("vecsize = " + vecSize + ", i = " + i);
        }
    }

    private double calcMedianScaleFactor(Vector v1, Vector v2) {
        int vecSize = v1.size();
        double[] sf = new double[vecSize];
        int i = 0;
        while (i < vecSize) {
            StarTriangle b1m1 = (StarTriangle)v1.elementAt(i);
            StarTriangle b2m1 = (StarTriangle)v2.elementAt(i);
            double dist1 = b1m1.s2.calcDistance(b1m1.s3);
            double dist2 = b2m1.s2.calcDistance(b2m1.s3);
            sf[i] = dist1 / dist2;
            ++i;
        }
        Arrays.sort(sf);
        double medianScaleFactor = this.calcMedian(sf);
        return medianScaleFactor;
    }

    private double calcMedian(double[] ar) {
        int len = ar.length;
        boolean oddIndices = len / 2 * 2 != len;
        int medIndex = len / 2;
        if (len == 2) {
            medIndex = 0;
        }
        if (len == 1) {
            medIndex = 0;
        }
        if (len == 0) {
            return Double.NaN;
        }
        double median = oddIndices ? ar[medIndex] : (ar[medIndex] + ar[medIndex + 1]) / 2.0;
        return median;
    }

    private Vector starsToTriangles(Star[] sa1) {
        Vector<StarTriangle> v = new Vector<StarTriangle>();
        Star aStar = new Star();
        aStar.setSortCriteria(2);
        Arrays.sort(sa1, aStar);
        int i = 0;
        while (i < sa1.length / 2) {
            aStar = sa1[i];
            sa1[i] = sa1[sa1.length - 1 - i];
            sa1[i].index = i;
            sa1[sa1.length - 1 - i] = aStar;
            sa1[sa1.length - 1 - i].index = sa1.length - 1 - i;
            ++i;
        }
        int num = sa1.length > this.numstars ? this.numstars : sa1.length;
        int num1 = num - 1;
        int num2 = num - 2;
        int idcount = 0;
        try {
            i = 0;
            while (i < num2) {
                int j = i + 1;
                while (j < num1) {
                    int k = j + 1;
                    while (k < num) {
                        StarTriangle st = new StarTriangle(sa1[i], i, sa1[j], j, sa1[k], k);
                        st.id = idcount++;
                        v.addElement(st);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (NoTriangleException e) {
            SLogger.debug("NoTriangleException");
        }
        return v;
    }

    private StarTriangle getCloseStarTriangle(int sIdx, Star[] ar) throws NoTriangleException {
        double closest = Double.MAX_VALUE;
        double secondclosest = Double.MAX_VALUE;
        int closestIdx = 0;
        int secondIdx = 0;
        int hI = this.regPar.getHalfIntervall();
        int startIdx = sIdx - hI < 0 ? 0 : sIdx - hI;
        int endIdx = sIdx + hI >= ar.length ? ar.length - 1 : sIdx + hI;
        int i = startIdx;
        while (i < endIdx) {
            double curDist = ar[sIdx].calcDistance(ar[i]);
            if (curDist <= closest && i != sIdx) {
                secondIdx = closestIdx;
                secondclosest = closest;
                closestIdx = i;
                closest = curDist;
            } else if (curDist <= secondclosest && i != sIdx) {
                secondIdx = i;
                secondclosest = curDist;
            }
            ++i;
        }
        return new StarTriangle(ar[sIdx], sIdx, ar[closestIdx], closestIdx, ar[secondIdx], secondIdx);
    }

    public void removeInvalidMatches(Vector v) {
        int i = 0;
        SLogger.debug("removing invalid matches...");
        while (i < v.size()) {
            if (!((StarTriangle)v.elementAt(i)).isVerified()) {
                v.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    private StarTriangle[] verifyTriangles(Vector v) {
        double matchRatio = RegParams.instance().getMatchRatio();
        SLogger.debug("verifyTriangles start, size " + v.size());
        int i = 0;
        while (i < v.size()) {
            StarTriangle aST = (StarTriangle)v.elementAt(i);
            if (aST.ba > matchRatio) {
                v.removeElementAt(i);
                continue;
            }
            ++i;
        }
        StarTriangle[] ts = new StarTriangle[v.size()];
        i = 0;
        while (i < v.size()) {
            ts[i] = (StarTriangle)v.elementAt(i);
            ++i;
        }
        Arrays.sort(ts, ts[0]);
        SLogger.debug("verifyTriangles end, size " + v.size());
        return ts;
    }

    private int[][] makeVoteMatrix(Star[] sa1, Star[] sa2, StarTriangle[] st1, StarTriangle[] st2) {
        int j;
        boolean sameScaleSet = this.regPar.getSameScale();
        int n = sa1.length > sa2.length ? sa2.length : sa1.length;
        n = n < this.numstars ? n : this.numstars;
        int[][] vm = new int[n][n];
        double max_radius = this.regPar.getTriangleRadius();
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                vm[i][j] = 0;
                ++j;
            }
            ++i;
        }
        double rad2 = max_radius * max_radius;
        j = 0;
        while (j < st2.length) {
            StarTriangle tri = st2[j];
            if (tri.a_index < n && tri.b_index < n && tri.c_index < n) {
                int start_index;
                double ba_B = st2[j].ba;
                double ca_B = st2[j].ca;
                double ba_min = ba_B - max_radius;
                double ba_max = ba_B + max_radius;
                double max_scale = -1.0;
                double min_scale = -1.0;
                if (sameScaleSet) {
                    min_scale = 0.95;
                    max_scale = 1.05;
                }
                i = start_index = this.find_ba_triangle(st1, ba_min);
                while (i < st1.length) {
                    tri = st1[i];
                    if (tri.a_index < n && tri.b_index < n && tri.c_index < n) {
                        double ratio;
                        double ba_A = st1[i].ba;
                        double ca_A = st1[i].ca;
                        if (ba_A > ba_max) break;
                        if ((ba_A - ba_B) * (ba_A - ba_B) + (ca_A - ca_B) * (ca_A - ca_B) < rad2 && (min_scale == -1.0 || !((ratio = st1[i].a_length / st2[j].a_length) < min_scale) && !(ratio > max_scale))) {
                            int[] nArray = vm[st1[i].a_index];
                            int n2 = st2[j].a_index;
                            nArray[n2] = nArray[n2] + 1;
                            int[] nArray2 = vm[st1[i].b_index];
                            int n3 = st2[j].b_index;
                            nArray2[n3] = nArray2[n3] + 1;
                            int[] nArray3 = vm[st1[i].c_index];
                            int n4 = st2[j].c_index;
                            nArray3[n4] = nArray3[n4] + 1;
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        return vm;
    }

    private int find_ba_triangle(StarTriangle[] array, double ba0) {
        int num = array.length;
        int top = 0;
        int bottom = num - 1;
        if (bottom < 0) {
            bottom = 0;
        }
        while (bottom - top > 2) {
            int mid = (top + bottom) / 2;
            if (array[mid].ba < ba0) {
                top = mid;
                continue;
            }
            bottom = mid;
        }
        if (array[top].ba < ba0) {
            return bottom;
        }
        return top;
    }

    private double[][] calc_dist(Star[] sa) {
        int numstars = sa.length;
        double[][] m = new double[numstars][numstars];
        int i = 0;
        while (i < numstars - 1) {
            int j = i + 1;
            while (j < numstars) {
                double dist;
                m[i][j] = dist = sa[i].calcDistance(sa[j]);
                m[j][i] = dist;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numstars) {
            m[i][i] = 0.0;
            ++i;
        }
        return m;
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRecalc() {
        return this.recalc;
    }

    public void setRecalc(boolean recalc) {
        this.recalc = recalc;
    }

    public int getMaxiterations() {
        return this.maxiterations;
    }

    public void setMaxiterations(int maxiterations) {
        this.maxiterations = maxiterations;
    }

    public Bild getBild1() {
        return this.bild1;
    }

    public void setBild1(Bild bild1) {
        this.bild1 = bild1;
    }

    public Bild getBild2() {
        return this.bild2;
    }

    public void setBild2(Bild bild2) {
        this.bild2 = bild2;
    }
}

