/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.match;

import de.andreasroerig.bild.NoTriangleException;
import de.andreasroerig.match.RegParams;
import de.andreasroerig.match.Star;
import de.andreasroerig.util.SLogger;
import java.util.Arrays;
import java.util.Comparator;

public class StarTriangle
implements Comparable,
Comparator {
    protected Star s1;
    protected Star s2;
    protected Star s3;
    protected double as1s2;
    protected double as1s3;
    protected double as2s3;
    protected double ds1s2;
    protected double ds1s3;
    protected double ds2s3;
    protected double xt;
    protected double yt;
    protected double tsDistance;
    protected double ad;
    private double aT;
    private double vhT;
    private double vhbT;
    private boolean verified;
    protected int id;
    protected int index;
    protected double a_length;
    protected double ba;
    protected double ca;
    protected int a_index;
    protected int b_index;
    protected int c_index;
    protected int match_id;

    public StarTriangle() {
        RegParams theParams = RegParams.instance();
        this.aT = theParams.getAngleTolerance();
        this.vhT = theParams.getDistanceRatioTolerance();
        this.vhbT = theParams.getBrightnessRatioTolerance();
        this.tsDistance = 0.0;
        this.verified = false;
    }

    public StarTriangle(StarTriangle st) {
        this();
        this.s1 = st.s1;
        this.s2 = st.s2;
        this.s3 = st.s3;
        this.ds1s2 = st.ds1s2;
        this.ds1s3 = st.ds1s3;
        this.ds2s3 = st.ds2s3;
        this.as1s2 = st.as1s2;
        this.as1s3 = st.as1s3;
        this.as2s3 = st.as2s3;
        this.verified = st.verified;
        this.ad = st.ad;
        this.xt = st.xt;
        this.yt = st.yt;
        this.tsDistance = st.tsDistance;
    }

    public StarTriangle(Star st1, int i1, Star st2, int i2, Star st3, int i3) throws NoTriangleException {
        this();
        double[] sides = new double[3];
        this.s1 = st1;
        this.s2 = st2;
        this.s3 = st3;
        this.a_index = i1;
        this.b_index = i2;
        this.c_index = i3;
        this.match_id = -1;
        this.ds1s2 = st1.calcDistance(this.s2);
        if (this.ds1s2 == 0.0) {
            throw new NoTriangleException();
        }
        this.ds1s3 = st1.calcDistance(this.s3);
        if (this.ds1s3 == 0.0) {
            throw new NoTriangleException();
        }
        this.ds2s3 = st2.calcDistance(this.s3);
        if (this.ds2s3 == 0.0) {
            throw new NoTriangleException();
        }
        sides[0] = this.ds1s2;
        sides[1] = this.ds1s3;
        sides[2] = this.ds2s3;
        Arrays.sort(sides);
        this.xt = sides[1] / sides[2];
        this.yt = sides[0] / sides[2];
        this.a_length = sides[2];
        this.ba = sides[1] / this.a_length;
        this.ca = sides[0] / this.a_length;
        if (sides[2] == this.ds1s2) {
            this.s1 = st3;
            this.a_index = i3;
        }
        if (sides[2] == this.ds1s3) {
            this.s1 = st2;
            this.a_index = i2;
        }
        if (sides[2] == this.ds2s3) {
            this.s1 = st1;
            this.a_index = i1;
        }
        if (sides[1] == this.ds1s2) {
            this.s2 = st3;
            this.b_index = i3;
        }
        if (sides[1] == this.ds1s3) {
            this.s2 = st2;
            this.b_index = i2;
        }
        if (sides[1] == this.ds2s3) {
            this.s2 = st1;
            this.b_index = i1;
        }
        if (sides[0] == this.ds1s2) {
            this.s3 = st3;
            this.c_index = i3;
        }
        if (sides[0] == this.ds1s3) {
            this.s3 = st2;
            this.c_index = i2;
        }
        if (sides[0] == this.ds2s3) {
            this.s3 = st1;
            this.c_index = i1;
        }
        this.ds1s2 = sides[0];
        this.ds1s3 = sides[1];
        this.ds2s3 = sides[2];
        this.as1s2 = this.calcAngle(this.ds1s2, this.ds1s3, this.ds2s3);
        this.as1s3 = this.calcAngle(this.ds1s3, this.ds2s3, this.ds1s2);
        this.as2s3 = this.calcAngle(this.ds2s3, this.ds1s2, this.ds1s3);
    }

    public StarTriangle(Star st1, Star st2, Star st3) throws NoTriangleException {
        this();
        double[] sides = new double[3];
        this.s1 = st1;
        this.s2 = st2;
        this.s3 = st3;
        this.match_id = -1;
        this.ds1s2 = st1.calcDistance(this.s2);
        if (this.ds1s2 == 0.0) {
            throw new NoTriangleException();
        }
        this.ds1s3 = st1.calcDistance(this.s3);
        if (this.ds1s3 == 0.0) {
            throw new NoTriangleException();
        }
        this.ds2s3 = st2.calcDistance(this.s3);
        if (this.ds2s3 == 0.0) {
            throw new NoTriangleException();
        }
        sides[0] = this.ds1s2;
        sides[1] = this.ds1s3;
        sides[2] = this.ds2s3;
        Arrays.sort(sides);
        this.xt = sides[1] / sides[2];
        this.yt = sides[0] / sides[2];
        this.a_length = sides[2];
        this.ba = sides[1] / this.a_length;
        this.ca = sides[0] / this.a_length;
        if (sides[2] == this.ds1s2) {
            this.s1 = st3;
        }
        if (sides[2] == this.ds1s3) {
            this.s1 = st2;
        }
        if (sides[2] == this.ds2s3) {
            this.s1 = st1;
        }
        if (sides[1] == this.ds1s2) {
            this.s2 = st3;
        }
        if (sides[1] == this.ds1s3) {
            this.s2 = st2;
        }
        if (sides[1] == this.ds2s3) {
            this.s2 = st1;
        }
        if (sides[0] == this.ds1s2) {
            this.s3 = st3;
        }
        if (sides[0] == this.ds1s3) {
            this.s3 = st2;
        }
        if (sides[0] == this.ds2s3) {
            this.s3 = st1;
        }
        this.ds1s2 = sides[0];
        this.ds1s3 = sides[1];
        this.ds2s3 = sides[2];
        this.as1s2 = this.calcAngle(this.ds1s2, this.ds1s3, this.ds2s3);
        this.as1s3 = this.calcAngle(this.ds1s3, this.ds2s3, this.ds1s2);
        this.as2s3 = this.calcAngle(this.ds2s3, this.ds1s2, this.ds1s3);
    }

    public int compare(Object a, Object b) {
        boolean erg = false;
        StarTriangle as = (StarTriangle)a;
        StarTriangle bs = (StarTriangle)b;
        if (as.ba > bs.ba) {
            return 1;
        }
        if (as.ba < bs.ba) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        StarTriangle t = (StarTriangle)o;
        if (this.ba > t.ba) {
            return 1;
        }
        if (this.ba < t.ba) {
            return -1;
        }
        return 0;
    }

    protected double calcAngle(double a, double b, double c) {
        double cosine = (Math.pow(b, 2.0) + Math.pow(c, 2.0) - Math.pow(a, 2.0)) / (2.0 * b * c);
        return Math.toDegrees(Math.acos(cosine));
    }

    public boolean isFlat() {
        if (this.as1s2 < 1.0) {
            return true;
        }
        if (this.as1s3 < 1.0) {
            return true;
        }
        return this.as2s3 < 1.0;
    }

    public boolean equals(StarTriangle st) {
        double vh2;
        double vh1;
        if (st == null) {
            return false;
        }
        if (Math.abs(this.as1s2 - st.as1s2) < this.aT && Math.abs(this.as1s3 - st.as1s3) < this.aT && Math.abs(this.as2s3 - st.as2s3) < this.aT && Math.abs((vh1 = this.ds1s2 / this.ds1s3) - (vh2 = st.ds1s2 / st.ds1s3)) < this.vhT) {
            SLogger.debug("VH: " + vh1 + " : " + vh2);
            vh1 = this.ds1s2 / this.ds2s3;
            vh2 = st.ds1s2 / st.ds2s3;
            if (Math.abs(vh1 - vh2) < this.vhT) {
                SLogger.debug("VH: " + vh1 + " : " + vh2);
                vh1 = this.ds1s3 / this.ds2s3;
                vh2 = st.ds1s3 / st.ds2s3;
                if (Math.abs(vh1 - vh2) < this.vhT) {
                    SLogger.debug("VH: " + vh1 + " : " + vh2);
                    this.setAd(Math.abs(this.as1s2 - st.as1s2));
                    st.setAd(this.ad);
                    return true;
                }
            }
        }
        return false;
    }

    public void debug() {
        SLogger.debug(this.verified + " alpha: " + this.as1s2 + " beta:  " + this.as1s3 + " gamma: " + this.as2s3 + " S1x:" + this.s1.getX() + " S1y:" + this.s1.getY());
    }

    public Star getS1() {
        return this.s1;
    }

    public void setS1(Star s1) {
        this.s1 = s1;
    }

    public Star getS2() {
        return this.s2;
    }

    public void setS2(Star s2) {
        this.s2 = s2;
    }

    public Star getS3() {
        return this.s3;
    }

    public void setS3(Star s3) {
        this.s3 = s3;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public double getAd() {
        return this.ad;
    }

    public void setAd(double ad) {
        this.ad = ad;
    }

    public double getTsDistance() {
        return this.tsDistance;
    }

    public void setTsDistance(double tsDistance) {
        this.tsDistance = tsDistance;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

