/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.tiff;

import de.andreasroerig.bild.BWBild;
import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.RGBBild;
import de.andreasroerig.tiff.TiffReader;
import de.andreasroerig.util.SLogger;
import java.io.IOException;
import java.util.Vector;

public class CrwReader
extends TiffReader {
    private int imgType;
    private int compression;
    private int photometric;
    private int rowsPerStrip;
    private int sampPerPix;
    private int bytesPerRow;
    private int tmpRowCount;
    private int tmpOffsetCount;
    private int tmpLenCount;
    protected long valueDataStart;
    protected long valueDataSize;
    protected int dirCount;
    protected long table;
    protected boolean lowBits;
    protected Vector vDirEntries;
    private int[][] r;
    private int[][] g;
    private int[][] b;

    public static void main(String[] args) {
        try {
            CrwReader reader = new CrwReader("test.crw");
            reader.readTiffHeader();
            reader.readIfd();
        }
        catch (Exception e) {
            System.out.println("Fehler");
            e.printStackTrace();
        }
    }

    public CrwReader(String fname) throws IOException {
        super(fname);
    }

    public void readFromTiff() throws IOException {
        this.readTiffHeader();
        this.readIfd();
        this.readTiffStrips();
        this.ras.close();
    }

    public Bild readBildFromTiff() throws IOException {
        Bild theBild = null;
        this.readFromTiff();
        switch (this.imgType) {
            case 1: {
                theBild = new BWBild(this);
                break;
            }
            case 0: {
                theBild = new RGBBild(this);
                break;
            }
            default: {
                throw new IOException("Unknown image type");
            }
        }
        return theBild;
    }

    public void readTiffHeader() throws IOException {
        byte[] bar = new byte[5];
        int[] theBytes = new int[5];
        this.ras.read(bar, 0, 2);
        if (bar[0] == 73 && bar[1] == 73) {
            this.bigEnd = false;
        } else if (bar[0] == 77 && bar[1] == 77) {
            this.bigEnd = true;
        } else {
            throw new IOException("Invalid TIFF byte order specification.");
        }
        int i = 0;
        while (i < 4) {
            theBytes[i] = this.ras.read();
            ++i;
        }
        this.valueDataStart = this.calcInt32(theBytes);
        SLogger.debug("ValueDataStart = " + this.valueDataStart);
        i = 0;
        while (i < 8) {
            char c = (char)this.ras.read();
            System.out.print(c);
            ++i;
        }
        System.out.println();
    }

    public void readRoot() {
    }

    protected boolean canon_has_lowbits() throws IOException {
        int[] test = new int[16384];
        boolean res = true;
        this.ras.seek(0L);
        int i = 0;
        while (i < test.length) {
            test[i] = this.ras.read();
            ++i;
        }
        i = 540;
        while (i < test.length - 1) {
            if (test[i] == 255) {
                return test[i + 1] != 0;
            }
            ++i;
        }
        return res;
    }

    protected void parseDir(long offset, long length) throws IOException {
        int[] theBytes = new int[5];
        SLogger.debug("offset=" + offset);
        SLogger.debug("lengtht=" + length);
        this.ras.seek(offset + length - 4L);
        int i = 0;
        while (i < 4) {
            theBytes[i] = this.ras.read();
            ++i;
        }
        long tboff = this.calcInt32(theBytes) + offset;
        SLogger.debug("tboff=" + tboff);
        this.ras.seek(tboff);
        i = 0;
        while (i < 2) {
            theBytes[i] = this.ras.read();
            ++i;
        }
        int nrecs = this.calcInt16(theBytes);
        SLogger.debug("nrecs = " + nrecs);
        int j = 0;
        while (j < nrecs) {
            i = 0;
            while (i < 2) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            int type = this.calcInt16(theBytes);
            SLogger.debug("type=" + type);
            i = 0;
            while (i < 4) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            long len = this.calcInt32(theBytes);
            SLogger.debug("len=" + len);
            i = 0;
            while (i < 4) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            long roff = this.calcInt32(theBytes);
            SLogger.debug("roff=" + roff);
            long aoff = offset + roff;
            long save = this.ras.getFilePointer();
            if (type == 2058) {
                this.ras.seek(aoff);
                i = 0;
                while (i < 63) {
                    char c = (char)this.ras.read();
                    System.out.print(c);
                    ++i;
                }
            }
            if (type == 4145) {
                this.ras.seek(aoff + 2L);
                i = 0;
                while (i < 2) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
                this.width = this.calcInt16(theBytes);
                SLogger.debug("width=" + this.width);
                i = 0;
                while (i < 2) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
                this.len = this.calcInt16(theBytes);
                SLogger.debug("image length=" + this.len);
            }
            if (type == 6197) {
                this.ras.seek(aoff);
                i = 0;
                while (i < 4) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
                this.table = this.calcInt32(theBytes);
                SLogger.debug("table=" + this.table);
            }
            if (type >> 8 == 40 || type >> 8 == 48) {
                this.parseDir(aoff, len);
            }
            this.ras.seek(save);
            ++j;
        }
    }

    public void readIfd() throws IOException {
        int[] theBytes = new int[5];
        this.parseDir(this.valueDataStart, this.ras.length() - this.valueDataStart);
        this.lowBits = this.canon_has_lowbits();
        SLogger.debug("lowBits=" + this.lowBits);
    }

    public void readTiffStrips() throws IOException {
        long pixCount = 0L;
        this.r = new int[this.len][this.width];
        if (this.imgType == 0) {
            this.g = new int[this.len][this.width];
            this.b = new int[this.len][this.width];
        }
        byte[] row = new byte[this.bytesPerRow];
        int[] theBytes = new int[5];
        int rowCount = 0;
        int i = 0;
        int k = 0;
        do {
            int j;
            if (rowCount == 0) {
                this.ras.seek(this.stripOffsets[k]);
            }
            this.ras.read(row);
            pixCount += (long)this.bytesPerRow;
            if (this.imgType == 0) {
                j = 0;
                while (j < this.width) {
                    if (this.bitsPerSamp == 16) {
                        theBytes[0] = row[j * 6] < 0 ? 256 + row[j * 6] : row[j * 6];
                        theBytes[1] = row[j * 6 + 1] < 0 ? 256 + row[j * 6 + 1] : row[j * 6 + 1];
                        this.r[i][j] = this.calcInt16(theBytes);
                        theBytes[0] = row[j * 6 + 2] < 0 ? 256 + row[j * 6 + 2] : row[j * 6 + 2];
                        theBytes[1] = row[j * 6 + 3] < 0 ? 256 + row[j * 6 + 3] : row[j * 6 + 3];
                        this.g[i][j] = this.calcInt16(theBytes);
                        theBytes[0] = row[j * 6 + 4] < 0 ? 256 + row[j * 6 + 4] : row[j * 6 + 4];
                        theBytes[1] = row[j * 6 + 5] < 0 ? 256 + row[j * 6 + 5] : row[j * 6 + 5];
                        this.b[i][j] = this.calcInt16(theBytes);
                    }
                    if (this.bitsPerSamp == 8) {
                        this.r[i][j] = row[j * 3] < 0 ? 256 + row[j * 3] : row[j * 3];
                        this.g[i][j] = row[j * 3 + 1] < 0 ? 256 + row[j * 3 + 1] : row[j * 3 + 1];
                        this.b[i][j] = row[j * 3 + 2] < 0 ? 256 + row[j * 3 + 2] : row[j * 3 + 2];
                    }
                    ++j;
                }
            }
            if (this.imgType == 1) {
                j = 0;
                while (j < this.width) {
                    if (this.bitsPerSamp == 16) {
                        theBytes[0] = row[j * 2] < 0 ? 256 + row[j * 2] : row[j * 2];
                        theBytes[1] = row[j * 2 + 1] < 0 ? 256 + row[j * 2 + 1] : row[j * 2 + 1];
                        this.r[i][j] = this.calcInt16(theBytes);
                    }
                    if (this.bitsPerSamp == 8) {
                        this.r[i][j] = row[j] < 0 ? 256 + row[j] : row[j];
                    }
                    ++j;
                }
            }
            ++i;
            if (++rowCount != this.rowsPerStrip) continue;
            rowCount = 0;
            ++k;
        } while (i < this.len);
        SLogger.debug("Anzahl gelesener Pixel: " + pixCount);
    }

    public int[][] readRow() throws IOException {
        int j;
        long pixCount = 0L;
        int[] theBytes = new int[5];
        byte[] row = new byte[this.bytesPerRow];
        int[][] erg = null;
        if (this.tmpLenCount == this.len) {
            return null;
        }
        if (this.tmpRowCount == 0) {
            this.ras.seek(this.stripOffsets[this.tmpOffsetCount]);
        }
        this.ras.read(row);
        pixCount += (long)this.bytesPerRow;
        if (this.imgType == 0) {
            erg = new int[this.width][3];
            j = 0;
            while (j < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes[0] = row[j * 6] < 0 ? 256 + row[j * 6] : row[j * 6];
                    theBytes[1] = row[j * 6 + 1] < 0 ? 256 + row[j * 6 + 1] : row[j * 6 + 1];
                    erg[j][0] = this.calcInt16(theBytes);
                    theBytes[0] = row[j * 6 + 2] < 0 ? 256 + row[j * 6 + 2] : row[j * 6 + 2];
                    theBytes[1] = row[j * 6 + 3] < 0 ? 256 + row[j * 6 + 3] : row[j * 6 + 3];
                    erg[j][1] = this.calcInt16(theBytes);
                    theBytes[0] = row[j * 6 + 4] < 0 ? 256 + row[j * 6 + 4] : row[j * 6 + 4];
                    theBytes[1] = row[j * 6 + 5] < 0 ? 256 + row[j * 6 + 5] : row[j * 6 + 5];
                    erg[j][2] = this.calcInt16(theBytes);
                }
                if (this.bitsPerSamp == 8) {
                    erg[j][0] = row[j * 3] < 0 ? 256 + row[j * 3] : row[j * 3];
                    erg[j][1] = row[j * 3 + 1] < 0 ? 256 + row[j * 3 + 1] : row[j * 3 + 1];
                    erg[j][2] = row[j * 3 + 2] < 0 ? 256 + row[j * 3 + 2] : row[j * 3 + 2];
                }
                ++j;
            }
        }
        if (this.imgType == 1) {
            erg = new int[this.width][1];
            j = 0;
            while (j < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes[0] = row[j * 2] < 0 ? 256 + row[j * 2] : row[j * 2];
                    theBytes[1] = row[j * 2 + 1] < 0 ? 256 + row[j * 2 + 1] : row[j * 2 + 1];
                    erg[j][0] = this.calcInt16(theBytes);
                }
                if (this.bitsPerSamp == 8) {
                    erg[j][0] = row[j] < 0 ? 256 + row[j] : row[j];
                }
                ++j;
            }
        }
        ++this.tmpLenCount;
        ++this.tmpRowCount;
        if (this.tmpRowCount == this.rowsPerStrip) {
            this.tmpRowCount = 0;
            ++this.tmpOffsetCount;
        }
        return erg;
    }

    public int getImgType() {
        return this.imgType;
    }

    public int calcInt16(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 256 + bytes[1];
        }
        return bytes[1] * 256 + bytes[0];
    }

    public long calcInt32(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 0x1000000 + bytes[1] * 65536 + bytes[2] * 256 + bytes[3];
        }
        return bytes[3] * 0x1000000 + bytes[2] * 65536 + bytes[1] * 256 + bytes[0];
    }

    public int[] getByteArray(long val) {
        int tmp;
        int[] bar = new int[4];
        bar[3] = tmp = (int)(val / 0x1000000L);
        val -= (long)(tmp * 0x1000000);
        bar[2] = tmp = (int)(val / 65536L);
        val -= (long)(tmp * 65536);
        bar[1] = tmp = (int)(val / 256L);
        bar[0] = (int)(val - (long)(tmp * 256));
        return bar;
    }

    public int[] getByteArray(int val) {
        int tmp;
        int[] bar = new int[2];
        bar[1] = tmp = val / 256;
        bar[0] = val - tmp * 256;
        return bar;
    }

    public int[][] getB() {
        return this.b;
    }

    public void setB(int[][] b) {
        this.b = b;
    }

    public int[][] getG() {
        return this.g;
    }

    public void setG(int[][] g) {
        this.g = g;
    }

    public int[][] getR() {
        return this.r;
    }

    public void setR(int[][] r) {
        this.r = r;
    }

    public int[][] getData() {
        return this.r;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getBitsPerSamp() {
        return this.bitsPerSamp;
    }

    public void setBitsPerSamp(int bitsPerSamp) {
        this.bitsPerSamp = bitsPerSamp;
    }

    public int getSampPerPix() {
        return this.sampPerPix;
    }

    public void setSampPerPix(int sampPerPix) {
        this.sampPerPix = sampPerPix;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }
}

