/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.tiff;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TiffOutputStream {
    private FileOutputStream fos;
    private BufferedOutputStream bos;
    private long fp;

    public TiffOutputStream(String fname) throws FileNotFoundException {
        this.fos = new FileOutputStream(fname);
        this.bos = new BufferedOutputStream(this.fos);
        this.fp = 0L;
    }

    public void write(int b) throws IOException {
        this.bos.write(b);
        ++this.fp;
    }

    public void writeByte(int b) throws IOException {
        this.bos.write(b);
        ++this.fp;
    }

    public long getFilePointer() {
        return this.fp;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.fp) {
            long anz = pos - this.fp;
            long i = 0L;
            while (i < anz) {
                this.write(0);
                ++i;
            }
        } else {
            throw new IOException("Backward seek not allowed. fp=" + this.fp + ", pos=" + pos);
        }
    }

    public void close() throws IOException {
        this.bos.close();
        this.fos.close();
    }
}

