/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.util;

import de.andreasroerig.gui.StatusFrame;
import de.andreasroerig.util.Datum;

public class SLogger {
    public static final int DEBUG_LOW = 10;
    public static final int DEBUG_MED = 9;
    public static final int DEBUG_HIGH = 8;
    public static final int MESSAGE = 5;
    public static final int LOG_LOW = 4;
    public static final int LOG_MED = 3;
    public static final int LOG_HIGH = 2;
    public static final int ERROR = 1;
    public static final int FATAL_ERROR = 0;
    public static final int DEBUG_LEVEL = 10;
    public static final int LOG_OFF = -1;
    private static StatusFrame statusFrame;

    public static void msg(int level, String message) {
        if (level <= 10) {
            SLogger.out("(MESSAGE)\t" + message);
        }
    }

    public static void log(int level, String message) {
        if (level <= 10) {
            SLogger.out("(LOG)\t" + message);
        }
    }

    public static void log(String message) {
        SLogger.out("(LOG)\t" + message);
    }

    public static void debug(int level, String message) {
        if (level <= 10) {
            SLogger.out("(DEBUG)\t" + message);
        }
    }

    public static void debug(String message) {
        SLogger.debug(10, message);
    }

    public static void error(Exception e) {
        SLogger.out("(FATAL_ERROR)\t" + e.getMessage());
        StackTraceElement[] te = e.getStackTrace();
        int i = 0;
        while (i < te.length) {
            SLogger.out("(FATAL_ERROR)\t" + te[i].toString());
            ++i;
        }
    }

    public static void error(int level, String message) {
        if (level <= 10) {
            if (level == 1) {
                SLogger.out("(ERROR)\t" + message);
            }
            if (level == 0) {
                SLogger.out("(FATAL_ERROR)\t" + message);
            }
        }
    }

    public static void print(String message) {
        if (statusFrame != null) {
            statusFrame.print(message);
        }
        System.out.print(message);
    }

    public static void println(String message) {
        if (statusFrame != null) {
            statusFrame.println(message);
        }
        System.out.println(message);
    }

    private static void out(String message) {
        if (statusFrame != null) {
            statusFrame.println(String.valueOf(Datum.getDateTime()) + " : " + message);
        }
        System.out.println(String.valueOf(Datum.getDateTime()) + " : " + message);
    }

    public static StatusFrame getStatusFrame() {
        return statusFrame;
    }

    public static void setStatusFrame(StatusFrame statusFrame) {
        SLogger.statusFrame = statusFrame;
    }
}

