/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.BioFileFilter;
import biogenesis.BioXMLParser;
import biogenesis.ColorComboBox;
import biogenesis.Gene;
import biogenesis.GeneticCode;
import biogenesis.LengthSpinner;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.ThetaSpinner;
import biogenesis.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xml.sax.SAXException;

public class LabWindow
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 700L;
    protected MainWindow mainWindow;
    protected List<Gene> genesList;
    protected JButton cancelButton;
    protected JButton okButton;
    protected JPanel genesPanel;
    protected JPanel drawPanel;
    protected JScrollPane genesScroll;
    protected JLabel energyLabel;
    protected JLabel segmentsLabel;
    protected JComboBox symmetryCombo;
    protected JComboBox mirrorCombo;
    protected JComboBox disperseCombo;
    protected int symmetry = 2;
    protected int energy = 40;
    protected int mirror = 0;
    protected boolean disperseChildren = false;

    public LabWindow(MainWindow v, GeneticCode gc) {
        super((Frame)v, Messages.getString("T_GENETIC_LABORATORY"));
        this.init(v, gc);
    }

    public LabWindow(MainWindow v) {
        super((Frame)v, Messages.getString("T_GENETIC_LABORATORY"));
        this.init(v, v.getVisibleWorld().clippedGeneticCode);
    }

    private void init(MainWindow v, GeneticCode gc) {
        this.mainWindow = v;
        this.genesList = new ArrayList<Gene>();
        if (gc != null) {
            this.importGeneticCode(gc);
        }
        this.setDefaultCloseOperation(2);
        this.setComponents();
        this.pack();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabWindow.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LabWindow.this.genesList.size() > 0) {
                    LabWindow.this.mainWindow.getVisibleWorld().setClippedGeneticCode(new GeneticCode(LabWindow.this.genesList, LabWindow.this.symmetry, LabWindow.this.mirror, LabWindow.this.disperseChildren));
                }
                LabWindow.this.dispose();
            }
        });
        this.setVisible(true);
    }

    private void importGeneticCode(GeneticCode g) {
        this.energy = g.getReproduceEnergy();
        this.disperseChildren = g.getDisperseChildren();
        this.mirror = g.getMirror();
        this.symmetry = g.getSymmetry();
        int i = 0;
        while (i < g.getNGenes()) {
            this.genesList.add((Gene)g.getGene(i).clone());
            ++i;
        }
    }

    protected void setComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        generalPanel.add((Component)new JLabel(Messages.getString("T_SEGMENTS"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.segmentsLabel = new JLabel(Integer.toString(this.genesList.size() * this.symmetry));
        generalPanel.add((Component)this.segmentsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        generalPanel.add((Component)new JLabel(Messages.getString("T_ENERGY_TO_REPRODUCE"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.energyLabel = new JLabel(Integer.toString(this.energy));
        generalPanel.add((Component)this.energyLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        generalPanel.add((Component)new JLabel(Messages.getString("T_LIFE_EXPECTANCY"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        JLabel life = new JLabel(Integer.toString(Utils.MAX_AGE));
        generalPanel.add((Component)life, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        generalPanel.add((Component)new JLabel(Messages.getString("T_SYMMETRY"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        String[] symmetryValues = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
        this.symmetryCombo = new JComboBox<String>(symmetryValues);
        this.symmetryCombo.setSelectedItem(Integer.toString(this.symmetry));
        this.symmetryCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    LabWindow.this.symmetry = Integer.parseInt((String)LabWindow.this.symmetryCombo.getSelectedItem());
                    LabWindow.this.energy = 40 + 3 * LabWindow.this.symmetry * LabWindow.this.genesList.size();
                    LabWindow.this.energyLabel.setText(Integer.toString(LabWindow.this.energy));
                    LabWindow.this.segmentsLabel.setText(Integer.toString(LabWindow.this.genesList.size() * LabWindow.this.symmetry));
                    LabWindow.this.drawPanel.repaint();
                }
            }
        });
        generalPanel.add((Component)this.symmetryCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        generalPanel.add((Component)new JLabel(Messages.getString("T_MIRROR"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        String[] noyesValues = new String[]{Messages.getString("T_NO"), Messages.getString("T_YES")};
        this.mirrorCombo = new JComboBox<String>(noyesValues);
        this.mirrorCombo.setSelectedIndex(this.mirror);
        this.mirrorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    LabWindow.this.mirror = LabWindow.this.mirrorCombo.getSelectedIndex();
                    LabWindow.this.drawPanel.repaint();
                }
            }
        });
        generalPanel.add((Component)this.mirrorCombo, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        generalPanel.add((Component)new JLabel(Messages.getString("T_DISPERSE_CHILDREN"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.disperseCombo = new JComboBox<String>(noyesValues);
        this.disperseCombo.setSelectedIndex(!this.disperseChildren ? 0 : 1);
        this.disperseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    LabWindow.this.disperseChildren = LabWindow.this.disperseCombo.getSelectedIndex() != 0;
                }
            }
        });
        generalPanel.add((Component)this.disperseCombo, gridBagConstraints);
        this.getContentPane().add((Component)generalPanel, "North");
        this.genesPanel = new JPanel();
        this.genesScroll = new JScrollPane(this.genesPanel);
        this.genesScroll.setPreferredSize(new Dimension(440, 300));
        this.refreshGenesPanel();
        this.getContentPane().add((Component)this.genesScroll, "West");
        this.drawPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                LabWindow.this.draw(g);
            }
        };
        this.drawPanel.setPreferredSize(new Dimension(200, 200));
        this.drawPanel.setBackground(Color.BLACK);
        this.getContentPane().add((Component)this.drawPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        this.okButton = new JButton(Messages.getString("T_COPY_TO_CLIPBOARD"));
        buttonsPanel.add(this.okButton);
        this.cancelButton = new JButton(Messages.getString("T_CANCEL"));
        buttonsPanel.add(this.cancelButton);
        JButton clearButton = new JButton(Messages.getString("T_CLEAR"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabWindow.this.genesList.clear();
                LabWindow.this.refreshGenesPanel();
            }
        });
        buttonsPanel.add(clearButton);
        JButton importButton = new JButton(Messages.getString("T_IMPORT"));
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = LabWindow.this.mainWindow.getGeneticCodeChooser();
                    chooser.setFileFilter(new BioFileFilter("bgg"));
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        try {
                            BioXMLParser parser = new BioXMLParser();
                            GeneticCode g = parser.parseGeneticCode(chooser.getSelectedFile());
                            LabWindow.this.genesList.clear();
                            LabWindow.this.importGeneticCode(g);
                            LabWindow.this.refreshGenesPanel();
                        }
                        catch (SAXException ex) {
                            System.err.println(ex.getMessage());
                            JOptionPane.showMessageDialog(null, Messages.getString("T_WRONG_FILE_VERSION"), Messages.getString("T_READ_ERROR"), 0);
                        }
                        catch (IOException ex) {
                            System.err.println(ex.getMessage());
                            JOptionPane.showMessageDialog(null, Messages.getString("T_CANT_READ_FILE"), Messages.getString("T_READ_ERROR"), 0);
                        }
                    }
                }
                catch (SecurityException ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
                }
            }
        });
        buttonsPanel.add(importButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().startsWith("c")) {
            int modifiedGene = Integer.parseInt(evt.getActionCommand().substring(1));
            ColorComboBox colorCombo = (ColorComboBox)evt.getSource();
            this.genesList.get(modifiedGene).setColor(colorCombo.getSelectedColor());
            this.drawPanel.repaint();
        }
        if (evt.getActionCommand().equals("add")) {
            Gene gene = new Gene(2.0, 0.0, Color.GREEN);
            this.genesList.add(gene);
            this.refreshGenesPanel();
        }
        if (evt.getActionCommand().startsWith("d")) {
            int deletedGene = Integer.parseInt(evt.getActionCommand().substring(1));
            this.genesList.remove(deletedGene);
            this.refreshGenesPanel();
        }
        if (evt.getActionCommand().startsWith("i")) {
            Gene gene = new Gene(2.0, 0.0, Color.GREEN);
            int insertPosition = Integer.parseInt(evt.getActionCommand().substring(1));
            this.genesList.add(insertPosition, gene);
            this.refreshGenesPanel();
        }
    }

    protected void refreshGenesPanel() {
        this.genesPanel.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.genesPanel.setLayout(gridbag);
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.genesPanel.add((Component)new JLabel(Messages.getString("T_GENE")), constraints);
        constraints.gridx = 2;
        this.genesPanel.add((Component)new JLabel(Messages.getString("T_LENGTH")), constraints);
        constraints.gridx = 3;
        this.genesPanel.add((Component)new JLabel(Messages.getString("T_ROTATION")), constraints);
        constraints.gridx = 4;
        this.genesPanel.add((Component)new JLabel(Messages.getString("T_COLOR2")), constraints);
        Iterator<Gene> it = this.genesList.iterator();
        int i = 0;
        while (it.hasNext()) {
            Gene gene = it.next();
            constraints.gridx = 1;
            constraints.gridy = i + 1;
            JLabel label = new JLabel(String.valueOf(i) + ": ");
            gridbag.setConstraints(label, constraints);
            this.genesPanel.add(label);
            constraints.gridx = 2;
            LengthSpinner lengthSpinner = new LengthSpinner(gene);
            lengthSpinner.addChangeListener(this);
            this.genesPanel.add((Component)lengthSpinner, constraints);
            constraints.gridx = 3;
            ThetaSpinner thetaSpinner = new ThetaSpinner(gene);
            thetaSpinner.addChangeListener(this);
            this.genesPanel.add((Component)thetaSpinner, constraints);
            constraints.gridx = 4;
            ColorComboBox colorCombo = new ColorComboBox(gene.getColor());
            colorCombo.addActionListener(this);
            colorCombo.setActionCommand("c" + i);
            this.genesPanel.add((Component)colorCombo, constraints);
            constraints.gridx = 5;
            JButton insertButton = new JButton(Messages.getString("T_INSERT"));
            insertButton.setActionCommand("i" + i);
            gridbag.setConstraints(insertButton, constraints);
            this.genesPanel.add(insertButton);
            insertButton.addActionListener(this);
            constraints.gridx = 6;
            JButton deleteButton = new JButton(Messages.getString("T_DELETE"));
            deleteButton.setActionCommand("d" + i);
            gridbag.setConstraints(deleteButton, constraints);
            this.genesPanel.add(deleteButton);
            deleteButton.addActionListener(this);
            ++i;
        }
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.gridy = i + 1;
        JButton addButton = new JButton(Messages.getString("T_ADD"));
        addButton.setActionCommand("add");
        gridbag.setConstraints(addButton, constraints);
        this.genesPanel.add(addButton);
        addButton.addActionListener(this);
        this.energy = 40 + 3 * this.symmetry * this.genesList.size();
        this.energyLabel.setText(Integer.toString(this.energy));
        this.segmentsLabel.setText(Integer.toString(this.genesList.size() * this.symmetry));
        this.validate();
        this.repaint();
    }

    protected void draw(Graphics g) {
        GeneticCode code = new GeneticCode(this.genesList, this.symmetry, this.mirror, false);
        code.draw(g, this.drawPanel.getSize().width, this.drawPanel.getSize().height);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        JSpinner spinner;
        if (evt.getSource() instanceof LengthSpinner) {
            spinner = (LengthSpinner)evt.getSource();
            ((LengthSpinner)spinner).getGene().setLength(((LengthSpinner)spinner).getLength());
        }
        if (evt.getSource() instanceof ThetaSpinner) {
            spinner = (ThetaSpinner)evt.getSource();
            ((ThetaSpinner)spinner).getGene().setTheta(((ThetaSpinner)spinner).getTheta());
        }
        this.drawPanel.repaint();
    }
}

