/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch;

import com.sparshui.GestureType;
import javajs.util.Lst;
import javajs.util.P3;
import org.jmol.api.Interface;
import org.jmol.api.JmolTouchSimulatorInterface;
import org.jmol.multitouch.JmolMultiTouchAdapter;
import org.jmol.multitouch.JmolMultiTouchClient;
import org.jmol.util.Logger;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

public class ActionManagerMT
extends ActionManager
implements JmolMultiTouchClient {
    private JmolMultiTouchAdapter adapter;
    private JmolTouchSimulatorInterface simulator;
    private int groupID;
    private int simulationPhase;
    private boolean resetNeeded = true;
    private long lastLogTime = 0L;
    private boolean doneHere;
    public static final int DRAG_GESTURE = 0;
    public static final int MULTI_POINT_DRAG_GESTURE = 1;
    public static final int ROTATE_GESTURE = 2;
    public static final int SPIN_GESTURE = 3;
    public static final int TOUCH_GESTURE = 4;
    public static final int ZOOM_GESTURE = 5;
    public static final int DBLCLK_GESTURE = 6;
    public static final int FLICK_GESTURE = 7;
    public static final int RELATIVE_DRAG_GESTURE = 8;
    public static final int INVALID_GESTURE = 9;
    private static final GestureType TWO_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.TwoPointGesture");
    private static final GestureType SINGLE_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.SinglePointGesture");
    public static final int DRIVER_NONE = -2;
    public static final int SERVICE_LOST = -1;
    public static final int DRAG_EVENT = 0;
    public static final int ROTATE_EVENT = 1;
    public static final int SPIN_EVENT = 2;
    public static final int TOUCH_EVENT = 3;
    public static final int ZOOM_EVENT = 4;
    public static final int DBLCLK_EVENT = 5;
    public static final int FLICK_EVENT = 6;
    public static final int RELATIVE_DRAG_EVENT = 7;
    public static final int CLICK_EVENT = 8;
    private static final String[] eventNames = new String[]{"drag", "rotate", "spin", "touch", "zoom", "double-click", "flick", "relative-drag", "click"};
    public static final int BIRTH = 0;
    public static final int DEATH = 1;
    public static final int MOVE = 2;
    public static final int CLICK = 3;
    boolean mouseDown;

    public void setViewer(Viewer vwr, String commandOptions) {
        boolean isTablet;
        this.isMultiTouch = true;
        super.setViewer(vwr, commandOptions);
        this.mouseWheelFactor = 1.02f;
        boolean isSparsh = commandOptions.indexOf("-multitouch-sparshui") >= 0;
        boolean isSimulated = commandOptions.indexOf("-multitouch-sparshui-simulated") >= 0;
        boolean isJNI = commandOptions.indexOf("-multitouch-jni") >= 0;
        boolean isMP = commandOptions.indexOf("-multitouch-mp") >= 0;
        boolean bl = isTablet = commandOptions.indexOf("-multitouch-tab") >= 0;
        if (isMP || isTablet) {
            this.haveMultiTouchInput = true;
            this.groupID = 0;
        } else {
            this.groupID = (int)(Math.random() * 1.6777215E7) << 4;
        }
        if (isTablet) {
            return;
        }
        String className = isSparsh ? "multitouch.sparshui.JmolSparshClientAdapter" : "multitouch.jni.JmolJniClientAdapter";
        this.adapter = (JmolMultiTouchAdapter)Interface.getOption((String)className, null, null);
        Logger.info((String)("ActionManagerMT SparshUI groupID=" + this.groupID));
        Logger.info((String)("ActionManagerMT adapter = " + this.adapter));
        if (isSparsh) {
            this.startSparshUIService(isSimulated);
        } else if (isJNI) {
            this.adapter.setMultiTouchClient(vwr, this, false);
        }
        this.setBinding(this.b);
    }

    private void startSparshUIService(boolean isSimulated) {
        this.haveMultiTouchInput = false;
        if (this.adapter == null) {
            return;
        }
        if (this.simulator != null) {
            this.simulator.dispose();
            this.simulator = null;
        }
        if (isSimulated) {
            Logger.error((String)"ActionManagerMT -- for now just using touch simulation.\nPress CTRL-LEFT and then draw two traces on the window.");
        }
        this.isMultiTouchClient = this.adapter.setMultiTouchClient(this.vwr, this, isSimulated);
        this.isMultiTouchServer = this.adapter.isServer();
        if (isSimulated) {
            this.simulator = (JmolTouchSimulatorInterface)Interface.getInterface((String)"com.sparshui.inputdevice.JmolTouchSimulator", null, null);
            if (this.simulator != null) {
                Logger.info((String)"ActionManagerMT simulating SparshUI");
                this.simulator.startSimulator(this.vwr.display);
            }
        }
    }

    protected void setBinding(Binding newBinding) {
        this.b = newBinding;
        this.b.unbindMouseAction(4100);
        if (this.simulator != null && this.b != null) {
            this.b.unbindName(4370, null);
            this.b.bindAction(4370, 15);
        }
    }

    public void clear() {
        this.simulationPhase = 0;
        this.resetNeeded = true;
        super.clear();
    }

    public void dispose() {
        if (Logger.debugging) {
            Logger.debug((String)"ActionManagerMT -- dispose");
        }
        this.doneHere = true;
        if (this.adapter != null) {
            this.adapter.dispose();
        }
        if (this.simulator != null) {
            this.simulator.dispose();
        }
        super.dispose();
    }

    private static String getEventName(int i) {
        try {
            return eventNames[i];
        }
        catch (Exception e) {
            return "?";
        }
    }

    public Lst<GestureType> getAllowedGestures(int groupID) {
        if (groupID != this.groupID || !this.vwr.getBoolean(603979784)) {
            return null;
        }
        Lst list = new Lst();
        list.addLast((Object)TWO_POINT_GESTURE);
        list.addLast((Object)SINGLE_POINT_GESTURE);
        return list;
    }

    @Override
    public int getGroupID(int x, int y) {
        int gid = 0;
        try {
            if (this.vwr.hasFocus() && x >= 0 && y >= 0 && x < this.vwr.getScreenWidth() && y < this.vwr.getScreenHeight()) {
                gid = this.groupID;
            }
            if (this.resetNeeded) {
                gid |= 0x10000000;
                this.resetNeeded = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gid;
    }

    @Override
    public void processMultitouchEvent(int groupID, int eventType, int touchID, int iData, P3 pt, long time) {
        if (Logger.debugging) {
            Logger.debug((String)(this + " time=" + time + " groupID=" + groupID + " " + Integer.toHexString(groupID) + " eventType=" + eventType + "(" + ActionManagerMT.getEventName(eventType) + ") iData=" + iData + " pt=" + pt));
        }
        switch (eventType) {
            case 0: {
                if (iData != 2) break;
                this.setMotion(13, true);
                this.vwr.translateXYBy((int)pt.x, (int)pt.y);
                this.logEvent("Drag", pt);
                break;
            }
            case -2: {
                if (this.simulator == null) {
                    this.haveMultiTouchInput = false;
                }
                Logger.error((String)"SparshUI reports no driver present");
                this.vwr.log("SparshUI reports no driver present -- setting haveMultiTouchInput FALSE");
                break;
            }
            case 1: {
                this.setMotion(13, true);
                this.vwr.rotateZBy((int)pt.z, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Rotate", pt);
                break;
            }
            case -1: {
                this.vwr.log("Jmol SparshUI client reports service lost -- " + (this.doneHere ? "not " : "") + " restarting");
                if (this.doneHere) break;
                this.startSparshUIService(this.simulator != null);
                break;
            }
            case 3: {
                this.haveMultiTouchInput = true;
                if (touchID == Integer.MAX_VALUE) {
                    this.mouseDown = false;
                    this.clearMouseInfo();
                    break;
                }
                switch (iData) {
                    case 0: {
                        this.mouseDown = true;
                        super.mouseAction(4, time, (int)pt.x, (int)pt.y, 0, 16);
                        break;
                    }
                    case 2: {
                        super.mouseAction(this.mouseDown ? 1 : 0, time, (int)pt.x, (int)pt.y, 0, 16);
                        break;
                    }
                    case 1: {
                        this.mouseDown = false;
                        super.mouseAction(5, time, (int)pt.x, (int)pt.y, 0, 16);
                        break;
                    }
                    case 3: {
                        super.mouseAction(2, time, (int)pt.x, (int)pt.y, 1, 16);
                    }
                }
                break;
            }
            case 4: {
                float scale = pt.z;
                if (scale != -1.0f && scale != 1.0f) break;
                this.zoomByFactor((int)scale, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Zoom", pt);
            }
        }
    }

    private void logEvent(String type, P3 pt) {
        if (!this.vwr.g.logGestures) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastLogTime > 10000L) {
            this.vwr.log("$NOW$ multitouch " + type + " pt= " + pt);
            this.lastLogTime = time;
        }
    }

    public void mouseAction(int mode, long time, int x, int y, int count, int modifiers) {
        switch (mode) {
            case 0: {
                if (this.haveMultiTouchInput) {
                    return;
                }
                this.adapter.mouseMoved(x, y);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 1: {
                if (this.simulator == null || this.simulationPhase <= 0) break;
                this.setCurrent(time, x, y, modifiers);
                this.simulator.mouseDragged(time, x, y);
                return;
            }
            case 4: {
                if (this.simulator == null) break;
                int maction = Binding.getMouseAction((int)1, (int)modifiers, (int)mode);
                if (this.b.isBound(maction, 15)) {
                    this.setCurrent(0L, x, y, modifiers);
                    this.vwr.setFocus();
                    if (this.simulationPhase++ == 0) {
                        this.simulator.startRecording();
                    }
                    this.simulator.mousePressed(time, x, y);
                    return;
                }
                this.simulationPhase = 0;
                break;
            }
            case 5: {
                if (this.simulator == null || this.simulationPhase <= 0) break;
                this.setCurrent(time, x, y, modifiers);
                this.vwr.spinXYBy(0, 0, 0.0f);
                this.simulator.mouseReleased(time, x, y);
                if (this.simulationPhase >= 2) {
                    this.resetNeeded = true;
                    this.simulator.endRecording();
                    this.simulationPhase = 0;
                }
                return;
            }
        }
        if (!this.haveMultiTouchInput) {
            super.mouseAction(mode, time, x, y, count, modifiers);
        }
    }

    protected float getDegrees(float delta, boolean isX) {
        return delta / (float)(isX ? this.vwr.getScreenWidth() : this.vwr.getScreenHeight()) * 180.0f * this.mouseDragFactor;
    }
}

