/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class AnalogSwitchElm
extends CircuitElm {
    final int FLAG_INVERT = 1;
    double resistance;
    double r_on = 20.0;
    double r_off = 1.0E10;
    boolean open;
    Point ps;
    Point point3;
    Point lead3;

    public AnalogSwitchElm(int n, int n2) {
        super(n, n2);
    }

    public AnalogSwitchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        try {
            this.r_on = new Double(stringTokenizer.nextToken());
            this.r_off = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String dump() {
        return super.dump() + " " + this.r_on + " " + this.r_off;
    }

    int getDumpType() {
        return 159;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.ps = new Point();
        int n = 16;
        this.point3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n));
        this.lead3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n / 2));
    }

    void draw(Graphics graphics) {
        int n = 16;
        int n2 = this.open ? n : 0;
        this.setBbox(this.point1, this.point2, n);
        this.draw2Leads(graphics);
        graphics.setColor(lightGrayColor);
        this.interpPoint(this.lead1, this.lead2, this.ps, 1.0, n2);
        AnalogSwitchElm.drawThickLine(graphics, this.lead1, this.ps);
        this.setVoltageColor(graphics, this.volts[2]);
        AnalogSwitchElm.drawThickLine(graphics, this.point3, this.lead3);
        if (!this.open) {
            this.doDots(graphics);
        }
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        this.current = (this.volts[0] - this.volts[1]) / this.resistance;
    }

    boolean nonLinear() {
        return true;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
    }

    void doStep() {
        boolean bl = this.open = this.volts[2] < 2.5;
        if ((this.flags & 1) != 0) {
            this.open = !this.open;
        }
        this.resistance = this.open ? this.r_off : this.r_on;
        sim.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
    }

    void drag(int n, int n2) {
        n = sim.snapGrid(n);
        n2 = sim.snapGrid(n2);
        if (AnalogSwitchElm.abs(this.x - n) < AnalogSwitchElm.abs(this.y - n2)) {
            n = this.x;
        } else {
            n2 = this.y;
        }
        int n3 = AnalogSwitchElm.abs(this.x - n) + AnalogSwitchElm.abs(this.y - n2);
        int n4 = n3 / 2 % AnalogSwitchElm.sim.gridSize;
        if (n4 != 0) {
            return;
        }
        this.x2 = n;
        this.y2 = n2;
        this.setPoints();
    }

    int getPostCount() {
        return 3;
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.point2 : this.point3);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "analog switch";
        stringArray[1] = this.open ? "open" : "closed";
        stringArray[2] = "Vd = " + AnalogSwitchElm.getVoltageDText(this.getVoltageDiff());
        stringArray[3] = "I = " + AnalogSwitchElm.getCurrentDText(this.getCurrent());
        stringArray[4] = "Vc = " + AnalogSwitchElm.getVoltageText(this.volts[2]);
    }

    boolean getConnection(int n, int n2) {
        return n != 2 && n2 != 2;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Normally closed", (this.flags & 1) != 0);
            return editInfo;
        }
        if (n == 1) {
            return new EditInfo("On Resistance (ohms)", this.r_on, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Off Resistance (ohms)", this.r_off, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            int n2 = this.flags = editInfo.checkbox.getState() ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        }
        if (n == 1 && editInfo.value > 0.0) {
            this.r_on = editInfo.value;
        }
        if (n == 2 && editInfo.value > 0.0) {
            this.r_off = editInfo.value;
        }
    }
}

