/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class LEDMatrixElm
extends ChipElm {
    private static final int size = 8;
    private static final double resistance = 100.0;
    private boolean negateRows = false;
    private boolean negateColumns = false;
    private double colorR = 1.0;
    private double colorG = 0.0;
    private double colorB = 0.0;

    public LEDMatrixElm(int n, int n2) {
        super(n, n2);
    }

    public LEDMatrixElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.negateRows = new Boolean(stringTokenizer.nextToken());
        this.negateColumns = new Boolean(stringTokenizer.nextToken());
        this.colorR = new Double(stringTokenizer.nextToken());
        this.colorG = new Double(stringTokenizer.nextToken());
        this.colorB = new Double(stringTokenizer.nextToken());
    }

    String getChipName() {
        return "LED Matrix";
    }

    void setupPins() {
        this.sizeX = 8;
        this.sizeY = 8;
        this.pins = new ChipElm.Pin[16];
        this.pins[0] = new ChipElm.Pin(0, 2, "");
        this.pins[1] = new ChipElm.Pin(1, 2, "");
        this.pins[2] = new ChipElm.Pin(2, 2, "");
        this.pins[3] = new ChipElm.Pin(3, 2, "");
        this.pins[4] = new ChipElm.Pin(4, 2, "");
        this.pins[5] = new ChipElm.Pin(5, 2, "");
        this.pins[6] = new ChipElm.Pin(6, 2, "");
        this.pins[7] = new ChipElm.Pin(7, 2, "");
        this.pins[8] = new ChipElm.Pin(0, 1, "");
        this.pins[9] = new ChipElm.Pin(1, 1, "");
        this.pins[10] = new ChipElm.Pin(2, 1, "");
        this.pins[11] = new ChipElm.Pin(3, 1, "");
        this.pins[12] = new ChipElm.Pin(4, 1, "");
        this.pins[13] = new ChipElm.Pin(5, 1, "");
        this.pins[14] = new ChipElm.Pin(6, 1, "");
        this.pins[15] = new ChipElm.Pin(7, 1, "");
    }

    void draw(Graphics graphics) {
        this.drawChip(graphics);
        Color color = new Color((int)(this.colorR * 255.0), (int)(this.colorG * 255.0), (int)(this.colorB * 255.0));
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = this.x + 2 * (i + 1) * this.cspc;
                int n2 = this.y + 2 * j * this.cspc;
                int n3 = this.cspc / 2;
                if (this.negateRows ^ this.pins[j].value && this.negateColumns ^ this.pins[i + 8].value) {
                    graphics.setColor(color);
                    graphics.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
                }
                graphics.setColor(Color.gray);
                n3 = 3 * this.cspc / 4;
                LEDMatrixElm.drawThickCircle(graphics, n, n2, n3);
            }
        }
    }

    public EditInfo getEditInfo(int n) {
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Negate rows", this.negateRows);
            return editInfo;
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Negate columns", this.negateColumns);
            return editInfo;
        }
        if (n == 4) {
            return new EditInfo("Red Value (0-1)", this.colorR, 0.0, 1.0).setDimensionless();
        }
        if (n == 5) {
            return new EditInfo("Green Value (0-1)", this.colorG, 0.0, 1.0).setDimensionless();
        }
        if (n == 6) {
            return new EditInfo("Blue Value (0-1)", this.colorB, 0.0, 1.0).setDimensionless();
        }
        return super.getEditInfo(n);
    }

    public void setEditValue(int n, EditInfo editInfo) {
        super.setEditValue(n, editInfo);
        if (n == 2) {
            this.negateRows = editInfo.checkbox.getState();
        }
        if (n == 3) {
            this.negateColumns = editInfo.checkbox.getState();
        }
        if (n == 4) {
            this.colorR = editInfo.value;
        }
        if (n == 5) {
            this.colorG = editInfo.value;
        }
        if (n == 6) {
            this.colorB = editInfo.value;
        }
    }

    int getPostCount() {
        return 16;
    }

    int getVoltageSourceCount() {
        return 0;
    }

    int getDumpType() {
        return 207;
    }

    String dump() {
        return super.dump() + " " + this.negateRows + " " + this.negateColumns + " " + this.colorR + " " + this.colorG + " " + this.colorB;
    }
}

