/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class MemristorElm
extends CircuitElm {
    double r_on;
    double r_off;
    double dopeWidth;
    double totalWidth;
    double mobility;
    double resistance;
    Point ps3;
    Point ps4;

    public MemristorElm(int n, int n2) {
        super(n, n2);
        this.r_on = 100.0;
        this.r_off = 160.0 * this.r_on;
        this.dopeWidth = 0.0;
        this.totalWidth = 1.0E-8;
        this.mobility = 1.0E-10;
        this.resistance = 100.0;
    }

    public MemristorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.r_on = new Double(stringTokenizer.nextToken());
        this.r_off = new Double(stringTokenizer.nextToken());
        this.dopeWidth = new Double(stringTokenizer.nextToken());
        this.totalWidth = new Double(stringTokenizer.nextToken());
        this.mobility = new Double(stringTokenizer.nextToken());
        this.resistance = 100.0;
    }

    int getDumpType() {
        return 109;
    }

    String dump() {
        return super.dump() + " " + this.r_on + " " + this.r_off + " " + this.dopeWidth + " " + this.totalWidth + " " + this.mobility;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.ps3 = new Point();
        this.ps4 = new Point();
    }

    void draw(Graphics graphics) {
        int n = 6;
        int n2 = 0;
        double d = this.volts[0];
        double d2 = this.volts[1];
        int n3 = 2 + (int)(8.0 * (1.0 - this.dopeWidth / this.totalWidth));
        this.setBbox(this.point1, this.point2, n3);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        double d3 = 1.0 / (double)n;
        for (int i = 0; i <= n; ++i) {
            int n4;
            int n5 = n4 = (i & 1) == 0 ? 1 : -1;
            if (i == n) {
                n4 = 0;
            }
            double d4 = d + (d2 - d) * (double)i / (double)n;
            this.setVoltageColor(graphics, d4);
            this.interpPoint(this.lead1, this.lead2, ps1, (double)i * d3, n3 * n2);
            this.interpPoint(this.lead1, this.lead2, ps2, (double)i * d3, n3 * n4);
            MemristorElm.drawThickLine(graphics, ps1, ps2);
            if (i == n) break;
            this.interpPoint(this.lead1, this.lead2, ps1, (double)(i + 1) * d3, n3 * n4);
            MemristorElm.drawThickLine(graphics, ps1, ps2);
            n2 = n4;
        }
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    boolean nonLinear() {
        return true;
    }

    void calculateCurrent() {
        this.current = (this.volts[0] - this.volts[1]) / this.resistance;
    }

    void reset() {
        this.dopeWidth = 0.0;
    }

    void startIteration() {
        double d = this.dopeWidth / this.totalWidth;
        this.dopeWidth += MemristorElm.sim.timeStep * this.mobility * this.r_on * this.current / this.totalWidth;
        if (this.dopeWidth < 0.0) {
            this.dopeWidth = 0.0;
        }
        if (this.dopeWidth > this.totalWidth) {
            this.dopeWidth = this.totalWidth;
        }
        this.resistance = this.r_on * d + this.r_off * (1.0 - d);
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
    }

    void doStep() {
        sim.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "memristor";
        this.getBasicInfo(stringArray);
        stringArray[3] = "R = " + MemristorElm.getUnitText(this.resistance, CirSim.ohmString);
        stringArray[4] = "P = " + MemristorElm.getUnitText(this.getPower(), "W");
    }

    double getScopeValue(int n) {
        return n == 2 ? this.resistance : (n == 1 ? this.getPower() : this.getVoltageDiff());
    }

    String getScopeUnits(int n) {
        return n == 2 ? CirSim.ohmString : (n == 1 ? "W" : "V");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Max Resistance (ohms)", this.r_on, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Min Resistance (ohms)", this.r_off, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Width of Doped Region (nm)", this.dopeWidth * 1.0E9, 0.0, 0.0);
        }
        if (n == 3) {
            return new EditInfo("Total Width (nm)", this.totalWidth * 1.0E9, 0.0, 0.0);
        }
        if (n == 4) {
            return new EditInfo("Mobility (um^2/(s*V))", this.mobility * 1.0E12, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.r_on = editInfo.value;
        }
        if (n == 1) {
            this.r_off = editInfo.value;
        }
        if (n == 2) {
            this.dopeWidth = editInfo.value * 1.0E-9;
        }
        if (n == 3) {
            this.totalWidth = editInfo.value * 1.0E-9;
        }
        if (n == 4) {
            this.mobility = editInfo.value * 1.0E-12;
        }
    }
}

